package com.xdja.multichip.process.tfcard;

import android.content.Intent;
import android.os.Handler;
import android.os.Messenger;

import com.xdja.multichip.process.CardProcessService;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperThreadRun;
import com.xdja.multichip.process.board.OnboardProcessReceiver;

/**
 * 操作信大捷安TF芯片的service
 * <p>
 * author: wzg@xdja.com <br/>
 * date:   2017/6/6 <br/>
 */
public class TFProcessService extends CardProcessService {
    private Messenger messenger = new Messenger(new Handler());

    @Override
    public void onCreate() {
        super.onCreate();
        receiverStartUpCardProcessReceiver(new TFProcessReceiver());
        SuperThreadRun.service.submit(new Runnable() {
            @Override
            public void run() {
                TFJniApiHandle.getInstance().getCurrentTFCardInfo(getApplicationContext());
            }
        });
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        SuperThreadRun.service.submit(new Runnable() {
            @Override
            public void run() {
                JarMultiChipStatusManager.getInstance().cardProcessRegister(getApplicationContext(), messenger.getBinder(), JniApiParam.TYPE_TF);
            }
        });

        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

}

