package com.xdja.multichip.process.vhsm.net;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.process.CardProcessService;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.ProcessExitsReceiver;

import java.util.ArrayList;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/11/16 <br/>
 */
public class NetVhsmProcessProvider extends ContentProvider {
    public static final String TAG = "NetVhsmProcessTag";


    @Override
    public boolean onCreate() {
        Log.e(TAG, "onCreate pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + getCallingPackage());

        if (!MultiJniApiConfig.getInstance(getContext()).judgeChipCanUse(NetVhsmChipForCall.NAME_PROCESS_NETVHSM)) {
            return false;
        }
        CardProcessService.startService(getContext(), new Intent(getContext(), NetVhsmService.class));

        ProcessExitsReceiver.register(getContext());

        if (getCallingPackage() == null){
            Log.e(TAG,"getCallingPackage = null");
            NetVhsmJniApiHandle.getInstance().getNetVhsm(getContext());
        }
        return false;
    }


    @Override
    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        return null;
    }


    @Override
    public String getType(Uri uri) {
        return null;
    }


    @Override
    public Uri insert(Uri uri, ContentValues values) {
        return null;
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        return 0;
    }

    @Override
    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        return 0;
    }


    @Override
    public Bundle call(String method, String arg, Bundle extras) {
        Log.e(TAG, "call method: " + method);
        Log.e(TAG, "calling pid " + Binder.getCallingPid() + "  uid = " + Binder.getCallingUid() + " pkgName = " + getCallingPackage());
        if (ParamKeywords.KEY_METHOD_GetJniApiBinder.equals(method)) {
            Bundle bundle = new Bundle();
            if (TextUtils.isEmpty(arg) || TextUtils.isEmpty(ParamKeywords.KEY_String_GetDefaultVhsm)) {
                ArrayList<Bundle> list = new ArrayList<>();

                Bundle defaultVhsm = NetVhsmJniApiHandle.getInstance().getNetVhsm(getContext());
                if (defaultVhsm != null) {
                    list.add(defaultVhsm);
                }
                bundle.putInt(ParamKeywords.KEY_int_ret, 0);
                bundle.putParcelableArrayList(ParamKeywords.KEY_Parcelable_JniApiParam, list);
                Log.e(TAG, "result list size = " + list.size());
            }
            return bundle;
        }
        return super.call(method, arg, extras);
    }
}
