package com.xdja.multichip.utils;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;

/**
 * Created by xwy on 2017/9/26.
 */

public class SharedPreferencesUtil {

    private static final String FILE_NAME_MAX_PIN_TRY_COUNT = "maxpintrycount";
    private static final String FILE_NAME_CARDID_TYPE = "cardid_type";

    /**
     * 设置PIN码最大重试次数
     *
     * @param context
     * @param cardId
     * @param role
     * @param count
     * @return
     */
    public static boolean setPinTryCount(Context context, String cardId, int role, int count) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(FILE_NAME_MAX_PIN_TRY_COUNT, Activity.MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(cardId + role, count);
        return editor.commit();
    }


    /**
     * 读取PIN码最大重试次数
     *
     * @param context
     * @param cardId
     * @param role
     * @return 默认值-1
     */
    public static int getPinTryCount(Context context, String cardId, int role) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(FILE_NAME_MAX_PIN_TRY_COUNT, Activity.MODE_PRIVATE);
        return sharedPreferences.getInt(cardId + role, -1);
    }

    /**
     * 存储卡号和类型
     *
     * @param context
     * @param cardId
     * @param type
     */
    public static void saveCardIdAndType(Context context, String cardId, int type) {
        SharedPreferences preferences = context.getSharedPreferences(FILE_NAME_CARDID_TYPE, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putInt(cardId, type);
        editor.apply();
    }

    /**
     * 获取卡类型
     *
     * @param context
     * @param cardId
     * @return
     */
    public static int getCardType(Context context, String cardId) {
        SharedPreferences preferences = context.getSharedPreferences(FILE_NAME_CARDID_TYPE, Context.MODE_PRIVATE);
        return preferences.getInt(cardId, -1);
    }

    /**
     * 设置贴膜卡日志是否下次程序重启后还有效性
     *
     * @param context
     * @param flag
     */
    public static void setCcPersistence(Context context, boolean flag) {
        SharedPreferences preferences = context.getSharedPreferences(FILE_NAME_CARDID_TYPE, Context.MODE_PRIVATE);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putBoolean("CcPersistence", flag);
        editor.apply();
    }

    /**
     * 获取贴膜卡日志是否打印的标志位
     *
     * @param context
     * @return
     */
    public static boolean getCcPersistence(Context context) {
        SharedPreferences preferences = context.getSharedPreferences(FILE_NAME_CARDID_TYPE, Context.MODE_PRIVATE);
        return preferences.getBoolean("CcPersistence", false);
    }

}
