/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;
import com.xdja.multichip.JNIPinManager;
import com.xdja.multichip.jniapi.Arithmetic;
import com.xdja.multichip.process.SuperHandleContainer;
import com.xdja.multichip.process.SuperJniApiBinder;
import com.xdja.multichip.process.SupertImportCert;
import com.xdja.multichip.utils.GetValueFromProperties;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class SuperHandleMethod {
    private static SuperHandleMethod instance;
    private static final Object PRE_HANDLE_OBJ;
    private Boolean isCanHandleExtraMethod = null;
    private String extraMethodClassName = null;
    private Method extraCallMethod = null;
    private Object extraObject = null;

    private SuperHandleMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SuperHandleMethod getInstance() {
        if (instance != null) return instance;
        Class<SuperHandleMethod> clazz = SuperHandleMethod.class;
        synchronized (SuperHandleMethod.class) {
            if (instance != null) return instance;
            instance = new SuperHandleMethod();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Bundle callMethod(SuperJniApiBinder binder, Bundle bundle) {
        Bundle result = new Bundle();
        try {
            if (bundle == null) {
                return null;
            }
            if (bundle.containsKey("method")) {
                String method = bundle.getString("method");
                if ("UnlockPinUseUsn".equals(method)) {
                    return this.UnlockPinUseUsn(binder, bundle);
                }
                if ("importCert".equals(method)) {
                    return new SupertImportCert().importCert(binder, bundle);
                }
                if ("createContainer".equals(method)) {
                    return this.createContainer(binder, bundle);
                }
                if ("genSM2KeyPair".equals(method)) {
                    return this.genSignSM2KeyPair(binder, bundle);
                }
                if ("genExchangeSM2KeyPair".equals(method)) {
                    return this.genExchangeSM2KeyPair(binder, bundle);
                }
                if ("genRSAKeyPair".equals(method)) {
                    return this.genSignRSAKeyPair(binder, bundle);
                }
                if ("genExchangeRSAKeyPair".equals(method)) {
                    return this.genExchangeRSAKeyPair(binder, bundle);
                }
                if ("clearContainer".equals(method)) {
                    return this.clearContainer(binder, bundle);
                }
                if ("SendClientProxy".equals(method)) {
                    return this.addClientProxy(binder, bundle);
                }
                Bundle extraResult = this.extraMethodHandle(binder.mContext, binder, bundle);
                if (extraResult != null) {
                    return extraResult;
                }
            }
            result.putInt("ret", -10027);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.putInt("ret", -10001);
        }
        return result;
    }

    public Bundle UnlockPinUseUsn(SuperJniApiBinder binder, Bundle bundle) {
        int role = bundle.getInt("role");
        byte[] usn = bundle.getByteArray("usn");
        byte[] usnlockCode = bundle.getByteArray("usnlockCode");
        byte[] newPin = bundle.getByteArray("newPin");
        int ret = JNIPinManager.getInstance().XdjaUnlockPinUseUsn(binder.getApi(), binder.mHandle, role, usn, usnlockCode, newPin);
        Bundle result = new Bundle();
        result.putInt("ret", ret);
        return result;
    }

    public Bundle createContainer(SuperJniApiBinder binder, Bundle bundle) {
        int ret;
        Bundle result = new Bundle();
        try {
            int role = bundle.getInt("role");
            String pin = bundle.getString("pin");
            int containerId = bundle.getInt("containerId");
            if ((containerId == 4 || containerId == 6) && role != 4 && role != 17) {
                result.putInt("ret", -15);
                return result;
            }
            ret = binder.VerifyPIN(binder.mHandle, role, pin.getBytes(), pin.length());
            if (ret != 0) {
                result.putInt("ret", ret);
                return result;
            }
            String containerName = bundle.getString("containerName");
            ret = new SuperHandleContainer().createContainer(binder, containerId, containerName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            ret = -10001;
        }
        result.putInt("ret", ret);
        return result;
    }

    public Bundle genSignSM2KeyPair(SuperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt("containerId");
        byte[] pubFid = Arithmetic.getSignPubKeyFid((int)containerId);
        byte[] priFid = Arithmetic.getSignPriKeyFid((int)containerId);
        return this.genSM2KeyPair(binder, pubFid, priFid);
    }

    public Bundle genExchangeSM2KeyPair(SuperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt("containerId");
        byte[] pubFid = Arithmetic.getExchangePubKeyFid((int)containerId);
        byte[] priFid = Arithmetic.getExchangePriKeyFid((int)containerId);
        return this.genSM2KeyPair(binder, pubFid, priFid);
    }

    private Bundle genSM2KeyPair(SuperJniApiBinder binder, byte[] pubFid, byte[] priFid) {
        int ret;
        try {
            ret = binder.GenSM2KeyPair(binder.mHandle, pubFid, priFid, null, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            ret = -10001;
        }
        Bundle result = new Bundle();
        result.putInt("ret", ret);
        return result;
    }

    public Bundle genSignRSAKeyPair(SuperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt("containerId");
        int bits = bundle.getInt("bits");
        byte[] pubFid = Arithmetic.getSignPubKeyFid((int)containerId);
        byte[] priFid = Arithmetic.getSignPriKeyFid((int)containerId);
        return this.genRsaKeyPair(binder, bits, pubFid, priFid);
    }

    public Bundle genExchangeRSAKeyPair(SuperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt("containerId");
        int bits = bundle.getInt("bits");
        byte[] pubFid = Arithmetic.getExchangePubKeyFid((int)containerId);
        byte[] priFid = Arithmetic.getExchangePriKeyFid((int)containerId);
        return this.genRsaKeyPair(binder, bits, pubFid, priFid);
    }

    private Bundle genRsaKeyPair(SuperJniApiBinder binder, int bits, byte[] pubFid, byte[] priFid) {
        int ret;
        try {
            ret = binder.GenRSAKeyPair(binder.mHandle, bits, pubFid, priFid, null, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            ret = -10001;
        }
        Bundle result = new Bundle();
        result.putInt("ret", ret);
        return result;
    }

    public Bundle clearContainer(SuperJniApiBinder binder, Bundle bundle) {
        Bundle result = new Bundle();
        int containerId = bundle.getInt("containerId", -1);
        int role = bundle.getInt("role");
        String pin = bundle.getString("pin", "");
        try {
            byte[] exchangeCertFid = Arithmetic.getExchangeCertFid((int)containerId);
            byte[] signCertFid = Arithmetic.getSignCertFid((int)containerId);
            byte[] exchangePubFid = Arithmetic.getExchangePubKeyFid((int)containerId);
            byte[] exchangePriFid = Arithmetic.getExchangePriKeyFid((int)containerId);
            byte[] signPubFid = Arithmetic.getSignPubKeyFid((int)containerId);
            byte[] signPriFid = Arithmetic.getSignPriKeyFid((int)containerId);
            ArrayList<Pair> list = new ArrayList<Pair>();
            list.add(Pair.create((Object)exchangeCertFid, (Object)1));
            list.add(Pair.create((Object)exchangePubFid, (Object)2));
            list.add(Pair.create((Object)exchangePriFid, (Object)2));
            list.add(Pair.create((Object)signCertFid, (Object)1));
            list.add(Pair.create((Object)signPubFid, (Object)2));
            list.add(Pair.create((Object)signPriFid, (Object)2));
            byte[] certBytes = new byte[200];
            byte[] keyBytes = new byte[200];
            Arrays.fill(certBytes, (byte)-1);
            Arrays.fill(keyBytes, (byte)-1);
            int ret = binder.VerifyPIN(binder.mHandle, role, pin.getBytes(), pin.length());
            if (ret != 0) {
                result.putInt("ret", ret);
                return result;
            }
            for (Pair pair : list) {
                byte[] writeBytes = (Integer)pair.second == 1 ? certBytes : keyBytes;
                ret = binder.WriteFile(binder.mHandle, (byte[])pair.first, 0, writeBytes.length, writeBytes);
                if (ret == 0) continue;
                result.putInt("ret", ret);
                return result;
            }
            byte[] containerInfo = new byte[5];
            Arrays.fill(containerInfo, (byte)0);
            byte[] infoFid = new byte[]{0, 3};
            int writePos = containerId * 5;
            ret = binder.WriteFile(binder.mHandle, infoFid, writePos, 5, containerInfo);
            result.putInt("ret", ret);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            result.putInt("ret", -10001);
        }
        return result;
    }

    private Bundle addClientProxy(SuperJniApiBinder binder, Bundle bundle) {
        IBinder messenger = bundle.getBinder("messenger");
        binder.addClientProxy(messenger);
        Bundle result = new Bundle();
        result.putInt("ret", 0);
        return result;
    }

    private Bundle extraMethodHandle(Context context, SuperJniApiBinder binder, Bundle bundle) {
        if (this.isCanHandleExtraMethod == null) {
            this.extraMethodClassName = GetValueFromProperties.getValue(context, "MultiChipExtra.properties", "className");
            this.isCanHandleExtraMethod = TextUtils.isEmpty((CharSequence)this.extraMethodClassName) ? Boolean.valueOf(false) : Boolean.valueOf(true);
        }
        if (!this.isCanHandleExtraMethod.booleanValue()) {
            return null;
        }
        try {
            this.preHandleInit(context, this.extraMethodClassName);
            return (Bundle)this.extraCallMethod.invoke(this.extraObject, new Object[]{binder, bundle});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preHandleInit(Context context, String className) {
        Object object = PRE_HANDLE_OBJ;
        synchronized (object) {
            if (this.extraCallMethod != null) {
                return;
            }
            try {
                Class<?> aClass = Class.forName(className);
                Method getInstance = aClass.getDeclaredMethod("getInstance", Context.class);
                this.extraObject = getInstance.invoke(null, context);
                this.extraCallMethod = aClass.getDeclaredMethod("callMethod", SuperJniApiBinder.class, Bundle.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.isCanHandleExtraMethod = false;
            }
        }
    }

    static {
        PRE_HANDLE_OBJ = new Object();
    }
}

