/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.util.Log;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.MultiJniApiConfig;
import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperThreadRun;
import com.xdja.multichip.process.coveredcard.CCJniApi;
import com.xdja.multichip.process.coveredcard.CCJniApiBinder;
import java.util.ArrayList;

public class CCJniApiHandle
extends SuperThreadRun<ArrayList<Bundle>> {
    private static final String TAG = "CCJniApiHandleTag";
    private static CCJniApiHandle instance;
    private Context context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CCJniApiHandle getInstance() {
        if (instance != null) return instance;
        Class<CCJniApiHandle> clazz = CCJniApiHandle.class;
        synchronized (CCJniApiHandle.class) {
            if (instance != null) return instance;
            instance = new CCJniApiHandle();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected ArrayList<Bundle> getCurrentCoveredCardInfo(Context context) {
        this.context = context;
        return (ArrayList)this.getResult();
    }

    @Override
    protected ArrayList<Bundle> getRunResult() {
        JniApiParam param;
        ArrayList<Bundle> list = new ArrayList<Bundle>();
        if (this.context == null) {
            Log.e((String)TAG, (String)"getRunResult context = null");
            return list;
        }
        if (!MultiJniApiConfig.getInstance(this.context).judgeChipCanUse("coveredcard")) {
            return list;
        }
        CCJniApiBinder binder = CCJniApiBinder.getInstance(this.context);
        CCJniApi ccJniApi = (CCJniApi)binder.getApi();
        if (ccJniApi != null) {
            XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
            int ret = ccJniApi.GetDevInfoPri(-1L, devInfo);
            Log.e((String)TAG, (String)("ccJniApi GetDevInfoPri ret = " + ret));
            if (ret == 0) {
                param = new JniApiParam();
                param.chipType = binder.getChipType();
                param.cardId = new String(devInfo.cardid).trim();
            } else {
                param = binder.getJniApiParam();
            }
        } else {
            param = binder.getJniApiParam();
        }
        if (param != null) {
            Log.e((String)TAG, (String)"param has values!");
            JarMultiChipStatusManager.getInstance().sendCardStatus(this.context, param.cardId, param.chipType, 1);
            Bundle bundle = new Bundle();
            bundle.putBinder("Binder", (IBinder)binder);
            bundle.putParcelable("JniApiParam", (Parcelable)param);
            list.add(bundle);
        } else {
            Log.e((String)TAG, (String)"param is null");
        }
        return list;
    }
}

