/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.os.Environment;
import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.process.SuperChipForCall;
import com.xdja.multichip.process.vhsm.net.NetVhsmProcessProvider;
import com.xdja.multichip.utils.PermissionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@AutoChipForCall
public class NetVhsmChipForCall
extends SuperChipForCall {
    public static final String NAME_PROCESS_NETVHSM = "netVhsm";
    static final String FILE_DIR = "xdja/vhsm/net/";
    static final String RANDFILEPATH = "xdja/vhsm/net/rand.bin";
    static final String KDATFILEPATH = "xdja/vhsm/net/vhsm.dat";
    static final String WBOXFILEPATH = "xdja/vhsm/net/wbox.lib";
    static final String VHSMLIBFILEPATH = "xdja/vhsm/net/vhsm.lib";

    @Override
    protected Class getProviderClass() {
        return NetVhsmProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_NETVHSM;
    }

    @Override
    public boolean isCanUse() {
        ArrayList<String> permissions = new ArrayList<String>();
        permissions.add("android.permission.READ_PHONE_STATE");
        permissions.add("android.permission.READ_EXTERNAL_STORAGE");
        permissions.add("android.permission.WRITE_EXTERNAL_STORAGE");
        List<String> deniedPermissions = PermissionUtil.getDeniedPermissions(this.context, permissions);
        if (deniedPermissions.size() > 0) {
            return false;
        }
        File storageDir = Environment.getExternalStorageDirectory();
        File randFile = new File(storageDir, RANDFILEPATH);
        if (!randFile.exists()) {
            return false;
        }
        File wboxFile = new File(storageDir, WBOXFILEPATH);
        if (!wboxFile.exists()) {
            return false;
        }
        File kdatFile = new File(storageDir, KDATFILEPATH);
        return kdatFile.exists();
    }

    @Override
    public int getChipType() {
        return 32;
    }

    @Override
    public void setContext(Context context) {
        this.context = context;
    }
}

