/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.xdja.multichip.IMultiChip;
import com.xdja.multichip.param.ChipParam;
import com.xdja.multichip.process.bluetooth.BluetoothKeyProcessService;
import com.xdja.multichip.process.board.OnboardProcessProvider;
import com.xdja.multichip.process.tfcard.TFProcessProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class MultiChip
extends IMultiChip.Stub {
    public static final String KEY_BINDER_BINDER = "Binder";
    public static final String KEY_PARCELABLE_CHIPPARAM = "ChipParam";
    private static final String NAME_PROCESS_ONBOARD = "onboard";
    private static final String NAME_PROCESS_TF = "TF";
    private static final String NAME_PROCESS_BLUETOOTH = "bluetooth";
    private static HashMap<String, String> providerNameMap = new HashMap();
    private static final int WAIT_TIMEOUT = 3;
    private static ArrayList<String> hasChipDevList = new ArrayList();
    private static ArrayList<String> hasNotTFDevList = new ArrayList();
    private static MultiChip instance;
    private Context context;
    private HashMap<String, CountDownLatch> latchMap = new HashMap(0);
    private HashMap<String, Pair<String, List<Bundle>>> tmpLatchTagMap = new HashMap(0);
    private ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    private long lastCall = 0L;
    List<Bundle> lastRusult = new ArrayList<Bundle>();
    private static final int FLAG_ONBOARD_CHIP_EXIST = 1;
    private static final int FLAG_ONBOARD_CHIP_NOT_EXIST = -1;
    private static final int FLAG_ONBOARD_CHIP_UNKNOW = 0;
    private int onboardChipIsExist = 0;
    private int bluetoothFlag = 0;
    private BroadcastReceiver bluetoothReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int blueState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
            if (10 == blueState) {
                Intent stopIntent = new Intent();
                stopIntent.setClassName(context.getPackageName(), BluetoothKeyProcessService.class.getName());
                context.stopService(stopIntent);
            }
        }
    };

    private MultiChip(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MultiChip getInstance(Context context) {
        if (instance != null) return instance;
        Class<MultiChip> clazz = MultiChip.class;
        synchronized (MultiChip.class) {
            if (instance != null) return instance;
            instance = new MultiChip(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public synchronized List<Bundle> getChipInfo() throws RemoteException {
        return this.getChipInfoUseProvider();
    }

    private List<Bundle> getChipInfoUseProvider() throws RemoteException {
        long curCall = SystemClock.elapsedRealtime();
        if (curCall - this.lastCall < 1000L) {
            return this.lastRusult;
        }
        this.lastRusult.clear();
        List<String> chipProcessList = this.getChipProcessList();
        final CountDownLatch latch = new CountDownLatch(chipProcessList.size());
        Log.d((String)"MultiChip", (String)("chipProcessList size: " + chipProcessList.size()));
        for (final String chipProcess : chipProcessList) {
            final String name = this.convertToProviderName(chipProcess);
            if (TextUtils.isEmpty((CharSequence)name)) {
                latch.countDown();
                continue;
            }
            this.cachedThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    ArrayList bundle;
                    int ret;
                    Log.d((String)"MultiChip", (String)(chipProcess + " start"));
                    Uri uri = Uri.parse((String)("content://" + name));
                    ContentResolver resolver = MultiChip.this.context.getContentResolver();
                    Log.v((String)"testTag", (String)uri.toString());
                    Bundle bundleResult = resolver.call(uri, "GetChipBinder", "", null);
                    if (bundleResult != null && (ret = bundleResult.getInt("ret")) == 0 && (bundle = bundleResult.getParcelableArrayList("result")) != null) {
                        for (Bundle singleBundle : bundle) {
                            singleBundle.setClassLoader(ChipParam.class.getClassLoader());
                            if (singleBundle.getParcelable(MultiChip.KEY_PARCELABLE_CHIPPARAM) == null) continue;
                            MultiChip.this.lastRusult.add(singleBundle);
                        }
                    }
                    latch.countDown();
                    Log.d((String)"MultiChip", (String)(chipProcess + " end"));
                }
            });
        }
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.lastCall = SystemClock.elapsedRealtime();
        return this.lastRusult;
    }

    private List<String> getChipProcessList() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.getOnboardChipProcessList());
        result.addAll(this.getTFChipProcessList());
        result.addAll(this.getBluekeyChipProcessList());
        return result;
    }

    private synchronized List<String> getOnboardChipProcessList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.onboardChipIsExist == -1) {
            return list;
        }
        if (this.onboardChipIsExist == 1) {
            list.add(NAME_PROCESS_ONBOARD);
        } else if (this.onboardChipIsExist == 0) {
            boolean flag = this.checkCurDevIsKownHasChip();
            if (flag) {
                this.onboardChipIsExist = 1;
            }
            list.add(NAME_PROCESS_ONBOARD);
        }
        return list;
    }

    private List<String> getTFChipProcessList() {
        String model = Build.MODEL;
        ArrayList<String> result = new ArrayList<String>();
        if (hasNotTFDevList.contains(model)) {
            return result;
        }
        result.add(NAME_PROCESS_TF);
        return result;
    }

    private List<String> getBluekeyChipProcessList() {
        this.regeditBluetoothListener();
        ArrayList<String> result = new ArrayList<String>();
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        int state = adapter.getState();
        if (state == 10 || state == 13) {
            return result;
        }
        result.add(NAME_PROCESS_BLUETOOTH);
        return result;
    }

    private boolean checkCurDevIsKownHasChip() {
        boolean flag = false;
        String model = Build.MODEL;
        if (hasChipDevList.contains(model)) {
            flag = true;
        }
        return flag;
    }

    private synchronized void regeditBluetoothListener() {
        if (this.bluetoothFlag != 0) {
            return;
        }
        this.bluetoothFlag = 1;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        this.context.registerReceiver(this.bluetoothReceiver, filter);
    }

    private String convertToProviderName(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return "";
        }
        return providerNameMap.get(name);
    }

    static {
        hasChipDevList.add("ACTOMA ACE");
        hasChipDevList.add("HUAWEI eH880");
        hasNotTFDevList.add("ACTOMA ACE");
        providerNameMap.put(NAME_PROCESS_ONBOARD, OnboardProcessProvider.class.getName());
        providerNameMap.put(NAME_PROCESS_TF, TFProcessProvider.class.getName());
    }
}

