/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cc;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.xdja.cc.SimStateCallback;

public class SimStateReceive
extends BroadcastReceiver {
    private static final String TAG = "CoverCard";
    private Application mApp;
    private IntentFilter mIntentFilter;
    private boolean mRegisterFlag;
    private static final String SIM_STATE_CHANGED = "android.intent.action.SIM_STATE_CHANGED";
    private SimStateCallback mCallback;

    public SimStateReceive(Application app, SimStateCallback cb) {
        this.mApp = app;
        this.mCallback = cb;
        this.mIntentFilter = new IntentFilter();
        this.mIntentFilter.addAction(SIM_STATE_CHANGED);
        this.mRegisterFlag = false;
        Log.d((String)TAG, (String)"TmcStateReceive init");
    }

    public void onReceive(Context context, Intent intent) {
        Log.d((String)TAG, (String)("onReceive -> " + intent.getAction()));
        if (!intent.getAction().equals(SIM_STATE_CHANGED)) {
            return;
        }
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        int state = tm.getSimState();
        Log.d((String)TAG, (String)("SimStateReceive state = " + state));
        if (state == 5) {
            this.mCallback.InitSmartCard();
            Log.d((String)TAG, (String)"InitSmartCard after SIM_STATE_CHANGED broadcast");
        }
    }

    public boolean hasRegistered() {
        return this.mRegisterFlag;
    }

    public void register() {
        Log.d((String)TAG, (String)"TmcStateReceive register start");
        if (!this.mRegisterFlag && this.mApp != null) {
            this.mApp.registerReceiver((BroadcastReceiver)this, this.mIntentFilter);
            this.mRegisterFlag = true;
            Log.d((String)TAG, (String)"TmcStateReceive register ok");
        }
    }

    public void cancel() {
        if (this.mRegisterFlag && this.mApp != null) {
            this.mApp.unregisterReceiver((BroadcastReceiver)this);
            this.mRegisterFlag = false;
        }
    }
}

