/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.sm2cipher.sm2.cipher;

import com.xdja.cssp.sm2cipher.ec.IntegerConverter;
import com.xdja.cssp.sm2cipher.ec.NamedEllipse;
import com.xdja.cssp.sm2cipher.sm2.ISM2Cipher;
import com.xdja.cssp.sm2cipher.sm2.cipher.Base64Util;
import com.xdja.cssp.sm2cipher.sm2.cipher.ConvertUtil;
import com.xdja.cssp.sm2cipher.sm2.cipher.ECSM2Signer;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM2Encrypt;
import com.xdja.cssp.sm2cipher.sm2.cipher.SM2EncryptGB;
import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;

public class SM2CipherImpl
implements ISM2Cipher {
    private NamedEllipse namedEllipse;

    public SM2CipherImpl() {
        this.namedEllipse = new NamedEllipse();
    }

    public SM2CipherImpl(NamedEllipse namedEllipse) {
        if (namedEllipse == null) {
            namedEllipse = new NamedEllipse();
        }
        this.namedEllipse = namedEllipse;
    }

    @Override
    public byte[] encrypt(String pubkeyBase64, byte[] plainText) {
        if (pubkeyBase64 == null || pubkeyBase64.equals("")) {
            throw new RuntimeException("param error: pubkey is not allowed to be empty");
        }
        if (plainText != null && plainText.length > 0) {
            byte[] keyData;
            byte[] result;
            byte[] cipherText;
            block8: {
                cipherText = null;
                result = null;
                keyData = new byte[65];
                byte[] base64Key = Base64Util.decode(pubkeyBase64.getBytes());
                try {
                    if (base64Key.length >= 91) {
                        System.arraycopy(base64Key, base64Key.length - 65, keyData, 0, 65);
                        break block8;
                    }
                    if (base64Key.length >= 65) {
                        System.arraycopy(base64Key, base64Key.length - 65, keyData, 0, 65);
                        break block8;
                    }
                    if (base64Key.length == 64) {
                        keyData[0] = 4;
                        System.arraycopy(base64Key, 0, keyData, 1, 64);
                        break block8;
                    }
                    throw new RuntimeException("fatal error when encrpty data. reason: pubkey is invalid");
                }
                catch (Exception e2) {
                    throw new RuntimeException("fatal error when encrpty data. reason: pubkey is invalid");
                }
            }
            SM2Encrypt encrypt = new SM2Encrypt(this.namedEllipse);
            cipherText = encrypt.pubkeyEncrypt(plainText, keyData);
            if (cipherText != null && cipherText.length > 0) {
                result = new byte[cipherText.length];
                System.arraycopy(cipherText, 0, result, 0, cipherText.length);
                return result;
            }
        }
        return null;
    }

    @Override
    public byte[] decrypt(String privateBase64, byte[] cipherText) {
        if (privateBase64 == null || privateBase64.equals("")) {
            throw new RuntimeException("param error: private key is not allowed to be empty");
        }
        if (cipherText != null && cipherText.length > 0) {
            if (cipherText.length < 97) {
                throw new RuntimeException("faltal error when decpty data. reason: invalid format of cipherText");
            }
            byte[] result = null;
            byte[] prikey = Base64Util.decode(privateBase64);
            byte[] prikeyValue = new byte[32];
            if (prikey == null || prikey.length != 32 && prikey.length != 33) {
                throw new RuntimeException("faltal error when decpty data. reason: invalid private key, prikey key must be 32 byte");
            }
            System.arraycopy(prikey, prikey.length - 32, prikeyValue, 0, 32);
            SM2Encrypt decrypt = new SM2Encrypt(this.namedEllipse);
            result = decrypt.privateKeyDecrypt(cipherText, prikey);
            return result;
        }
        return null;
    }

    @Override
    public BigInteger[] sign(String prikeyBase64, byte[] message) {
        if (prikeyBase64 == null || prikeyBase64.equals("")) {
            throw new RuntimeException("param error: private key is not allowed to be empty");
        }
        if (message != null && message.length > 0) {
            byte[] prikey = Base64Util.decode(prikeyBase64.getBytes());
            byte[] priKeyData = new byte[32];
            if (prikey == null || prikey.length != 32 && prikey.length != 33) {
                throw new RuntimeException("faltal error when sign data. reason: invalid private key, prikey key must be 32 byte");
            }
            try {
                IntegerConverter converter = new IntegerConverter();
                priKeyData = converter.integerToBytes(new BigInteger(1, prikey), 32);
            }
            catch (Exception e2) {
                throw new RuntimeException("fatal error when sign data. reason: private key is invalid");
            }
            ECSM2Signer signer = new ECSM2Signer(this.namedEllipse);
            signer.init(true, priKeyData);
            return signer.generateSignature(message);
        }
        return null;
    }

    @Override
    public boolean verify(String pubkeyBase64, BigInteger[] rs, byte[] message) {
        if (pubkeyBase64 == null || pubkeyBase64.equals("")) {
            throw new RuntimeException("param error: pubkey is not allowed to be empty");
        }
        if (rs != null && rs.length == 2) {
            byte[] keyData;
            block7: {
                keyData = new byte[65];
                try {
                    byte[] base64Key = Base64Util.decode(pubkeyBase64.getBytes());
                    if (base64Key.length >= 91) {
                        System.arraycopy(base64Key, base64Key.length - 65, keyData, 0, 65);
                        break block7;
                    }
                    if (base64Key.length >= 65) {
                        System.arraycopy(base64Key, base64Key.length - 65, keyData, 0, 65);
                        break block7;
                    }
                    if (base64Key.length == 64) {
                        keyData[0] = 4;
                        System.arraycopy(base64Key, 0, keyData, 1, 64);
                        break block7;
                    }
                    throw new RuntimeException("fatal error when verify signature. reason: pubkey is invalid");
                }
                catch (Exception e2) {
                    throw new RuntimeException("fatal error when verify signature. reason: pubkey is invalid");
                }
            }
            ECSM2Signer signer = new ECSM2Signer(this.namedEllipse);
            signer.init(false, keyData);
            return signer.verifySignature(message, rs[0], rs[1]);
        }
        return false;
    }

    @Override
    public byte[] encrypt_gb(String pubkeyBase64, byte[] plainText) {
        if (pubkeyBase64 == null || pubkeyBase64.equals("")) {
            throw new RuntimeException("param error: pubkey is not allowed to be empty");
        }
        if (plainText != null && plainText.length > 0) {
            byte[] keyData;
            byte[] result;
            byte[] cipherText;
            block8: {
                cipherText = null;
                result = null;
                keyData = new byte[65];
                byte[] base64Key = Base64Util.decode(pubkeyBase64.getBytes());
                try {
                    if (base64Key.length >= 91) {
                        System.arraycopy(base64Key, base64Key.length - 65, keyData, 0, 65);
                        break block8;
                    }
                    if (base64Key.length >= 65) {
                        System.arraycopy(base64Key, base64Key.length - 65, keyData, 0, 65);
                        break block8;
                    }
                    if (base64Key.length == 64) {
                        keyData[0] = 4;
                        System.arraycopy(base64Key, 0, keyData, 1, 64);
                        break block8;
                    }
                    throw new RuntimeException("fatal error when encrpty data. reason: pubkey is invalid");
                }
                catch (Exception e2) {
                    throw new RuntimeException("fatal error when encrpty data. reason: pubkey is invalid");
                }
            }
            SM2EncryptGB encrypt = new SM2EncryptGB(this.namedEllipse);
            cipherText = encrypt.pubkeyEncrypt(plainText, keyData);
            if (cipherText != null && cipherText.length > 0) {
                result = new byte[cipherText.length];
                System.arraycopy(cipherText, 0, result, 0, cipherText.length);
                return result;
            }
        }
        return null;
    }

    @Override
    public byte[] decrypt_gb(String privateBase64, byte[] cipherText) {
        if (privateBase64 == null || privateBase64.equals("")) {
            throw new RuntimeException("param error: private key is not allowed to be empty");
        }
        if (cipherText != null && cipherText.length > 0) {
            if (cipherText.length < 100) {
                throw new RuntimeException("faltal error when decpty data. reason: invalid format of cipherText");
            }
            byte[] result = null;
            byte[] prikey = Base64Util.decode(privateBase64);
            byte[] prikeyValue = new byte[32];
            if (prikey == null || prikey.length != 32) {
                throw new RuntimeException("faltal error when decpty data. reason: invalid private key, prikey key must be 32 byte");
            }
            System.arraycopy(prikey, 0, prikeyValue, 0, 32);
            SM2EncryptGB decrypt = new SM2EncryptGB(this.namedEllipse);
            result = decrypt.privateKeyDecrypt(cipherText, prikey);
            return result;
        }
        return null;
    }

    @Override
    public byte[] sign(ECPrivateKey privateKey, byte[] message) {
        if (privateKey == null) {
            throw new RuntimeException("param error: privateKey is not allowed to be empty");
        }
        byte[] result = new byte[64];
        byte[] rData = null;
        byte[] sData = null;
        if (message != null && message.length > 0) {
            byte[] priKeyData = ConvertUtil.hexStringToBytes(privateKey.getS().toString(16));
            ECSM2Signer signer = new ECSM2Signer(this.namedEllipse);
            signer.init(true, priKeyData);
            BigInteger[] rs = signer.generateSignature(message);
            rData = ConvertUtil.hexStringToBytes(rs[0].toString(16));
            System.arraycopy(rData, 0, result, 32 - rData.length, rData.length);
            sData = ConvertUtil.hexStringToBytes(rs[1].toString(16));
            System.arraycopy(sData, 0, result, 64 - sData.length, sData.length);
            return result;
        }
        return null;
    }

    @Override
    public boolean verify(ECPublicKey publicKey, byte[] signDate, byte[] message) {
        if (publicKey == null || signDate == null || message == null) {
            throw new RuntimeException("param error: publicKey, signDate, message is not allowed to be empty");
        }
        byte[] keyData = new byte[65];
        keyData[0] = 4;
        try {
            IntegerConverter converter = new IntegerConverter();
            System.arraycopy(converter.integerToBytes(publicKey.getW().getAffineX(), 32), 0, keyData, 1, 32);
            System.arraycopy(converter.integerToBytes(publicKey.getW().getAffineY(), 32), 0, keyData, 33, 32);
        }
        catch (Exception e2) {
            throw new RuntimeException("fatal error when verify signature. reason: pubkey is invalid");
        }
        if (signDate == null || signDate.length != 64) {
            throw new RuntimeException("fatal error when verify signature. reason: signDate is not 64");
        }
        byte[] rByte = new byte[32];
        byte[] sByte = new byte[32];
        System.arraycopy(signDate, 0, rByte, 0, 32);
        System.arraycopy(signDate, 32, sByte, 0, 32);
        BigInteger r = new BigInteger(ConvertUtil.bytesToHexString(rByte), 16);
        BigInteger s = new BigInteger(ConvertUtil.bytesToHexString(sByte), 16);
        ECSM2Signer signer = new ECSM2Signer(this.namedEllipse);
        signer.init(false, keyData);
        return signer.verifySignature(message, r, s);
    }
}

