/**
 * ErrorCode.java
 *
 * 
 * @author zhangxiaolong@xdja.com
 * 2015-7-30
 */
package com.xdja.multichip.errorcode;

/**
 *
 * 多芯片统一PIN码类错误code码；<br/><br/>
 *
 * 部分错误是拷贝的原有单芯片时的统一PIN码jar
 */
public class MultiChipUnitePinErrorCode
{
	/**
	 * 0：OK
	 * 
	 */
	public final static int OK							= 0;
	
	/**
	 * -9:接口参数错误(安全卡返回的错误)
	 */
	public static final int XKR_INVALID_PARA           = -9;   
	
	/**
	 * -10:口令错误,剩余重试次数为0(安全卡返回的错误)
	 */
	public static final int XKR_PASSWORD               = -10;  
	
	/**
	 * -16:密钥被锁死(安全卡返回的错误)
	 */ 
	public static final int XKR_KEY_LOCKED             = -16; 
	
	/**
	 * -20000：context为空
	 */
	public final static int ERROR_CONTEXT_NULL 			= -20000;
	
	/**
	 * -20001：未初始化
	 */
	public final static int ERROR_NOT_INIT				= -20001;
	
	/**
	 * -20002：初始化失败<br>
	 * 失败原因：<br>
	 * 1.没有安装功能apk；
	 * 2.其他错误
	 */
	public final static int ERROR_INIT_FAIL				= -20002;
	
	/**
	 * -20003：参数错误
	 */
	public final static int ERROR_PARAM					= -20003;
	
	/**
	 * -20004: 出参为空
	 */
	public final static int ERROR_PARAM_OUT_NULL		= -20004;
	
	/**
	 * -20005: 异常
	 */
	public final static int ERROR_EXCEPTION				= -20005;
	
	/**
	 * -20006: 获取PIN码失败<br>
	 * 原因：1.统一PIN码服务中，存储的PIN码可能为空；
	 * 		 2.未找到统一PIN码服务
	 */
	public final static int ERROR_PIN_NULL				= -20006;
	
	/**
	 * -20007: 参数长度有误
	 */
	public final static int ERROR_PARAM_LEN				= -20007;
	
	/**
	 * -3002: 参数中的usn 和 统一PIN码中的不一致
	 */
	public final static int ERROR_PARAM_USN_ERROR		= -3002;
	
	/**
	 * -3003: 生成动态解锁码 失败
	 */
	public final static int ERROR_PARAM_DYNAMIC_CODE_ERROR	= -3003;
	
	/**
	 * -3004: 生成动态解锁码中的密码失败
	 */
	public static final int ERROR_GEN_NOW_PASSWD_FAILED	= -3004;
	
	/**
	 * -3005: 生成静态解锁码失败 
	 */
	public static final int ERROR_GET_STATIC_CODE_FAILED = -3005;
	
	/**
	 * 反注册的action与已注册的action不一致
	 */
	public static final int ERROR_UNLOCK_ACTION_NOT_EQUAL_CURACTION = -3006;
	
	/**
	 * -3007: 验签失败
	 */
	public static final int ERROR_VERIFY_PACKAGE_FAILED	= -3007;
	
	/**
	 * 得到PIN码相关的错误提示
	 * @param errorCode		[in]错误码
	 * @return
	 */
	public final static String getErrorInfo( int errorCode )
	{
		String info = "";
		switch( errorCode )
		{
		case XKR_PASSWORD:
			info = "安全芯片PIN码错误,剩余重试次数为0";
			break;
		case XKR_KEY_LOCKED:
			info = "安全芯片已锁死";
			break;
		case ERROR_CONTEXT_NULL:
			info = "上下文为空";
			break;
		case ERROR_NOT_INIT:
			info = "统一PIN码未初始化";
			break;
		case ERROR_INIT_FAIL:
			info = "统一PIN码初始化失败";
			break;
		case ERROR_PARAM:
			info = "参数错误";
			break;
		case ERROR_PARAM_OUT_NULL:
			info = "出参为空";
			break;
		case ERROR_EXCEPTION:
			info = "执行方法时异常";
			break;
		case ERROR_PARAM_LEN:
			info = "参数长度有误";
			break;
		case ERROR_PARAM_USN_ERROR:
			info = "参数中的usn和 统一PIN码中的不一致";
			break;
		case ERROR_PARAM_DYNAMIC_CODE_ERROR:
			info = "生成动态解锁码 失败";
			break;
		case ERROR_GEN_NOW_PASSWD_FAILED:
			info = "生成动态解锁码中的密码失败";
			break;
		case ERROR_GET_STATIC_CODE_FAILED:
			info = "生成静态解锁码失败";
			break;
		case ERROR_UNLOCK_ACTION_NOT_EQUAL_CURACTION:
			info = "反注册的action与已注册的action不一致";
			break;
		case ERROR_VERIFY_PACKAGE_FAILED:
			info = "验签失败";
			break;
		default:
			info = "默认错误[" + String.format( "%08x", errorCode ) + "]";
			break;
		}
		return info;
	}
}
