package com.xdja.multichip.process;

import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.cc.Util;

import java.nio.ByteBuffer;

import static com.xdja.cc.XDJA_FILE.FILE_TYPE_BINARY;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/4/27 <br/>
 */
public class SupperHandleContainer {

    public static final String TAG = SupperHandleContainer.class.getSimpleName();

    public int createContainer(SupperJniApiBinder binder, int ctnId, String ctnName) throws RemoteException {
        if (TextUtils.isEmpty(ctnName)) {
            ctnName = "content " + ctnId;
        }
        int ret = 0;
        byte fid;
        byte[] ctnListFid = {0, 3};
        byte[] ctnNameFid = {0, 0};
        XDJA_FILE file = new XDJA_FILE();
        file.id = new byte[2];

        //创建容器名称文件
        fid = (byte) (0x28 + ctnId * 7);
        ctnNameFid[1] = fid;
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = 0x100;
        file.read_Acl = (byte) 0xf0;
        file.write_Acl = (byte) convertPermission(ctnId);
        file.type = FILE_TYPE_BINARY;
        ret = binder.CreateFile(binder.mHandle, file);
        if (JNIAPI.XKR_OK != ret && JNIAPI.XKR_FILE_EXIST != ret) {
            Log.e(TAG, "[erro] CreateContainer Create Container name File failed r=" + ret);
            return ret;
        }

        //构建容器名称文件内容
        XDJA_DEVINFO dev = new XDJA_DEVINFO();
        ret = binder.GetDevInfo(binder.mHandle, dev);
        if (JNIAPI.XKR_OK != ret) {
            Log.e(TAG, "[erro] CreateContainer GetDevInfo File failed r=" + ret);
            return ret;
        }

        //构建容器名称文件内容
        byte[] info = new byte[32];
        int[] len = new int[1];
        Util.Str2Byte(new String(dev.cardid, 0, 32), info, len);
        long t = System.currentTimeMillis();
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(0, t);
        System.arraycopy(buffer.array(), 2, info, 18, 4);
        info[14] = (byte) (info[14] ^ info[18]);
        info[15] = (byte) (info[14] ^ info[19]);
        info[16] = (byte) (info[14] ^ info[20]);
        info[17] = (byte) (info[14] ^ info[21]);
        String name = Util.Byte2Str(info, 0, 18);
        info[0] = (byte) (ctnName.length() * 2);
        byte[] namearray = ctnName.getBytes();
        int j = 0, i = 0;
        while (true) {
            if (0 == i % 2) {
                info[1 + i] = namearray[j++];
            } else {
                info[1 + i] = 0;
            }

            i++;
            if (ctnName.length() == j) {
                break;
            }
        }

        byte[] value = new byte[36 + 1 + ctnName.length() * 2];
        len[0] = name.length();
        System.arraycopy(name.getBytes(), 0, value, 0, len[0]);
        System.arraycopy(info, 0, value, len[0], ctnName.length() * 2 + 1);
        len[0] += ctnName.length() * 2 + 1;
        ret = binder.WriteFile(binder.mHandle, ctnNameFid, 0, len[0], value);
        if (JNIAPI.XKR_OK != ret) {
            Log.e(TAG, "[erro] CreateContainer Write Container name failed r=" + ret);
            return ret;
        }

        //创建交换证书
        fid += 1;
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = 0x600;
        file.read_Acl = (byte) 0xf0;
        file.write_Acl = (byte) convertPermission(ctnId);
        file.type = FILE_TYPE_BINARY;
        ret = binder.CreateFile(binder.mHandle, file);
        if (JNIAPI.XKR_OK != ret && JNIAPI.XKR_FILE_EXIST != ret) {
            Log.e(TAG, "[erro] CreateContainer Create exchange cert File failed r=" + ret);
            return ret;
        }

        //创建交换公钥
        fid += 1;
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = 0x200;
        file.use_Acl = (byte) 0xf0;
        file.read_Acl = (byte) 0xf0;
        file.write_Acl = (byte) convertPermission(ctnId);
        file.type = JNIAPI.FILE_PUBLIC;
        ret = binder.CreateFile(binder.mHandle, file);
        if (JNIAPI.XKR_OK != ret && JNIAPI.XKR_FILE_EXIST != ret) {
            Log.e(TAG, "[erro] CreateContainer Create exchange public File failed r=" + ret);
            return ret;
        }

        //创建交换私钥
        fid += 1;
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = 0x400;
        file.use_Acl = (byte) (byte) convertPermission(ctnId);
        file.read_Acl = (byte) 0x0f;
        file.write_Acl = (byte) convertPermission(ctnId);
        file.type = JNIAPI.FILE_PRIVATE;
        ret = binder.CreateFile(binder.mHandle, file);
        if (JNIAPI.XKR_OK != ret && JNIAPI.XKR_FILE_EXIST != ret) {
            Log.e(TAG, "[erro] CreateContainer Create exchange pirvate File failed r=" + ret);
            return ret;
        }

        //创建签名证书
        fid += 1;
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = 0x600;
        file.read_Acl = (byte) 0xf0;
        file.write_Acl = (byte) convertPermission(ctnId);
        file.type = FILE_TYPE_BINARY;
        ret = binder.CreateFile(binder.mHandle, file);
        if (JNIAPI.XKR_OK != ret && JNIAPI.XKR_FILE_EXIST != ret) {
            Log.e(TAG, "[erro] CreateContainer Create signature cert File failed r=" + ret);
            return ret;
        }

        //创建交换公钥
        fid += 1;
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = 0x200;
        file.use_Acl = (byte) 0xf0;
        file.read_Acl = (byte) 0xf0;
        file.write_Acl = (byte) convertPermission(ctnId);
        file.type = JNIAPI.FILE_PUBLIC;
        ret = binder.CreateFile(binder.mHandle, file);
        if (JNIAPI.XKR_OK != ret && JNIAPI.XKR_FILE_EXIST != ret) {
            Log.e(TAG, "[erro] CreateContainer Create signature public File failed r=" + ret);
            return ret;
        }

        //创建交换私钥
        fid += 1;
        file.id[0] = 0;
        file.id[1] = fid;
        file.room = 0x400;
        file.use_Acl = (byte) (byte) convertPermission(ctnId);
        file.read_Acl = (byte) 0x0f;
        file.write_Acl = (byte) convertPermission(ctnId);
        file.type = JNIAPI.FILE_PRIVATE;
        ret = binder.CreateFile(binder.mHandle, file);
        if (JNIAPI.XKR_OK != ret && JNIAPI.XKR_FILE_EXIST != ret) {
            Log.e(TAG, "[erro] CreateContainer Create signature pirvate File failed r=" + ret);
            return ret;
        }

        //更新容器信息
        info[0] = 0;
        info[1] = ctnNameFid[1];
        info[2] = 0;
        info[3] = 0x24;
        info[4] = 0x40;

        ret = binder.WriteFile(binder.mHandle, ctnListFid, ctnId * 5, 5, info);
        if (JNIAPI.XKR_OK != ret) {
            Log.e(TAG, "[erro] CreateContainer Update Container info failed r=" + ret);
            return ret;
        }

        return JNIAPI.XKR_OK;
    }

    /**
     * 更新容器
     *
     * @param ctnId 容器号(0~9)
     * @param alg   算法标识 0:RSA, 1:SM2
     * @param type  更新类型; 0:单签名, 1:单交换,  2:双证书
     * @return 成功返回XKR_OK, 其它返回码表示失败
     */
    public int updateContainer(SupperJniApiBinder binder, int ctnId, int alg, int type) throws RemoteException {
        int r;
        byte[] ctnListFid = {0, 3};
        byte[] info = new byte[5];

        r = binder.ReadFile(binder.mHandle, ctnListFid, ctnId * 5, 5, info);
        if (JNIAPI.XKR_OK != r) {
            Log.e(TAG, "[erro] updateContainer Read Container info failed r=" + r);
            return r;
        }

        if (0 == alg) {
            info[4] = changeBitTo0(info[4], 7);
        } else if (1 == alg) {
            info[4] = changeBitTo1(info[4], 7);
        } else {
            return JNIAPI.XKR_PARAMETER;
        }

        if (0 == type) {
            info[4] = changeBitTo1(info[4], 3);
            info[4] = changeBitTo1(info[4], 4);
            info[4] = changeBitTo1(info[4], 5);

            info[4] = changeBitTo0(info[4], 0);
            info[4] = changeBitTo0(info[4], 1);
            info[4] = changeBitTo0(info[4], 2);
        } else if (1 == type) {
            info[4] = changeBitTo1(info[4], 0);
            info[4] = changeBitTo1(info[4], 1);
            info[4] = changeBitTo1(info[4], 2);

            info[4] = changeBitTo0(info[4], 3);
            info[4] = changeBitTo0(info[4], 4);
            info[4] = changeBitTo0(info[4], 5);
        } else if (2 == type) {
            info[4] = changeBitTo1(info[4], 0);
            info[4] = changeBitTo1(info[4], 1);
            info[4] = changeBitTo1(info[4], 2);
            info[4] = changeBitTo1(info[4], 3);
            info[4] = changeBitTo1(info[4], 4);
            info[4] = changeBitTo1(info[4], 5);
        } else {
            return JNIAPI.XKR_PARAMETER;
        }

        r = binder.WriteFile(binder.mHandle, ctnListFid, ctnId * 5, 5, info);
        if (JNIAPI.XKR_OK != r) {
            Log.e(TAG, "[erro] updateContainer Write Container info failed r=" + r);
            return r;
        }

        return JNIAPI.XKR_OK;
    }

    /**
     * 容器对应的权限。
     * 备注：目前（2018-4-28之前说的），容器4和6，要对应权限0x44，其他容器在创建时，对应的权限是0x11
     *
     * @param containerId 容器号
     * @return
     */
    private int convertPermission(int containerId) {
        if (containerId == 4 || containerId == 6) {
            return 0x44;
        } else {
            return 0x11;
        }
    }

    /**
     * 将byte的某一bit变为0；
     * 一个byte是8个bit；从左向右为 依次为0 到 7；
     * 0xD7 十进制为：215； 二进制为：‭11010111;
     * <p>
     * 7 6 5 4  3 2 1 0
     * 1 1 0 1  0 1 1 1
     *
     * @param b
     * @param pos 哪一位。从0开始。
     * @return
     */
    private byte changeBitTo0(byte b, int pos) {
        byte ret;
        ret = (byte) (b & (255 - (byte) Math.pow(2, pos)));
        return ret;
    }

    /**
     * 将byte的某bit变成1；
     * 一个byte是8个bit；从左向右为 依次为0 到 7；
     * 0xD7 十进制为：215； 二进制为：‭11010111;
     * <p>
     * 7 6 5 4  3 2 1 0
     * 1 1 0 1  0 1 1 1
     *
     * @param b
     * @param pos 哪一位。从0开始。
     * @return
     */
    private byte changeBitTo1(byte b, int pos) {
        byte ret;
        ret = (byte) (b | (byte) Math.pow(2, pos));
        return ret;
    }
}
