package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.util.Pair;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_DIR;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_KEY_ATTR;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.cc.CoverCard;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;
import com.xdja.tmc.TMCAPI;

/**
 * Created by xwy on 2017/9/13.
 */

public class CCJniApi extends JNIAPI {


    /**
     * 不支持的方法
     */
    public final static int RET_NOT_SUPPORT_METHOD = JarMultiJniApiErrorCode.RET_NOT_SUPPORT_METHOD;

    private CoverCard coverCard = null;

    private TMCAPI mApi = null;

    public CCJniApi(final Context context) {
        //del 2018年4月2日19:47:43 weizg
        //为了使用贴膜卡进程的回调机制，现在该对象修改为在service里面初始化，不再需要自己构建looper
        /*try {
            Looper.prepare();
        } catch (Exception e) {
            e.printStackTrace();
        }*/

        //modify 2017年10月19日16:11:26 weizg&zhangxiaoliong
        //贴膜卡的初始化流程放到getApiParam执行
        mApi = new TMCAPI();
//        mApi.InitSmartCard(context);

       /* try{
            Looper.prepare();
            mApi.InitSmartCard(context);
        }catch (Exception e){
            //Looper.prepare();
            e.printStackTrace();
            mApi.InitSmartCard(context);
        }*/
    }

    TMCAPI getTMCAPI() {
        return mApi;
    }

    @Override
    public int GetVersion(byte[] verion, int[] ver_len) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int EnumDev(int devType, int[] devNum) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int OpenDev(int index, long[] hHandle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CloseDev(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int LockDev(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int UnlockDev(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int Transmit(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetDevInfo(long handle, XDJA_DEVINFO devInfo) {
        XDJA_DEVINFO cacheDevInfo = CCCacheManager.getInstance().getDevInfo();
        if (cacheDevInfo != null) {
            System.arraycopy(cacheDevInfo.cardid, 0, devInfo.cardid, 0, cacheDevInfo.cardid.length);
            devInfo.cardtype = cacheDevInfo.cardtype;
            devInfo.reserve = cacheDevInfo.reserve;
            System.arraycopy(cacheDevInfo.cosver, 0, devInfo.cosver, 0, cacheDevInfo.cosver.length);
            return 0;
        }
        int ret = mApi.GetDevInfo(devInfo);
        if (ret == 0) {
            CCCacheManager.getInstance().setDevInfo(devInfo);
        }
        return ret;
    }

    public int GetDevInfoPri(long handle, XDJA_DEVINFO devInfo) {
        int ret = mApi.GetDevInfo(devInfo);
        if (ret == 0) {
            CCCacheManager.getInstance().setDevInfo(devInfo);
        }
        return ret;
    }


    @Override
    public int SetLogPath(byte[] logPath) {
        return RET_NOT_SUPPORT_METHOD;
    }

    /**
     * 激活接口直接返回成功
     *
     * @param handle
     * @param param
     * @param paramLen
     * @return
     */
    @Override
    public int ActivateCard(long handle, byte[] param, int paramLen) {
        return 0;
    }

    @Override
    public int GetActivateState(long handle) {
        return 0;
    }

    @Override
    public int ChangePIN(long handle, int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) {
        if (newLen < 6 || newLen > 16) {
            return JNIAPI.XKR_INVALID_PARA;
        }
        return mApi.ChangePIN(pinRole, oldPin, oldLen, newPin, newLen);
    }

    @Override
    public int GetPinTryCount(long handle, int pinRole) {
        return mApi.GetPINTryCount(pinRole);
    }

    @Override
    public int VerifyPIN(long handle, int pinRole, byte[] pin, int pinLen) {
        return mApi.VerifyPIN(pinRole, pin, pinLen);
    }

    @Override
    public int UnlockPIN(long handle, int id, byte[] key, int keyLen, byte[] newPin, int newLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReloadPIN(long handle, int pinRole, byte[] key, int keyLen, byte[] newPin, int newLen) {
        return mApi.ReloadPIN(pinRole, key, keyLen, newPin, newLen);
    }

    @Override
    public int CardReset(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ExternAuth(long handle, byte exterAuthID, byte[] encRandom) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int InterAuth(long handle, byte[] dataIn, int inLen, int flag, byte kID, byte[] tmpKey, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CreateDir(long handle, XDJA_DIR dir) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SelectFile(long handle, byte[] fid) {
        return mApi.SelectFile(fid);
    }

    @Override
    public int DeleteFile(long handle, byte[] fid) {
        return mApi.DeleteFile(fid);
    }

    @Override
    public int GetDirSize(long handle, int[] size) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CreateFile(long handle, XDJA_FILE file) {
        return mApi.CreateFile(file);
    }

    @Override
    public int GetFileInfo(long handle, byte[] fid, XDJA_FILE file) {
        return mApi.GetFileInfo(fid, file);
    }

    @Override
    public int ReadFile(long handle, byte[] fid, int readPos, int readLen, byte[] dataOut) {
        return mApi.ReadFile(fid, readPos, readLen, dataOut);
    }

    @Override
    public int WriteFile(long handle, byte[] fid, int writePos, int writeLen, byte[] dataIn) {
        return mApi.WriteFile(fid, writePos, writeLen, dataIn);
    }

    @Override
    public int ReadRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        return mApi.ReadRsaPubKey(pubfid, pubKey);
    }

    @Override
    public int WriteRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) {
        return mApi.WriteRsaPubKey(pubfid, pubKey);
    }

    @Override
    public int WriteRsaPriKey(long handle, byte[] prifid, XDJA_RSA_PRIKEY priKey) {
        return mApi.WriteRsaPriKey(prifid, priKey);
    }

    @Override
    public int ReadSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        return mApi.ReadSm2PubKey(pubfid, pubKey);
    }

    @Override
    public int WriteSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) {
        return mApi.WriteSm2PubKey(pubfid, pubKey);
    }

    @Override
    public int WriteSm2PriKey(long handle, byte[] prifid, XDJA_SM2_PRIKEY priKey) {
        return mApi.WriteSm2PriKey(prifid, priKey);
    }

    @Override
    public int ReadCert(long handle, byte[] fid, byte[] certBuf, int[] certLen) {
        Pair<byte[], Integer> certPair = CCCacheManager.getInstance().getCert(fid);
        if (certPair != null) {
            System.arraycopy(certPair.first, 0, certBuf, 0, certPair.second);
            certLen[0] = certPair.second;
            return 0;
        }
        int ret = mApi.ReadCert(fid, certBuf, certLen);
        if (ret == 0) {
            byte[] tmp = new byte[certLen[0]];
            System.arraycopy(certBuf, 0, tmp, 0, certLen[0]);
            CCCacheManager.getInstance().setCert(fid, tmp, certLen[0]);
        }
        return ret;
    }

    @Override
    public int WriteCert(long handle, byte[] fid, byte[] certBuf, int certLen) {
        int ret = mApi.WriteCert(fid, certBuf, certLen);
        //如果写成功了，则也更新缓存
        if (ret == 0) {
            byte[] tmp = new byte[certLen];
            System.arraycopy(certBuf, 0, tmp, 0, certLen);
            CCCacheManager.getInstance().setCert(fid, tmp, certLen);
        }
        return ret;
    }

    @Override
    public int GenRandom(long handle, int len, byte[] random) {
        return mApi.GenRandom(len, random);
    }

    @Override
    public int DESKEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int DES3KEY(long handle, byte[] tmpKey, int tmpkeyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int AESKEY(long handle, byte[] tmpKey, int keyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CreateKey(long handle, XDJA_KEY_ATTR keyAttr) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ImportKey(long handle, int type, byte[] dataIn, byte kID) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) {
        return mApi.SM1(dataIn, inLen, flag, dataOut, kID, IV);
    }

    @Override
    public int ImportTmpKey(long handle, byte[] tmpKey) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int TmpSM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ImportCipherKey(long handle, byte[] tmpKey, int alg) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int TmpCipher(long handle, byte[] dataIn, int inLen, int alg, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM1KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return mApi.SM1KEY(tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    @Override
    public int SSF33(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM4KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return mApi.SM4KEY(tmpKey, dataIn, inLen, flag, dataOut, IV);
    }

    @Override
    public int SM4KEYEx(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM6KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GenRSAKeyPair(long handle, int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pubkey, XDJA_RSA_PRIKEY prikey) {
        if (pubfid[0] == 0x00 && pubfid[1] == 0x00) {
            return RET_NOT_SUPPORT_METHOD;
        }
        if (prifid[0] == 0x00 && prifid[1] == 0x00) {
            return RET_NOT_SUPPORT_METHOD;
        }
        return mApi.GenRSAKeyPair(bits, pubfid, prifid);
    }

    @Override
    public int RSAPubKeyCalc(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (pubfid[0] == 0x00 && pubfid[1] == 0x00) {
                return mApi.RSAPubKeyCalc(pubkey, dataIn, inLen, dataOut, outLen);
            }
            return mApi.RSAPubKeyCalc(pubfid, inLen * 8, dataIn, inLen, dataOut, outLen);

        } catch (Exception e) {
            e.printStackTrace();
            return RET_NOT_SUPPORT_METHOD;
        }
    }

    @Override
    public int RSAPriKeyCalc(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return mApi.RSAPriKeyCalc(prifid, inLen * 8, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int RSAPriKeyCalcEx(long handle, byte[] pin, int pinLen, int pinRole, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int RSASign(long handle, int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return mApi.RSASign(prifid, bits, dataType, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int RSASignVerify(long handle, int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) {
        if (pubfid[0] == 0x00 && pubfid[1] == 0x00) {
            return RET_NOT_SUPPORT_METHOD;
        }
        return mApi.RSASignVerify(pubfid, bits, dataType, dataIn, inLen, signatureData, signatureData.length);
    }

    @Override
    public int PackEnvelope(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int alg, byte[] dataOut, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int UnpackEnvelope(long handle, byte[] prifid, int alg, byte[] dataIn, int inLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int KeyDisperse(long handle, int keyId, byte[] keyParam, int keyParamLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SetSM2Id(long handle, byte[] sm2Id, int inLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetSM2Id(long handle, byte[] sm2Id, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetSM2Param(long handle, XDJA_SM2_PARAM param) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GenSM2KeyPair(long handle, byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) {
        if (pubfid[0] == 0x00 && pubfid[1] == 0x00) {
            return RET_NOT_SUPPORT_METHOD;
        }
        if (prifid[0] == 0x00 && prifid[1] == 0x00) {
            return RET_NOT_SUPPORT_METHOD;
        }
        return mApi.GenSM2KeyPair(pubfid, prifid);
    }

    @Override
    public int SM2Encrypt(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (pubfid[0] == 0x00 && pubfid[1] == 0x00) {
                return mApi.SM2Encrypt(pubkey, dataIn, inLen, dataOut, outLen);
            }
            return mApi.SM2Encrypt(pubfid, dataIn, inLen, dataOut, outLen);
        } catch (Exception e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
    }

    @Override
    public int SM2EncryptGM(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        try {
            if (pubfid[0] == 0x00 && pubfid[1] == 0x00) {
                return mApi.SM2Encrypt(pubkey, dataIn, inLen, dataOut, outLen);
            }
            return mApi.SM2EncryptGM(pubfid, dataIn, inLen, dataOut, outLen);
        } catch (Exception e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }

    }

    @Override
    public int SM2Decrypt(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return mApi.SM2Decrypt(prifid, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2DecryptGM(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return mApi.SM2DecryptGM(prifid, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2Sign(long handle, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) {
        return mApi.SM2Sign(pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
    }

    @Override
    public int SM2SignVerify(long handle, byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        try {
            if (pubfid[0] == 0x00 && pubfid[1] == 0x00) {
                if (pubkey == null) {
                    return JNIAPI.XKR_DATA_PARAMETER;
                }
                return mApi.SM2SignVerify(pubkey, dataType, dataIn, inLen, signatureData, signatureData.length);
            }
            return mApi.SM2SignVerify(pubfid, dataType, dataIn, inLen, signatureData, signatureData.length);

        } catch (Exception e) {
            e.printStackTrace();
            return JNIAPI.XKR_UNKNOWN;
        }
    }

    @Override
    public int SM2SignEx(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] signatureData, int[] signatureDataLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM2SignVerifyEx(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SHA1(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SHA1Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM3(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM3Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM2KeyGenInit(long handle, byte[] pubfid, byte[] dataOut, int[] outLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM2KeyGenCompute(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, byte dictFlag, byte keyFlag) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SM2KeyGenVerify(long handle, byte[] dataIn, int inLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetUsbMountPath(long handle, int type, byte[] path) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int SetUsbRWMode(long handle, int mode) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReadUsbNormalSecs(long handle, int addr, short secs, byte[] data) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int WriteUsbNormalSecs(long handle, int addr, short secs, byte[] data) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int OpenUsbSecuZone(long handle, byte[] pass, int passLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int CloseUsbSecuZone(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ChgUsbSecuZonePin(long handle, byte[] oldPass, int oldLen, byte[] newPass, int newLen, int type) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int UnlockUsbSecuZone(long handle, byte[] key, int keyLen, byte[] pin, int pinLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int InitUsbHiddZone(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetUsbHiddZoneSize(long handle, int[] size) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReadUsbHiddZone(long handle, int addr, byte[] dataOut, int readLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int WriteUsbHiddZone(long handle, int addr, byte[] dataIn, int writeLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ExecUsbScsiCmd(long handle, byte[] CDBbuff, int cdbLength, byte[] sendDataBuf, int sendDataLen, byte[] recvDataBuf, int[] recvDataLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int If2gKey(long handle) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int gKeySign(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, int dataType) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetRemainPower(long handle, int[] power) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetTFMountPath(long handle, byte[] mountPath, int[] pathLen) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int GetTFZoneSize(long handle, int[] size) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int ReadTFZone(long handle, int sectorStart, byte[] dataBuf, int buffSize) {
        return RET_NOT_SUPPORT_METHOD;
    }

    @Override
    public int WriteTFZone(long handle, int sectorStart, byte[] dataBuf, int buffSize) {
        return RET_NOT_SUPPORT_METHOD;
    }

    public int SM4(byte[] dataIn, int dataLen, int flag, byte[] dataOut, int[] outLen, byte kID, byte[] IV) {
        return mApi.SM4(dataIn, dataLen, flag, dataOut, outLen, kID, IV);
    }

    private CoverCard getCoverCard() {
        if (coverCard == null) {
            synchronized (CCJniApi.class) {
                if (coverCard == null) {
                    coverCard = new CoverCard();
                }
            }
        }
        return coverCard;
    }
}
