/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import com.xdja.multichip.IAccessControl;
import com.xdja.multichip.utils.GetCallUri;

public class AccessControlManager {
    private Context context;
    private static AccessControlManager acessControlManager;
    private IAccessControl iAccessControl;

    private AccessControlManager(Context context) {
        this.context = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AccessControlManager getInstance(Context context) {
        if (acessControlManager != null) return acessControlManager;
        Class<AccessControlManager> clazz = AccessControlManager.class;
        synchronized (AccessControlManager.class) {
            if (acessControlManager != null) return acessControlManager;
            acessControlManager = new AccessControlManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return acessControlManager;
        }
    }

    private IAccessControl getAccessControlBinder() {
        if (this.iAccessControl == null) {
            IBinder binder;
            int ret;
            Uri uri = GetCallUri.getUri(this.context);
            if (uri == null) {
                return null;
            }
            ContentResolver resolver = this.context.getContentResolver();
            Bundle bundle = resolver.call(uri, "GetBinder", "AccessControlBinder", null);
            if (bundle != null && (ret = bundle.getInt("ret")) == 0 && (binder = bundle.getBinder("Binder")) != null) {
                this.iAccessControl = IAccessControl.Stub.asInterface((IBinder)binder);
                try {
                    binder.linkToDeath(new IBinder.DeathRecipient(){

                        public void binderDied() {
                            AccessControlManager.this.iAccessControl = null;
                        }
                    }, 0);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.iAccessControl;
    }

    public int checkByPkgName(String pkgName, String method) {
        int ret = -1;
        IAccessControl accessControl = this.getAccessControlBinder();
        if (accessControl == null) {
            return -1;
        }
        try {
            ret = accessControl.checkByPkgName(pkgName, method);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public int checkByUidPid(int uid, int pid, String method) {
        int ret = -1;
        IAccessControl accessControl = this.getAccessControlBinder();
        if (accessControl == null) {
            return -1;
        }
        try {
            ret = accessControl.checkByUidPid(uid, pid, method);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

