/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_DIR;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_KEY_ATTR;
import com.xdja.SafeKey.XDJA_RSA_PRIKEY;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.activatechip.ActivateChip;
import com.xdja.multichip.AccessControlManager;
import com.xdja.multichip.IMultiJniApi;
import com.xdja.multichip.InsideMultiChipUnitePinManager;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SupperHandleMethod;

public abstract class SupperJniApiBinder
extends IMultiJniApi.Stub {
    protected Context mContext;
    protected XDJA_DEVINFO devInfo = null;
    protected long mHandle = -1L;

    public SupperJniApiBinder(Context context) {
        this.mContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
    }

    protected abstract JNIAPI getApi();

    protected abstract int selfOpenDev() throws RemoteException;

    protected abstract int getChipType();

    public int GetVersion(byte[] verion, int[] ver_len) throws RemoteException {
        return this.getApi().GetVersion(verion, ver_len);
    }

    public int EnumDev(int devType, int[] devNum) throws RemoteException {
        return this.getApi().EnumDev(devType, devNum);
    }

    public int OpenDev(int index, long[] hHandle) throws RemoteException {
        return this.getApi().OpenDev(index, hHandle);
    }

    public int OpenDevByName(byte[] devName, long[] hHandle) throws RemoteException {
        return this.getApi().OpenDevByName(devName, hHandle);
    }

    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) throws RemoteException {
        return this.getApi().OpenDevByNameEx(packagePath, hHandle);
    }

    public int CloseDev(long handle) throws RemoteException {
        return this.getApi().CloseDev(this.mHandle);
    }

    public int LockDev(long handle) throws RemoteException {
        return this.getApi().LockDev(this.mHandle);
    }

    public int UnlockDev(long handle) throws RemoteException {
        return this.getApi().UnlockDev(this.mHandle);
    }

    public int Transmit(long handle, byte[] cmd, int cmdLen, byte[] dataOut, int[] outLen) throws RemoteException {
        return this.getApi().Transmit(this.mHandle, cmd, cmdLen, dataOut, outLen);
    }

    public int GetDevInfo(long handle, XDJA_DEVINFO devInfo) throws RemoteException {
        int ret = this.getApi().GetDevInfo(this.mHandle, devInfo);
        if (ret == 0) {
            this.devInfo = new XDJA_DEVINFO();
            System.arraycopy(devInfo.cardid, 0, this.devInfo.cardid, 0, 32);
            System.arraycopy(devInfo.cosver, 0, this.devInfo.cosver, 0, 64);
            this.devInfo.cardtype = devInfo.cardtype;
            this.devInfo.reserve = devInfo.reserve;
        }
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GetDevInfo(this.mHandle, devInfo);
        }
        return ret;
    }

    public int ActivateCard(long handle, byte[] param, int paramLen) throws RemoteException {
        int ret = this.getApi().ActivateCard(this.mHandle, param, paramLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ActivateCard(this.mHandle, param, paramLen);
        }
        return ret;
    }

    public int GetActivateState(long handle) throws RemoteException {
        int ret = this.getApi().GetActivateState(this.mHandle);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GetActivateState(this.mHandle);
        }
        return ret;
    }

    public int ChangePIN(long handle, int pinRole, byte[] oldPin, int oldLen, byte[] newPin, int newLen) throws RemoteException {
        int uid = SupperJniApiBinder.getCallingUid();
        int pid = SupperJniApiBinder.getCallingPid();
        int ret = AccessControlManager.getInstance(this.mContext).checkByUidPid(uid, pid, "ChangePIN");
        if (ret != 0) {
            return ret;
        }
        ret = this.getApi().ChangePIN(this.mHandle, pinRole, oldPin, oldLen, newPin, newLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ChangePIN(this.mHandle, pinRole, oldPin, oldLen, newPin, newLen);
        }
        this.callUnitePin(ret, pinRole, newPin, "ChangePIN");
        return ret;
    }

    public int GetPinTryCount(long handle, int pinRole) throws RemoteException {
        int ret = this.getApi().GetPinTryCount(this.mHandle, pinRole);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GetPinTryCount(this.mHandle, pinRole);
        }
        return ret;
    }

    public int VerifyPIN(long handle, int pinRole, byte[] pin, int pinLen) throws RemoteException {
        int uid = SupperJniApiBinder.getCallingUid();
        int pid = SupperJniApiBinder.getCallingPid();
        int ret = AccessControlManager.getInstance(this.mContext).checkByUidPid(uid, pid, "VerifyPIN");
        if (ret != 0) {
            return ret;
        }
        ret = this.getApi().VerifyPIN(this.mHandle, pinRole, pin, pinLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().VerifyPIN(this.mHandle, pinRole, pin, pinLen);
        }
        this.callUnitePin(ret, pinRole, pin, "VerifyPIN");
        return ret;
    }

    public int UnlockPIN(long handle, int id, byte[] key, int keyLen, byte[] newPin, int newLen) throws RemoteException {
        int uid = SupperJniApiBinder.getCallingUid();
        int pid = SupperJniApiBinder.getCallingPid();
        int ret = AccessControlManager.getInstance(this.mContext).checkByUidPid(uid, pid, "UnlockPIN");
        if (ret != 0) {
            return ret;
        }
        ret = this.getApi().UnlockPIN(this.mHandle, id, key, keyLen, newPin, newLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().UnlockPIN(this.mHandle, id, key, keyLen, newPin, newLen);
        }
        return ret;
    }

    public int ReloadPIN(long handle, int pinRole, byte[] key, int keyLen, byte[] newPin, int newLen) throws RemoteException {
        int uid = SupperJniApiBinder.getCallingUid();
        int pid = SupperJniApiBinder.getCallingPid();
        int ret = AccessControlManager.getInstance(this.mContext).checkByUidPid(uid, pid, "ReloadPIN");
        if (ret != 0) {
            return ret;
        }
        ret = this.getApi().ReloadPIN(this.mHandle, pinRole, key, keyLen, newPin, newLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ReloadPIN(this.mHandle, pinRole, key, keyLen, newPin, newLen);
        }
        this.callUnitePin(ret, pinRole, newPin, "UnlockPIN");
        return ret;
    }

    public int CardReset(long handle) throws RemoteException {
        int ret = this.getApi().CardReset(this.mHandle);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().CardReset(this.mHandle);
        }
        return ret;
    }

    public int ExternAuth(long handle, byte exterAuthID, byte[] encRandom) throws RemoteException {
        int ret = this.getApi().ExternAuth(this.mHandle, exterAuthID, encRandom);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ExternAuth(this.mHandle, exterAuthID, encRandom);
        }
        return ret;
    }

    public int InterAuth(long handle, byte[] dataIn, int inLen, int flag, byte kID, byte[] tmpKey, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().InterAuth(this.mHandle, dataIn, inLen, flag, kID, tmpKey, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().InterAuth(this.mHandle, dataIn, inLen, flag, kID, tmpKey, dataOut, IV);
        }
        return ret;
    }

    public int CreateDir(long handle, XDJA_DIR dir) throws RemoteException {
        int ret = this.getApi().CreateDir(this.mHandle, dir);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().CreateDir(this.mHandle, dir);
        }
        return 0;
    }

    public int SelectFile(long handle, byte[] fid) throws RemoteException {
        int ret = this.getApi().SelectFile(this.mHandle, fid);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SelectFile(this.mHandle, fid);
        }
        return ret;
    }

    public int GetDirSize(long handle, int[] size) throws RemoteException {
        int ret = this.getApi().GetDirSize(this.mHandle, size);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GetDirSize(this.mHandle, size);
        }
        return ret;
    }

    public int DeleteFile(long handle, byte[] fid) throws RemoteException {
        int ret = this.getApi().DeleteFile(this.mHandle, fid);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().DeleteFile(this.mHandle, fid);
        }
        return ret;
    }

    public int CreateFile(long handle, XDJA_FILE file) throws RemoteException {
        int ret = this.getApi().CreateFile(this.mHandle, file);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().CreateFile(this.mHandle, file);
        }
        return ret;
    }

    public int GetFileInfo(long handle, byte[] fid, XDJA_FILE file) throws RemoteException {
        int ret = this.getApi().GetFileInfo(this.mHandle, fid, file);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GetFileInfo(this.mHandle, fid, file);
        }
        return ret;
    }

    public int ReadFile(long handle, byte[] fid, int readPos, int readLen, byte[] dataOut) throws RemoteException {
        int ret = this.getApi().ReadFile(this.mHandle, fid, readPos, readLen, dataOut);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ReadFile(this.mHandle, fid, readPos, readLen, dataOut);
        }
        return ret;
    }

    public int WriteFile(long handle, byte[] fid, int writePos, int writeLen, byte[] dataIn) throws RemoteException {
        int ret = this.getApi().WriteFile(this.mHandle, fid, writePos, writeLen, dataIn);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().WriteFile(this.mHandle, fid, writePos, writeLen, dataIn);
        }
        return ret;
    }

    public int ReadRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) throws RemoteException {
        int ret = this.getApi().ReadRsaPubKey(this.mHandle, pubfid, pubKey);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ReadRsaPubKey(this.mHandle, pubfid, pubKey);
        }
        return ret;
    }

    public int WriteRsaPubKey(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubKey) throws RemoteException {
        int ret = this.getApi().WriteRsaPubKey(this.mHandle, pubfid, pubKey);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().WriteRsaPubKey(this.mHandle, pubfid, pubKey);
        }
        return ret;
    }

    public int WriteRsaPriKey(long handle, byte[] prifid, XDJA_RSA_PRIKEY priKey) throws RemoteException {
        int ret = this.getApi().WriteRsaPriKey(this.mHandle, prifid, priKey);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().WriteRsaPriKey(this.mHandle, prifid, priKey);
        }
        return ret;
    }

    public int ReadSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) throws RemoteException {
        int ret = this.getApi().ReadSm2PubKey(this.mHandle, pubfid, pubKey);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ReadSm2PubKey(this.mHandle, pubfid, pubKey);
        }
        return ret;
    }

    public int WriteSm2PubKey(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubKey) throws RemoteException {
        int ret = this.getApi().WriteSm2PubKey(this.mHandle, pubfid, pubKey);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().WriteSm2PubKey(this.mHandle, pubfid, pubKey);
        }
        return ret;
    }

    public int WriteSm2PriKey(long handle, byte[] prifid, XDJA_SM2_PRIKEY priKey) throws RemoteException {
        int ret = this.getApi().WriteSm2PriKey(this.mHandle, prifid, priKey);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().WriteSm2PriKey(this.mHandle, prifid, priKey);
        }
        return ret;
    }

    public int ReadCert(long handle, byte[] fid, byte[] certBuf, int[] certLen) throws RemoteException {
        int ret = this.getApi().ReadCert(this.mHandle, fid, certBuf, certLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ReadCert(this.mHandle, fid, certBuf, certLen);
        }
        return ret;
    }

    public int WriteCert(long handle, byte[] fid, byte[] certBuf, int certLen) throws RemoteException {
        int ret = this.getApi().WriteCert(this.mHandle, fid, certBuf, certLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().WriteCert(this.mHandle, fid, certBuf, certLen);
        }
        return ret;
    }

    public int GenRandom(long handle, int len, byte[] random) throws RemoteException {
        int ret = this.getApi().GenRandom(this.mHandle, len, random);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GenRandom(this.mHandle, len, random);
        }
        return ret;
    }

    public int DESKEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().DESKEY(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().DESKEY(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    public int DES3KEY(long handle, byte[] tmpKey, int tmpkeyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().DES3KEY(this.mHandle, tmpKey, tmpkeyLen, dataIn, inLen, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().DES3KEY(this.mHandle, tmpKey, tmpkeyLen, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    public int AESKEY(long handle, byte[] tmpKey, int keyLen, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().AESKEY(this.mHandle, tmpKey, keyLen, dataIn, inLen, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().AESKEY(this.mHandle, tmpKey, keyLen, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    public int CreateKey(long handle, XDJA_KEY_ATTR keyAttr) throws RemoteException {
        int ret = this.getApi().CreateKey(this.mHandle, keyAttr);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().CreateKey(this.mHandle, keyAttr);
        }
        return ret;
    }

    public int ImportKey(long handle, int type, byte[] dataIn, byte kID) throws RemoteException {
        int ret = this.getApi().ImportKey(this.mHandle, type, dataIn, kID);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ImportKey(this.mHandle, type, dataIn, kID);
        }
        return ret;
    }

    public int SM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte kID, byte[] IV) throws RemoteException {
        int ret = this.getApi().SM1(this.mHandle, dataIn, inLen, flag, dataOut, kID, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM1(this.mHandle, dataIn, inLen, flag, dataOut, kID, IV);
        }
        return ret;
    }

    public int ImportTmpKey(long handle, byte[] tmpKey) throws RemoteException {
        int ret = this.getApi().ImportTmpKey(this.mHandle, tmpKey);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ImportTmpKey(this.mHandle, tmpKey);
        }
        return ret;
    }

    public int TmpSM1(long handle, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().TmpSM1(this.mHandle, dataIn, inLen, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().TmpSM1(this.mHandle, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    public int ImportCipherKey(long handle, byte[] tmpKey, int alg) throws RemoteException {
        int ret = this.getApi().ImportCipherKey(this.mHandle, tmpKey, alg);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().ImportCipherKey(this.mHandle, tmpKey, alg);
        }
        return ret;
    }

    public int TmpCipher(long handle, byte[] dataIn, int inLen, int alg, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().TmpCipher(this.mHandle, dataIn, inLen, alg, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().TmpCipher(this.mHandle, dataIn, inLen, alg, flag, dataOut, IV);
        }
        return ret;
    }

    public int SM1KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().SM1KEY(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM1KEY(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    public int SSF33(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().SSF33(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SSF33(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    public int SM4KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().SM4KEY(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM4KEY(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    public int SM4KEYEx(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().SM4KEYEx(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM4KEYEx(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    public int SM6KEY(long handle, byte[] tmpKey, byte[] dataIn, int inLen, int flag, byte[] dataOut, byte[] IV) throws RemoteException {
        int ret = this.getApi().SM6KEY(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM6KEY(this.mHandle, tmpKey, dataIn, inLen, flag, dataOut, IV);
        }
        return ret;
    }

    public int GenRSAKeyPair(long handle, int bits, byte[] pubfid, byte[] prifid, XDJA_RSA_PUBKEY pubkey, XDJA_RSA_PRIKEY prikey) throws RemoteException {
        int ret = this.getApi().GenRSAKeyPair(this.mHandle, bits, pubfid, prifid, pubkey, prikey);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GenRSAKeyPair(this.mHandle, bits, pubfid, prifid, pubkey, prikey);
        }
        return ret;
    }

    public int RSAPubKeyCalc(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().RSAPubKeyCalc(this.mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().RSAPubKeyCalc(this.mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int RSAPriKeyCalc(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().RSAPriKeyCalc(this.mHandle, prifid, dataIn, inLen, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().RSAPriKeyCalc(this.mHandle, prifid, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int RSAPriKeyCalcEx(long handle, byte[] pin, int pinLen, int pinRole, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().RSAPriKeyCalcEx(this.mHandle, pin, pinLen, pinRole, prifid, dataIn, inLen, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().RSAPriKeyCalcEx(this.mHandle, pin, pinLen, pinRole, prifid, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int RSASign(long handle, int bits, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().RSASign(this.mHandle, bits, prifid, dataType, dataIn, inLen, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().RSASign(this.mHandle, bits, prifid, dataType, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int RSASignVerify(long handle, int bits, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int dataType, byte[] dataIn, int inLen, byte[] signatureData) throws RemoteException {
        int ret = this.getApi().RSASignVerify(this.mHandle, bits, pubfid, pubkey, dataType, dataIn, inLen, signatureData);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().RSASignVerify(this.mHandle, bits, pubfid, pubkey, dataType, dataIn, inLen, signatureData);
        }
        return ret;
    }

    public int PackEnvelope(long handle, byte[] pubfid, XDJA_RSA_PUBKEY pubkey, int alg, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().PackEnvelope(this.mHandle, pubfid, pubkey, alg, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().PackEnvelope(this.mHandle, pubfid, pubkey, alg, dataOut, outLen);
        }
        return ret;
    }

    public int UnpackEnvelope(long handle, byte[] prifid, int alg, byte[] dataIn, int inLen) throws RemoteException {
        int ret = this.getApi().UnpackEnvelope(this.mHandle, prifid, alg, dataIn, inLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().UnpackEnvelope(this.mHandle, prifid, alg, dataIn, inLen);
        }
        return ret;
    }

    public int KeyDisperse(long handle, int keyId, byte[] keyParam, int keyParamLen) throws RemoteException {
        int ret = this.getApi().KeyDisperse(this.mHandle, keyId, keyParam, keyParamLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().KeyDisperse(this.mHandle, keyId, keyParam, keyParamLen);
        }
        return ret;
    }

    public int SetSM2Id(long handle, byte[] sm2Id, int inLen) throws RemoteException {
        int ret = this.getApi().SetSM2Id(this.mHandle, sm2Id, inLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SetSM2Id(this.mHandle, sm2Id, inLen);
        }
        return ret;
    }

    public int GetSM2Id(long handle, byte[] sm2Id, int[] outLen) throws RemoteException {
        int ret = this.getApi().GetSM2Id(this.mHandle, sm2Id, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GetSM2Id(this.mHandle, sm2Id, outLen);
        }
        return ret;
    }

    public int SetSM2Param(long handle, XDJA_SM2_PARAM param) throws RemoteException {
        int ret = this.getApi().SetSM2Param(this.mHandle, param);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SetSM2Param(this.mHandle, param);
        }
        return ret;
    }

    public int GetSM2Param(long handle, XDJA_SM2_PARAM param) throws RemoteException {
        int ret = this.getApi().GetSM2Param(this.mHandle, param);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GetSM2Param(this.mHandle, param);
        }
        return ret;
    }

    public int GenSM2KeyPair(long handle, byte[] pubfid, byte[] prifid, XDJA_SM2_PUBKEY pubkey, XDJA_SM2_PRIKEY prikey) throws RemoteException {
        int ret = this.getApi().GenSM2KeyPair(this.mHandle, pubfid, prifid, pubkey, prikey);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().GenSM2KeyPair(this.mHandle, pubfid, prifid, pubkey, prikey);
        }
        return ret;
    }

    public int SM2Encrypt(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().SM2Encrypt(this.mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2Encrypt(this.mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int SM2EncryptGM(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().SM2EncryptGM(this.mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2EncryptGM(this.mHandle, pubfid, pubkey, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int SM2Decrypt(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().SM2Decrypt(this.mHandle, prifid, dataIn, inLen, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2Decrypt(this.mHandle, prifid, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int SM2DecryptGM(long handle, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().SM2DecryptGM(this.mHandle, prifid, dataIn, inLen, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2DecryptGM(this.mHandle, prifid, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int SM2Sign(long handle, byte[] pubfid, byte[] prifid, int dataType, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().SM2Sign(this.mHandle, pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2Sign(this.mHandle, pubfid, prifid, dataType, dataIn, inLen, dataOut, outLen);
        }
        return ret;
    }

    public int SM2SignVerify(long handle, byte[] pubfid, int dataType, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) throws RemoteException {
        int ret = this.getApi().SM2SignVerify(this.mHandle, pubfid, dataType, pubkey, dataIn, inLen, signatureData);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2SignVerify(this.mHandle, pubfid, dataType, pubkey, dataIn, inLen, signatureData);
        }
        return ret;
    }

    public int SM2SignEx(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] signatureData, int[] signatureDataLen) throws RemoteException {
        int ret = this.getApi().SM2SignEx(this.mHandle, pubfid, prifid, dataIn, inLen, signatureData, signatureDataLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2SignEx(this.mHandle, pubfid, prifid, dataIn, inLen, signatureData, signatureDataLen);
        }
        return ret;
    }

    public int SM2SignVerifyEx(long handle, byte[] pubfid, XDJA_SM2_PUBKEY pubkey, byte[] dataIn, int inLen, byte[] signatureData) throws RemoteException {
        int ret = this.getApi().SM2SignVerifyEx(this.mHandle, pubfid, pubkey, dataIn, inLen, signatureData);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2SignVerifyEx(this.mHandle, pubfid, pubkey, dataIn, inLen, signatureData);
        }
        return ret;
    }

    public int SHA1(long handle, byte[] dataIn, int inLen, byte[] dataOut) throws RemoteException {
        int ret = this.getApi().SHA1(this.mHandle, dataIn, inLen, dataOut);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SHA1(this.mHandle, dataIn, inLen, dataOut);
        }
        return ret;
    }

    public int SHA1Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) throws RemoteException {
        int ret = this.getApi().SHA1Ex(this.mHandle, dataIn, inLen, dataOut);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SHA1Ex(this.mHandle, dataIn, inLen, dataOut);
        }
        return ret;
    }

    public int SM3(long handle, byte[] dataIn, int inLen, byte[] dataOut) throws RemoteException {
        int ret = this.getApi().SM3(this.mHandle, dataIn, inLen, dataOut);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM3(this.mHandle, dataIn, inLen, dataOut);
        }
        return ret;
    }

    public int SM3Ex(long handle, byte[] dataIn, int inLen, byte[] dataOut) throws RemoteException {
        int ret = this.getApi().SM3Ex(this.mHandle, dataIn, inLen, dataOut);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM3Ex(this.mHandle, dataIn, inLen, dataOut);
        }
        return ret;
    }

    public int SM2KeyGenInit(long handle, byte[] pubfid, byte[] dataOut, int[] outLen) throws RemoteException {
        int ret = this.getApi().SM2KeyGenInit(this.mHandle, pubfid, dataOut, outLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2KeyGenInit(this.mHandle, pubfid, dataOut, outLen);
        }
        return ret;
    }

    public int SM2KeyGenCompute(long handle, byte[] pubfid, byte[] prifid, byte[] dataIn, int inLen, byte[] dataOut, int[] outLen, byte dictFlag, byte keyFlag) throws RemoteException {
        int ret = this.getApi().SM2KeyGenCompute(this.mHandle, pubfid, prifid, dataIn, inLen, dataOut, outLen, dictFlag, keyFlag);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2KeyGenCompute(this.mHandle, pubfid, prifid, dataIn, inLen, dataOut, outLen, dictFlag, keyFlag);
        }
        return ret;
    }

    public int SM2KeyGenVerify(long handle, byte[] dataIn, int inLen) throws RemoteException {
        int ret = this.getApi().SM2KeyGenVerify(this.mHandle, dataIn, inLen);
        if (this.isDevOnline(ret)) {
            ret = this.getApi().SM2KeyGenVerify(this.mHandle, dataIn, inLen);
        }
        return ret;
    }

    public synchronized int ActivateCardByURL(long handle, String url) throws RemoteException {
        int ret = this.GetActivateState(this.mHandle);
        if (ret == 0) {
            return ret;
        }
        ActivateChip activateChip = new ActivateChip();
        ret = activateChip.activateChip(this.mContext, this.mHandle, url);
        if (ret != 0) {
            switch (ret) {
                case 1: {
                    ret = 0;
                    break;
                }
                case 2: 
                case 3: {
                    ret = -97;
                    break;
                }
                case 4: 
                case 5: {
                    ret = -10010;
                    break;
                }
                case 6: {
                    ret = -10011;
                    break;
                }
                case 7: {
                    ret = -10012;
                    break;
                }
                case 8: {
                    ret = -10013;
                    break;
                }
                case 9: {
                    ret = -10023;
                    break;
                }
                case 30: {
                    ret = -10015;
                    break;
                }
                case 50: {
                    ret = -10024;
                    break;
                }
                case -99999: 
                case -99998: {
                    break;
                }
                case -101: {
                    ret = -10018;
                    break;
                }
                case -201: {
                    ret = -10019;
                    break;
                }
                case -202: {
                    ret = -10025;
                    break;
                }
                case -203: {
                    ret = -10021;
                    break;
                }
                case -204: {
                    ret = -10026;
                    break;
                }
                case -301: {
                    ret = -10022;
                    break;
                }
                default: {
                    ret = -10014;
                }
            }
        }
        return ret;
    }

    public Bundle callMethod(Bundle bundle) throws RemoteException {
        return SupperHandleMethod.getInstance().callMethod(this, bundle);
    }

    protected boolean isDevOnline(int errcode) throws RemoteException {
        if (errcode == -1 || errcode == -2 || errcode == -3 || errcode == -4 || errcode == -11 || errcode == -12 || errcode == -18 || errcode == -29 || errcode == -30 || errcode == -100) {
            this.selfOpenDev();
            return this.mHandle != 0L;
        }
        return false;
    }

    protected String getCardId() {
        String cardId = "";
        XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        try {
            int ret = this.GetDevInfo(0L, devinfo);
            if (ret == 0) {
                cardId = new String(devinfo.cardid, 0, 32);
            }
            Log.w((String)"JniApi", (String)("getCardId ret: " + ret));
            Log.w((String)"JniApi", (String)("getCardId : " + cardId));
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return cardId;
    }

    public JniApiParam getJniApiParam() {
        XDJA_DEVINFO devinfo = new XDJA_DEVINFO();
        try {
            int ret = this.GetDevInfo(this.mHandle, devinfo);
            if (ret == 0) {
                JniApiParam param = new JniApiParam();
                param.chipType = this.getChipType();
                param.cardId = new String(devinfo.cardid).trim();
                return param;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void callUnitePin(int ret, int role, byte[] pin, String method) {
        String cardId = this.getCardId();
        InsideMultiChipUnitePinManager.getInstance().handlePinResult(this.mContext, cardId, role, pin, ret, method, SupperJniApiBinder.getCallingUid(), SupperJniApiBinder.getCallingPid(), "JNIAPI");
    }

    class ErrorCode {
        public static final int GET_SAFE_KEY_INFO_ERROR = -10010;
        public static final int ACTIVATE_SAFE_KEY_FAIL = -10011;
        public static final int ACTIVATE_ERROR_BY_JSON_ENCODE = -10012;
        public static final int ACTIVATE_ERROR_BY_URL = -10013;
        public static final int ACTIVATE_ERROR_BY_SSL = -10014;
        public static final int ACTIVATE_ERROR_BY_JSON_DECODE = -10015;
        public static final int ACTIVATE_ERROR_BY_SERVER = -10018;
        public static final int ACTIVATE_ERROR_BY_PARAMETER = -10019;
        public static final int ACTIVATE_ERROR_BY_KAKU = -10021;
        public static final int NO_THIS_OPERATE_IN_SERVER = -10022;
        public static final int ACTIVATE_ERROR_BY_TIME = -10023;
        public static final int ACTIVATE_ERROR_BY_CONNECT_TIME_OUT = -10024;
        public static final int ACTIVATE_ERROR_BY_NO_EX_FACTORY = -10025;
        public static final int ACTIVATE_ERROR_BY_NO_AVAILABLE_LICENSE = -10026;
        public static final int ERROR_EXCEPTION_JAR = -99998;
        public static final int ERROR_EXCEPTION = -99999;

        ErrorCode() {
        }
    }
}

