/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.sm2cipher.ec;

import com.xdja.cssp.sm2cipher.ec.ECConstants;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract BigInteger toBigInteger();

    public abstract String getFieldName();

    public abstract int getFieldSize();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public String toString() {
        return this.toBigInteger().toString(2);
    }

    public static class Fp
    extends ECFieldElement {
        BigInteger x;
        BigInteger q;

        public Fp(BigInteger q, BigInteger x) {
            this.x = x;
            if (x.compareTo(q) >= 0) {
                throw new IllegalArgumentException("x value too large in field element");
            }
            this.q = q;
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x;
        }

        @Override
        public String getFieldName() {
            return "Fp";
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        public BigInteger getQ() {
            return this.q;
        }

        @Override
        public ECFieldElement add(ECFieldElement b2) {
            return new Fp(this.q, this.x.add(b2.toBigInteger()).mod(this.q));
        }

        @Override
        public ECFieldElement subtract(ECFieldElement b2) {
            return new Fp(this.q, this.x.subtract(b2.toBigInteger()).mod(this.q));
        }

        @Override
        public ECFieldElement multiply(ECFieldElement b2) {
            return new Fp(this.q, this.x.multiply(b2.toBigInteger()).mod(this.q));
        }

        @Override
        public ECFieldElement divide(ECFieldElement b2) {
            return new Fp(this.q, this.x.multiply(b2.toBigInteger().modInverse(this.q)).mod(this.q));
        }

        @Override
        public ECFieldElement negate() {
            return new Fp(this.q, this.x.negate().mod(this.q));
        }

        @Override
        public ECFieldElement square() {
            return new Fp(this.q, this.x.multiply(this.x).mod(this.q));
        }

        @Override
        public ECFieldElement invert() {
            return new Fp(this.q, this.x.modInverse(this.q));
        }

        @Override
        public ECFieldElement sqrt() {
            if (!this.q.testBit(0)) {
                throw new RuntimeException("not done yet");
            }
            if (this.q.testBit(1)) {
                Fp z = new Fp(this.q, this.x.modPow(this.q.shiftRight(2).add(ECConstants.ONE), this.q));
                return ((ECFieldElement)z).square().equals(this) ? z : null;
            }
            BigInteger qMinusOne = this.q.subtract(ECConstants.ONE);
            BigInteger legendreExponent = qMinusOne.shiftRight(1);
            if (!this.x.modPow(legendreExponent, this.q).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger u = qMinusOne.shiftRight(2);
            BigInteger k2 = u.shiftLeft(1).add(ECConstants.ONE);
            BigInteger Q = this.x;
            BigInteger fourQ = Q.shiftLeft(2).mod(this.q);
            Random rand = new Random();
            while (true) {
                BigInteger P;
                if ((P = new BigInteger(this.q.bitLength(), rand)).compareTo(this.q) >= 0 || !P.multiply(P).subtract(fourQ).modPow(legendreExponent, this.q).equals(qMinusOne)) {
                    continue;
                }
                BigInteger[] result = Fp.lucasSequence(this.q, P, Q, k2);
                BigInteger U = result[0];
                BigInteger V = result[1];
                if (V.multiply(V).mod(this.q).equals(fourQ)) {
                    if (V.testBit(0)) {
                        V = V.add(this.q);
                    }
                    V = V.shiftRight(1);
                    return new Fp(this.q, V);
                }
                if (!U.equals(ECConstants.ONE) && !U.equals(qMinusOne)) break;
            }
            return null;
        }

        private static BigInteger[] lucasSequence(BigInteger p, BigInteger P, BigInteger Q, BigInteger k2) {
            int j2;
            int n = k2.bitLength();
            int s = k2.getLowestSetBit();
            BigInteger Uh = ECConstants.ONE;
            BigInteger Vl = ECConstants.TWO;
            BigInteger Vh = P;
            BigInteger Ql = ECConstants.ONE;
            BigInteger Qh = ECConstants.ONE;
            for (j2 = n - 1; j2 >= s + 1; --j2) {
                Ql = Ql.multiply(Qh).mod(p);
                if (k2.testBit(j2)) {
                    Qh = Ql.multiply(Q).mod(p);
                    Uh = Uh.multiply(Vh).mod(p);
                    Vl = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p);
                    Vh = Vh.multiply(Vh).subtract(Qh.shiftLeft(1)).mod(p);
                    continue;
                }
                Qh = Ql;
                Uh = Uh.multiply(Vl).subtract(Ql).mod(p);
                Vh = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p);
                Vl = Vl.multiply(Vl).subtract(Ql.shiftLeft(1)).mod(p);
            }
            Ql = Ql.multiply(Qh).mod(p);
            Qh = Ql.multiply(Q).mod(p);
            Uh = Uh.multiply(Vl).subtract(Ql).mod(p);
            Vl = Vh.multiply(Vl).subtract(P.multiply(Ql)).mod(p);
            Ql = Ql.multiply(Qh).mod(p);
            for (j2 = 1; j2 <= s; ++j2) {
                Uh = Uh.multiply(Vl).mod(p);
                Vl = Vl.multiply(Vl).subtract(Ql.shiftLeft(1)).mod(p);
                Ql = Ql.multiply(Ql).mod(p);
            }
            return new BigInteger[]{Uh, Vl};
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Fp)) {
                return false;
            }
            Fp o = (Fp)other;
            return this.q.equals(o.q) && this.x.equals(o.x);
        }

        public int hashCode() {
            return this.q.hashCode() ^ this.x.hashCode();
        }
    }
}

