/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.sm2cipher.sm2.cipher;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64Util {
    private static final byte[] encodingTable;
    private static final byte[] decodingTable;

    private Base64Util() {
    }

    public static byte[] encode(byte[] data) {
        int modulus = data.length % 3;
        byte[] bytes = modulus == 0 ? new byte[4 * data.length / 3] : new byte[4 * (data.length / 3 + 1)];
        int dataLength = data.length - modulus;
        int i2 = 0;
        int j2 = 0;
        while (i2 < dataLength) {
            int a1 = data[i2] & 0xFF;
            int a2 = data[i2 + 1] & 0xFF;
            int a3 = data[i2 + 2] & 0xFF;
            bytes[j2] = encodingTable[a1 >>> 2 & 0x3F];
            bytes[j2 + 1] = encodingTable[(a1 << 4 | a2 >>> 4) & 0x3F];
            bytes[j2 + 2] = encodingTable[(a2 << 2 | a3 >>> 6) & 0x3F];
            bytes[j2 + 3] = encodingTable[a3 & 0x3F];
            i2 += 3;
            j2 += 4;
        }
        switch (modulus) {
            case 0: {
                break;
            }
            case 1: {
                int d1 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = d1 << 4 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = 61;
                bytes[bytes.length - 1] = 61;
                break;
            }
            case 2: {
                int d1 = data[data.length - 2] & 0xFF;
                int d2 = data[data.length - 1] & 0xFF;
                int b1 = d1 >>> 2 & 0x3F;
                int b2 = (d1 << 4 | d2 >>> 4) & 0x3F;
                int b3 = d2 << 2 & 0x3F;
                bytes[bytes.length - 4] = encodingTable[b1];
                bytes[bytes.length - 3] = encodingTable[b2];
                bytes[bytes.length - 2] = encodingTable[b3];
                bytes[bytes.length - 1] = 61;
            }
        }
        return bytes;
    }

    public static byte[] decode(byte[] data) {
        byte b3;
        byte b2;
        byte b1;
        byte[] bytes = data[data.length - 2] == 61 ? new byte[(data.length / 4 - 1) * 3 + 1] : (data[data.length - 1] == 61 ? new byte[(data.length / 4 - 1) * 3 + 2] : new byte[data.length / 4 * 3]);
        int i2 = 0;
        int j2 = 0;
        while (i2 < data.length - 4) {
            byte b12 = decodingTable[data[i2]];
            byte b22 = decodingTable[data[i2 + 1]];
            byte b32 = decodingTable[data[i2 + 2]];
            byte b4 = decodingTable[data[i2 + 3]];
            bytes[j2] = (byte)(b12 << 2 | b22 >> 4);
            bytes[j2 + 1] = (byte)(b22 << 4 | b32 >> 2);
            bytes[j2 + 2] = (byte)(b32 << 6 | b4);
            i2 += 4;
            j2 += 3;
        }
        if (data[data.length - 2] == 61) {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            bytes[bytes.length - 1] = (byte)(b1 << 2 | b2 >> 4);
        } else if (data[data.length - 1] == 61) {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            b3 = decodingTable[data[data.length - 2]];
            bytes[bytes.length - 2] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 1] = (byte)(b2 << 4 | b3 >> 2);
        } else {
            b1 = decodingTable[data[data.length - 4]];
            b2 = decodingTable[data[data.length - 3]];
            b3 = decodingTable[data[data.length - 2]];
            byte b4 = decodingTable[data[data.length - 1]];
            bytes[bytes.length - 3] = (byte)(b1 << 2 | b2 >> 4);
            bytes[bytes.length - 2] = (byte)(b2 << 4 | b3 >> 2);
            bytes[bytes.length - 1] = (byte)(b3 << 6 | b4);
        }
        return bytes;
    }

    private static boolean ignore(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    public static byte[] decode(String data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            Base64Util.decode(data, bOut);
        }
        catch (IOException e2) {
            throw new RuntimeException("exception decoding base64 string: " + e2);
        }
        return bOut.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        byte b4;
        byte b3;
        byte b2;
        byte b1;
        int end;
        int length = 0;
        for (end = data.length(); end > 0 && Base64Util.ignore(data.charAt(end - 1)); --end) {
        }
        int i2 = 0;
        while (i2 < end - 4) {
            if (Base64Util.ignore(data.charAt(i2))) {
                ++i2;
                continue;
            }
            b1 = decodingTable[data.charAt(i2)];
            b2 = decodingTable[data.charAt(i2 + 1)];
            b3 = decodingTable[data.charAt(i2 + 2)];
            b4 = decodingTable[data.charAt(i2 + 3)];
            out.write(b1 << 2 | b2 >> 4);
            out.write(b2 << 4 | b3 >> 2);
            out.write(b3 << 6 | b4);
            length += 3;
            i2 += 4;
        }
        if (data.charAt(end - 2) == '=') {
            b1 = decodingTable[data.charAt(end - 4)];
            b2 = decodingTable[data.charAt(end - 3)];
            out.write(b1 << 2 | b2 >> 4);
            ++length;
        } else if (data.charAt(end - 1) == '=') {
            b1 = decodingTable[data.charAt(end - 4)];
            b2 = decodingTable[data.charAt(end - 3)];
            b3 = decodingTable[data.charAt(end - 2)];
            out.write(b1 << 2 | b2 >> 4);
            out.write(b2 << 4 | b3 >> 2);
            length += 2;
        } else {
            b1 = decodingTable[data.charAt(end - 4)];
            b2 = decodingTable[data.charAt(end - 3)];
            b3 = decodingTable[data.charAt(end - 2)];
            b4 = decodingTable[data.charAt(end - 1)];
            out.write(b1 << 2 | b2 >> 4);
            out.write(b2 << 4 | b3 >> 2);
            out.write(b3 << 6 | b4);
            length += 3;
        }
        return length;
    }

    static {
        int i2;
        encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        decodingTable = new byte[128];
        for (i2 = 65; i2 <= 90; ++i2) {
            Base64Util.decodingTable[i2] = (byte)(i2 - 65);
        }
        for (i2 = 97; i2 <= 122; ++i2) {
            Base64Util.decodingTable[i2] = (byte)(i2 - 97 + 26);
        }
        for (i2 = 48; i2 <= 57; ++i2) {
            Base64Util.decodingTable[i2] = (byte)(i2 - 48 + 52);
        }
        Base64Util.decodingTable[43] = 62;
        Base64Util.decodingTable[47] = 63;
    }
}

