/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.cssp.sm2cipher.sm2.cipher;

import com.xdja.cssp.sm2cipher.sm2.cipher.BaseDigest;
import com.xdja.cssp.sm2cipher.sm2.cipher.ServiceException;

public class KDF {
    private static final int MAX_LENGTH = 4096;
    private int ct = 1;
    private BaseDigest digest;

    public KDF(BaseDigest digest) {
        this.digest = digest;
    }

    public byte[] genetateKey(byte[] pointBytes, int kLength) throws ServiceException {
        boolean flag;
        int v = this.digest.getDigestSize();
        if (kLength > 4096) {
            throw new ServiceException(1, "", "\u5f85\u52a0\u5bc6\u6570\u636e\u5757\u8fc7\u5927", this.getClass().getName(), "genetateKey", null);
        }
        byte[] key_bytes = new byte[kLength];
        byte[] hash = new byte[v];
        byte[] temp_ct = new byte[4];
        byte[] temp_hash = new byte[pointBytes.length + 4];
        boolean bl = flag = kLength % v == 0;
        while (this.ct < (kLength + v - 1) / v) {
            hash = this.calculateHash(pointBytes, temp_ct, temp_hash, temp_hash);
            System.arraycopy(hash, 0, key_bytes, v * (this.ct - 1), v);
            ++this.ct;
        }
        hash = this.calculateHash(pointBytes, temp_ct, temp_hash, temp_hash);
        if (flag) {
            System.arraycopy(hash, 0, key_bytes, v * (this.ct - 1), v);
        } else {
            System.arraycopy(hash, 0, key_bytes, v * (this.ct - 1), kLength - kLength / v * v);
        }
        return key_bytes;
    }

    private byte[] calculateHash(byte[] pointBytes, byte[] temp_ct, byte[] temp_hash, byte[] hash) {
        System.arraycopy(pointBytes, 0, temp_hash, 0, pointBytes.length);
        temp_ct = this.convertCT(temp_ct);
        System.arraycopy(temp_ct, 0, temp_hash, pointBytes.length, 4);
        this.digest.update(temp_hash);
        hash = this.digest.doFinal();
        return hash;
    }

    private byte[] convertCT(byte[] bytes) {
        bytes[0] = (byte)(this.ct << 24);
        bytes[1] = (byte)(this.ct << 16);
        bytes[2] = (byte)(this.ct << 8);
        bytes[3] = (byte)this.ct;
        return bytes;
    }
}

