/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import org.simalliance.openmobileapi.Session;
import org.simalliance.openmobileapi.service.ISmartcardServiceChannel;
import org.simalliance.openmobileapi.service.SmartcardError;

public class Channel {
    private Session mSession;
    private final ISmartcardServiceChannel mChannel;
    private final Object mLock = new Object();

    Channel(Session session, ISmartcardServiceChannel channel) {
        this.mSession = session;
        this.mChannel = channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.mSession.getReader().getSEService() == null || !this.mSession.getReader().getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mChannel == null) {
            throw new IllegalStateException("channel must not be null");
        }
        if (!this.isClosed()) {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    SmartcardError error = new SmartcardError();
                    this.mChannel.close(error);
                    if (error.isSet()) {
                        error.throwException();
                    }
                }
                catch (Exception e2) {
                    Log.w((String)this.getClass().getSimpleName(), (String)"Error closing channel", (Throwable)e2);
                }
            }
        }
    }

    public boolean isClosed() {
        if (this.mSession.getReader().getSEService() == null || !this.mSession.getReader().getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mChannel == null) {
            throw new IllegalStateException("channel must not be null");
        }
        try {
            return this.mChannel.isClosed();
        }
        catch (RemoteException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    public boolean isBasicChannel() {
        if (this.mSession.getReader().getSEService() == null || !this.mSession.getReader().getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mChannel == null) {
            throw new IllegalStateException("channel must not be null");
        }
        try {
            return this.mChannel.isBasicChannel();
        }
        catch (RemoteException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    public byte[] transmit(byte[] command) throws IOException, IllegalStateException, IllegalArgumentException, SecurityException, NullPointerException {
        if (this.mSession.getReader().getSEService() == null || !this.mSession.getReader().getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mChannel == null) {
            throw new IllegalStateException("channel must not be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                SmartcardError error = new SmartcardError();
                byte[] response = this.mChannel.transmit(command, error);
                if (error.isSet()) {
                    error.throwException();
                }
                return response;
            }
            catch (RemoteException e2) {
                throw new IllegalStateException(e2.getMessage());
            }
        }
    }

    public Session getSession() {
        return this.mSession;
    }

    public byte[] getSelectResponse() {
        if (this.mSession.getReader().getSEService() == null || !this.mSession.getReader().getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mChannel == null) {
            throw new IllegalStateException("channel must not be null");
        }
        try {
            return this.mChannel.getSelectResponse();
        }
        catch (RemoteException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    public boolean selectNext() throws IOException, IllegalStateException, UnsupportedOperationException {
        if (this.mSession.getReader().getSEService() == null || !this.mSession.getReader().getSEService().isConnected()) {
            throw new IllegalStateException("service not connected to system");
        }
        if (this.mChannel == null) {
            throw new IllegalStateException("channel must not be null");
        }
        try {
            if (this.mChannel.isClosed()) {
                throw new IllegalStateException("channel is closed");
            }
        }
        catch (RemoteException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                SmartcardError error = new SmartcardError();
                boolean response = this.mChannel.selectNext(error);
                if (error.isSet()) {
                    error.throwException();
                }
                return response;
            }
            catch (RemoteException e3) {
                throw new IllegalStateException(e3.getMessage());
            }
        }
    }
}

