/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import java.io.IOException;
import org.simalliance.openmobileapi.Channel;
import org.simalliance.openmobileapi.Provider;
import org.simalliance.openmobileapi.internal.BerTlvParser;
import org.simalliance.openmobileapi.internal.ByteArrayConverter;
import org.simalliance.openmobileapi.internal.ErrorStrings;
import org.simalliance.openmobileapi.internal.TlvEntryWrapper;
import org.simalliance.openmobileapi.util.CommandApdu;
import org.simalliance.openmobileapi.util.ResponseApdu;

public class FileViewProvider
extends Provider {
    public static final int CURRENT_FILE = 0;
    public static final int INFO_NOT_AVAILABLE = -1;
    public static final int APPEND_RECORD = -1;
    private static final int FILE_ID_LENGTH = 4;
    private static final int SFI_MIN_VALUE = 1;
    private static final int SFI_MAX_VALUE = 30;
    private static final int REC_NUMBER_MIN_VALUE = 0;
    private static final int REC_NUMBER_MAX_VALUE = 254;
    private static final int OFFSET_LONG_MAX_VALUE = Short.MAX_VALUE;
    private static final int OFFSET_SHORT_MAX_VALUE = 255;
    private static final int FID_MIN_VALUE = 1;
    private static final int FID_MAX_VALUE = 65534;
    private static final int FID_LENGTH = 2;

    public FileViewProvider(Channel channel) throws IllegalStateException {
        super(channel);
    }

    public FCP selectByPath(String path, boolean fromCurrentDF) throws IllegalStateException, IllegalArgumentException, SecurityException, UnsupportedOperationException, IOException {
        if (path == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("path"));
        }
        if (path.isEmpty()) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("path"));
        }
        String[] fileId = path.split(":");
        byte[] pathByteArray = new byte[fileId.length * 4 / 2];
        for (int i2 = 0; i2 < fileId.length; ++i2) {
            if (fileId[i2].length() != 4) {
                throw new IllegalArgumentException("Path elements must be 4-characters long.");
            }
            int fid = Integer.parseInt(fileId[i2], 16);
            if (1 > fid || fid > 65534 || fid == 16383) {
                throw new IllegalArgumentException("Invalid File ID. File ID must be between ");
            }
            System.arraycopy((byte[])ByteArrayConverter.hexStringToByteArray(fileId[i2]), (int)0, (byte[])pathByteArray, (int)(i2 * 4 / 2), (int)2);
        }
        byte p1 = fromCurrentDF ? (byte)9 : 8;
        CommandApdu apdu = new CommandApdu(0, -92, p1, 4, pathByteArray);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                return new FCP(apduResponse.getData());
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27265: {
                throw new UnsupportedOperationException();
            }
            case 27266: {
                throw new IllegalArgumentException("File not found.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public FCP selectByFID(int fileID) throws IllegalStateException, IllegalArgumentException, SecurityException, UnsupportedOperationException, IOException {
        if (1 > fileID || fileID > 65534 || fileID == 16383) {
            throw new IllegalArgumentException("Invalid File ID. File ID must be between ");
        }
        byte[] data = new byte[2];
        System.arraycopy((byte[])ByteArrayConverter.intToByteArray(fileID), (int)2, (byte[])data, (int)0, (int)data.length);
        CommandApdu apdu = new CommandApdu(0, -92, 0, 4, data);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                return new FCP(apduResponse.getData());
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27264: {
                throw new IllegalArgumentException("File not found.");
            }
            case 27265: {
                throw new UnsupportedOperationException();
            }
            case 27266: {
                throw new IllegalArgumentException("File not found.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public FCP selectParent() throws IllegalStateException, SecurityException, UnsupportedOperationException, IOException {
        CommandApdu apdu = new CommandApdu(0, -92, 3, 4, 0);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                return new FCP(apduResponse.getData());
            }
            case 27266: {
                throw new IllegalArgumentException("File not found.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public Record readRecord(int sfi, int recNumber) throws IllegalStateException, IllegalArgumentException, SecurityException, UnsupportedOperationException, IOException {
        if ((sfi < 1 || sfi > 30) && sfi != 0) {
            throw new IllegalArgumentException("Invalid Short File ID. SFI must be between ");
        }
        if (recNumber < 0 || recNumber > 254) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("recordNumber"));
        }
        CommandApdu apdu = new CommandApdu(0, -78, (byte)recNumber, (byte)(sfi << 3 | 4), 0);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                byte[] data = apduResponse.getData();
                return new Record(recNumber, data == null ? new byte[]{} : data);
            }
            case 27009: {
                throw new IllegalStateException("The selected file is not record-based.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27265: {
                throw new UnsupportedOperationException("This operation is not supported by the selected Applet.");
            }
            case 27266: {
                if (sfi == 0) {
                    throw new IllegalStateException("File not found.");
                }
                throw new IllegalArgumentException("File not found.");
            }
            case 27267: {
                return null;
            }
            case 27904: {
                throw new UnsupportedOperationException("This operation is not supported by the selected Applet.");
            }
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public void writeRecord(int sfi, Record rec) throws IllegalArgumentException, IllegalStateException, SecurityException, UnsupportedOperationException, IOException {
        if (rec == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("rec"));
        }
        if ((sfi < 1 || sfi > 30) && sfi != 0) {
            throw new IllegalArgumentException("Invalid Short File ID. SFI must be between ");
        }
        CommandApdu apdu = rec.getNumber() == -1 ? new CommandApdu(0, -30, 0, (byte)(sfi << 3), rec.getData()) : new CommandApdu(0, -36, (byte)rec.getNumber(), (byte)(sfi << 3 | 4), rec.getData());
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                return;
            }
            case 26368: {
                throw new IllegalArgumentException("Wrong length.");
            }
            case 25985: {
                throw new IllegalStateException("Memory failure.");
            }
            case 27009: {
                throw new IllegalStateException("The selected file is not record-based.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27014: {
                throw new IllegalStateException("No file is currently selected.");
            }
            case 27265: {
                throw new UnsupportedOperationException("This operation is not supported by the selected Applet.");
            }
            case 27266: {
                if (sfi == 0) {
                    throw new IllegalStateException("No file is currently selected.");
                }
                throw new IllegalArgumentException("File not found.");
            }
            case 27267: {
                throw new IllegalArgumentException("Record not found.");
            }
            case 27268: {
                throw new IllegalStateException("Not enough memory space in the file.");
            }
            case 27904: {
                throw new UnsupportedOperationException("This operation is not supported by the selected Applet.");
            }
        }
        if (25536 > swValue || swValue > 25551) {
            throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
        }
    }

    public int[] searchRecord(int sfi, byte[] searchPattern) throws IllegalStateException, IllegalArgumentException, SecurityException, UnsupportedOperationException, IOException {
        if ((sfi < 1 || sfi > 30) && sfi != 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("sfi"));
        }
        if (searchPattern == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("searchPattern"));
        }
        if (searchPattern.length == 0 || searchPattern.length > 65535) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("searchPattern"));
        }
        CommandApdu apdu = new CommandApdu(0, -94, 1, (byte)(sfi << 3 | 4), searchPattern, 0);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                byte[] responseData = apduResponse.getData();
                if (responseData != null && responseData.length > 0) {
                    int[] recordNumbers = new int[responseData.length];
                    for (int i2 = 0; i2 < responseData.length; ++i2) {
                        recordNumbers[i2] = responseData[i2];
                    }
                    return recordNumbers;
                }
                return null;
            }
            case 27009: {
                throw new IllegalStateException("The selected file is not record-based.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27014: {
                throw new IllegalStateException("No file is currently selected.");
            }
            case 27265: {
                throw new UnsupportedOperationException("This operation is not supported by the selected Applet.");
            }
            case 27266: {
                throw new IllegalArgumentException("File not found.");
            }
            case 27904: {
                throw new UnsupportedOperationException("This operation is not supported by the selected Applet.");
            }
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public byte[] readBinary(int sfi, int offset, int length) throws IllegalStateException, IllegalArgumentException, SecurityException, UnsupportedOperationException, IOException {
        byte p2;
        byte p1;
        if ((sfi < 1 || sfi > 30) && sfi != 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("sfi"));
        }
        if (offset < 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("offset"));
        }
        if (length < 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("length"));
        }
        if (sfi == 0) {
            if (offset > Short.MAX_VALUE) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("offset"));
            }
            if (length > Short.MAX_VALUE) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("length"));
            }
            p1 = (byte)(0x7F & offset >> 8);
            p2 = (byte)offset;
        } else {
            if (offset > 255) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("offset"));
            }
            if (length > 255) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("length"));
            }
            p1 = (byte)(0x80 | sfi);
            p2 = (byte)offset;
        }
        CommandApdu apdu = new CommandApdu(0, -80, p1, p2, length);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                byte[] data = apduResponse.getData();
                return data == null ? new byte[]{} : data;
            }
            case 27009: {
                throw new IllegalStateException("The selected file is not transparent.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27014: {
                throw new IllegalStateException("No file is currently selected.");
            }
            case 27265: {
                throw new UnsupportedOperationException();
            }
            case 27266: {
                if (sfi == 0) {
                    throw new IllegalStateException("File not found.");
                }
                throw new IllegalArgumentException("File not found.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public void writeBinary(int sfi, byte[] data, int offset, int length) throws IllegalStateException, IllegalArgumentException, SecurityException, UnsupportedOperationException, IOException {
        byte p2;
        byte p1;
        if (data == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("data"));
        }
        if (data.length == 0 || data.length > 255 || data.length != length) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("data"));
        }
        if ((sfi < 1 || sfi > 30) && sfi != 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("sfi"));
        }
        if (offset < 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("offset"));
        }
        if (length < 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("length"));
        }
        if (sfi == 0) {
            if (offset > Short.MAX_VALUE) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("offset"));
            }
            p1 = (byte)(0x7F & offset >> 8);
            p2 = (byte)offset;
        } else {
            if (offset > 255) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("offset"));
            }
            p1 = (byte)(0x80 | 0x9F & sfi);
            p2 = (byte)offset;
        }
        CommandApdu apdu = new CommandApdu(0, -42, p1, p2, data);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                return;
            }
            case 27009: {
                throw new IllegalStateException("The selected file is not transparent.");
            }
            case 27010: {
                throw new SecurityException("Security status not satisfied.");
            }
            case 27014: {
                throw new IllegalStateException("No file is currently selected.");
            }
            case 27265: {
                throw new UnsupportedOperationException();
            }
            case 27266: {
                if (sfi == 0) {
                    throw new IllegalStateException("File not found.");
                }
                throw new IllegalArgumentException("File not found.");
            }
            case 27392: {
                throw new IllegalArgumentException("Offset outside EF.");
            }
            case 27904: {
                throw new UnsupportedOperationException();
            }
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public class Record {
        private int mNumber;
        private byte[] mData;

        public Record(int number, byte[] data) throws IllegalArgumentException {
            if ((0 > number || number > 254) && number != -1) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("number"));
            }
            if (data == null) {
                throw new IllegalArgumentException(ErrorStrings.paramNull("data"));
            }
            if (data.length > 65535) {
                throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("data"));
            }
            this.mNumber = number;
            this.mData = data;
        }

        public byte[] getData() {
            return this.mData;
        }

        public int getNumber() {
            return this.mNumber;
        }
    }

    public class FCP {
        public static final byte FCPTAG_FCP_TEMPLATE = 98;
        public static final byte FCPTAG_FILE_SIZE = -128;
        public static final byte FCPTAG_TOTAL_FILE_SIZE = -127;
        public static final byte FCPTAG_FILE_DESCRIPTOR = -126;
        public static final byte FCPTAG_FILE_ID = -125;
        public static final byte FCPTAG_SFI = -120;
        public static final byte FCPTAG_LCS = -118;
        public static final byte FILETYPE_DF = 0;
        public static final byte FILETYPE_EF = 1;
        public static final int FILESTRUCTURE_NO_EF = 0;
        public static final int FILESTRUCTURE_TRANSPARENT = 1;
        public static final int FILESTRUCTURE_LINEAR_FIXED = 2;
        public static final int FILESTRUCTURE_LINEAR_VARIABLE = 3;
        public static final int FILESTRUCTURE_CYCLIC = 4;
        public static final int LCS_NO_INFORMATION_GIVEN = 0;
        public static final int LCS_CREATION_STATE = 1;
        public static final int LCS_INITIALISATION_STATE = 2;
        public static final int LCS_OPERATIONAL_STATE_ACTIVATED = 3;
        public static final int LCS_OPERATIONAL_STATE_DEACTIVATED = 4;
        public static final int LCS_TERMINATION_STATE = 5;
        private byte[] mRawFcpData;

        public FCP(byte[] rawTlvData) throws IllegalArgumentException {
            BerTlvParser parser = new BerTlvParser();
            int fcpStartPosition = parser.searchTag(rawTlvData, new byte[]{98}, 0);
            this.mRawFcpData = new TlvEntryWrapper(rawTlvData, fcpStartPosition, parser).getValue();
        }

        public byte[] getFCP() {
            return this.mRawFcpData;
        }

        public int getFileSize() {
            BerTlvParser parser = new BerTlvParser();
            try {
                int position = parser.searchTag(this.mRawFcpData, new byte[]{-128}, 0);
                byte[] fileSize = new TlvEntryWrapper(this.mRawFcpData, position, parser).getValue();
                return ByteArrayConverter.byteArrayToInt(fileSize);
            }
            catch (IllegalArgumentException e2) {
                return -1;
            }
        }

        public int getTotalFileSize() {
            BerTlvParser parser = new BerTlvParser();
            try {
                int position = parser.searchTag(this.mRawFcpData, new byte[]{-127}, 0);
                byte[] totalFileSize = new TlvEntryWrapper(this.mRawFcpData, position, parser).getValue();
                return ByteArrayConverter.byteArrayToInt(totalFileSize);
            }
            catch (IllegalArgumentException e2) {
                return -1;
            }
        }

        public int getFID() {
            BerTlvParser parser = new BerTlvParser();
            try {
                int position = parser.searchTag(this.mRawFcpData, new byte[]{-125}, 0);
                byte[] fileId = new TlvEntryWrapper(this.mRawFcpData, position, parser).getValue();
                return ByteArrayConverter.byteArrayToInt(fileId);
            }
            catch (IllegalArgumentException e2) {
                return -1;
            }
        }

        public int getSFI() {
            BerTlvParser parser = new BerTlvParser();
            try {
                int position = parser.searchTag(this.mRawFcpData, new byte[]{-120}, 0);
                byte[] sfi = new TlvEntryWrapper(this.mRawFcpData, position, parser).getValue();
                if (sfi.length == 0) {
                    return -1;
                }
                if (sfi.length == 1) {
                    if ((sfi[0] & 7) == 0) {
                        return sfi[0] >>> 3;
                    }
                    return -1;
                }
                return -1;
            }
            catch (IllegalArgumentException e2) {
                return -1;
            }
        }

        public int getMaxRecordSize() {
            BerTlvParser parser = new BerTlvParser();
            try {
                int position = parser.searchTag(this.mRawFcpData, new byte[]{-126}, 0);
                byte[] fileDescriptor = new TlvEntryWrapper(this.mRawFcpData, position, parser).getValue();
                if (fileDescriptor.length < 3) {
                    return -1;
                }
                byte[] maxRecSize = fileDescriptor.length == 3 ? new byte[1] : new byte[2];
                System.arraycopy((byte[])fileDescriptor, (int)2, (byte[])maxRecSize, (int)0, (int)maxRecSize.length);
                return ByteArrayConverter.byteArrayToInt(maxRecSize);
            }
            catch (IllegalArgumentException e2) {
                return -1;
            }
        }

        public int getNumberOfRecords() {
            BerTlvParser parser = new BerTlvParser();
            try {
                int position = parser.searchTag(this.mRawFcpData, new byte[]{-126}, 0);
                byte[] fileDescriptor = new TlvEntryWrapper(this.mRawFcpData, position, parser).getValue();
                if (fileDescriptor.length < 5) {
                    return -1;
                }
                byte[] numberOfRecords = fileDescriptor.length == 5 ? new byte[1] : new byte[2];
                System.arraycopy((byte[])fileDescriptor, (int)4, (byte[])numberOfRecords, (int)0, (int)numberOfRecords.length);
                return ByteArrayConverter.byteArrayToInt(numberOfRecords);
            }
            catch (IllegalArgumentException e2) {
                return -1;
            }
        }

        public int getFileType() {
            BerTlvParser parser = new BerTlvParser();
            try {
                boolean isDf;
                int position = parser.searchTag(this.mRawFcpData, new byte[]{-126}, 0);
                byte[] fileDescriptor = new TlvEntryWrapper(this.mRawFcpData, position, parser).getValue();
                boolean bl = isDf = (fileDescriptor[0] & 0xBF) == 56;
                if (isDf) {
                    return 0;
                }
                return 1;
            }
            catch (IllegalArgumentException e2) {
                return -1;
            }
        }

        public int getFileStructure() {
            BerTlvParser parser = new BerTlvParser();
            try {
                int position = parser.searchTag(this.mRawFcpData, new byte[]{-126}, 0);
                byte[] fileDescriptor = new TlvEntryWrapper(this.mRawFcpData, position, parser).getValue();
                switch (fileDescriptor[0] & 7) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: 
                    case 3: {
                        return 2;
                    }
                    case 4: 
                    case 5: {
                        return 3;
                    }
                    case 6: 
                    case 7: {
                        return 4;
                    }
                }
                return -1;
            }
            catch (IllegalArgumentException e2) {
                return -1;
            }
        }

        public int getLCS() {
            BerTlvParser parser = new BerTlvParser();
            try {
                int position = parser.searchTag(this.mRawFcpData, new byte[]{-118}, 0);
                byte[] lcs = new TlvEntryWrapper(this.mRawFcpData, position, parser).getValue();
                switch (lcs[0]) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                    case 5: 
                    case 7: {
                        return 3;
                    }
                    case 4: 
                    case 6: {
                        return 4;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        return 5;
                    }
                }
                return -1;
            }
            catch (IllegalArgumentException e2) {
                return -1;
            }
        }
    }
}

