/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import android.os.RemoteException;
import java.io.IOException;
import org.simalliance.openmobileapi.SEService;
import org.simalliance.openmobileapi.Session;
import org.simalliance.openmobileapi.service.ISmartcardServiceReader;
import org.simalliance.openmobileapi.service.ISmartcardServiceSession;
import org.simalliance.openmobileapi.service.SmartcardError;

public class Reader {
    private final String mName;
    private final SEService mService;
    private ISmartcardServiceReader mReader;
    private final Object mLock = new Object();

    Reader(SEService service, ISmartcardServiceReader reader, String name) {
        this.mName = name;
        this.mService = service;
        this.mReader = reader;
    }

    public String getName() {
        return this.mName;
    }

    public Session openSession() throws IOException {
        if (this.mService == null || !this.mService.isConnected()) {
            throw new IllegalStateException("service is not connected");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                SmartcardError error = new SmartcardError();
                ISmartcardServiceSession session = this.mReader.openSession(error);
                if (error.isSet()) {
                    error.throwException();
                }
                return new Session(session, this);
            }
            catch (RemoteException e2) {
                throw new IOException(e2.getMessage());
            }
        }
    }

    public boolean isSecureElementPresent() {
        if (this.mService == null || !this.mService.isConnected()) {
            throw new IllegalStateException("service is not connected");
        }
        try {
            return this.mReader.isSecureElementPresent();
        }
        catch (RemoteException e2) {
            throw new IllegalStateException(e2.getMessage());
        }
    }

    public SEService getSEService() {
        return this.mService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSessions() {
        if (this.mService == null || !this.mService.isConnected()) {
            throw new IllegalStateException("service is not connected");
        }
        Object object = this.mLock;
        synchronized (object) {
            SmartcardError error = new SmartcardError();
            try {
                this.mReader.closeSessions(error);
            }
            catch (RemoteException e2) {
                throw new IllegalStateException(e2.getMessage());
            }
        }
    }
}

