/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import java.util.Arrays;
import org.simalliance.openmobileapi.SERecognizer;
import org.simalliance.openmobileapi.Session;
import org.simalliance.openmobileapi.internal.ErrorStrings;

public class SERecognizerByATR
extends SERecognizer {
    public static final int ATR_MIN_LENGTH = 2;
    public static final int ATR_MAX_LENGTH = 32;
    private byte[] mAtr;
    private byte[] mMask;

    public SERecognizerByATR(byte[] atr, byte[] mask) throws IllegalArgumentException {
        if (atr == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("atr"));
        }
        if (mask == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("mask"));
        }
        if (atr.length < 2 || atr.length > 32) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("atr"));
        }
        if (atr.length != mask.length) {
            throw new IllegalArgumentException("atr length and mask length must be equal.");
        }
        this.mAtr = new byte[atr.length];
        System.arraycopy((byte[])atr, (int)0, (byte[])this.mAtr, (int)0, (int)atr.length);
        this.mMask = new byte[mask.length];
        System.arraycopy((byte[])mask, (int)0, (byte[])this.mMask, (int)0, (int)mask.length);
    }

    @Override
    public boolean isMatching(Session session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("session"));
        }
        byte[] sessionAtr = session.getATR();
        if (sessionAtr.length != this.mAtr.length) {
            return false;
        }
        return Arrays.equals(this.maskAtr(this.mAtr, this.mMask), this.maskAtr(sessionAtr, this.mMask));
    }

    private byte[] maskAtr(byte[] atr, byte[] mask) {
        byte[] maskedAtr = new byte[atr.length];
        for (int i2 = 0; i2 < atr.length; ++i2) {
            maskedAtr[i2] = (byte)(atr[i2] & mask[i2]);
        }
        return maskedAtr;
    }
}

