/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi;

import java.io.IOException;
import java.util.ArrayList;
import org.simalliance.openmobileapi.Channel;
import org.simalliance.openmobileapi.Provider;
import org.simalliance.openmobileapi.internal.ByteArrayConverter;
import org.simalliance.openmobileapi.internal.ErrorStrings;
import org.simalliance.openmobileapi.util.CommandApdu;
import org.simalliance.openmobileapi.util.ResponseApdu;

public class SecureStorageProvider
extends Provider {
    public static final int MAX_TITLE_LENGTH = 60;
    public static final byte INS_PING_SS_APPLET = -86;
    public static final byte INS_CREATE_SS_ENTRY = -32;
    public static final byte INS_DELETE_ALL_SS_ENTRIES = -27;
    public static final byte INS_DELETE_SS_ENTRY = -28;
    public static final byte INS_GET_SS_ENTRY_DATA = -54;
    public static final byte INS_GET_SS_ENTRY_ID = -78;
    public static final byte INS_SELECT_SS_ENTRY = -91;
    public static final byte INS_PUT_SS_ENTRY_DATA = -38;

    public SecureStorageProvider(Channel channel) throws IllegalStateException {
        super(channel);
        if (!this.sendPingCommand()) {
            throw new IllegalStateException("Channel is not connected to a Secure Storage applet.");
        }
    }

    public void create(String title, byte[] data) throws IllegalStateException, IllegalArgumentException, SecurityException, IOException {
        int id;
        if (title == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("title"));
        }
        if (title.length() == 0) {
            throw new IllegalArgumentException("The title is empty");
        }
        if (title.length() > 60) {
            throw new IllegalArgumentException("The title is too long (max value 60 chars).");
        }
        try {
            id = this.sendCreateEntryCommand(title);
        }
        catch (ProcessingException e2) {
            switch (e2.getSwValue()) {
                case 25985: {
                    throw new IOException("File creation failed due to memory issues.");
                }
                case 27264: {
                    throw new IllegalArgumentException("The specified title already exists.");
                }
                case 27010: 
                case 27266: {
                    throw new SecurityException("Security status not satisfied.");
                }
                case 27268: {
                    throw new IOException("Not enough memory space");
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e2.getSwValue()));
        }
        if (data != null && data.length != 0) {
            int currentBufferSize;
            try {
                this.sendSelectCommand(id);
            }
            catch (ProcessingException e3) {
                try {
                    this.sendDeleteEntryCommand(id);
                }
                catch (ProcessingException t) {
                    // empty catch block
                }
                throw new IOException("Create process failed. Select operation failed: " + ErrorStrings.unexpectedStatusWord(e3.getSwValue()));
            }
            catch (IOException e4) {
                try {
                    this.sendDeleteEntryCommand(id);
                }
                catch (ProcessingException t) {
                    // empty catch block
                }
                throw e4;
            }
            try {
                this.sendPutDataCommand(data.length);
            }
            catch (ProcessingException e5) {
                try {
                    this.sendDeleteEntryCommand(id);
                }
                catch (ProcessingException t) {
                    // empty catch block
                }
                if (e5.getSwValue() == 25985) {
                    throw new IllegalArgumentException("File creation failed due to memory issues.");
                }
                throw new IOException("Create process failed. Put data operation failed: " + ErrorStrings.unexpectedStatusWord(e5.getSwValue()));
            }
            catch (IOException e6) {
                try {
                    this.sendDeleteEntryCommand(id);
                }
                catch (ProcessingException t) {
                    // empty catch block
                }
                throw e6;
            }
            for (int position = 0; position < data.length; position += currentBufferSize) {
                int remainingBytes = data.length - position;
                currentBufferSize = remainingBytes < 255 ? remainingBytes : 255;
                byte[] buffer = new byte[currentBufferSize];
                System.arraycopy((byte[])data, (int)position, (byte[])buffer, (int)0, (int)currentBufferSize);
                PutDataP1 p1 = position == 0 ? PutDataP1.First : PutDataP1.Next;
                try {
                    this.sendPutDataCommand(p1, buffer);
                    continue;
                }
                catch (ProcessingException e7) {
                    try {
                        this.sendDeleteEntryCommand(id);
                    }
                    catch (ProcessingException t) {
                        // empty catch block
                    }
                    if (e7.getSwValue() == 25985) {
                        throw new IllegalArgumentException("File creation failed due to memory issues.");
                    }
                    if (e7.getSwValue() == 27268) {
                        throw new IllegalArgumentException("Not enough memory space");
                    }
                    throw new IOException("Create process failed. Put data operation failed: " + ErrorStrings.unexpectedStatusWord(e7.getSwValue()));
                }
                catch (IOException e8) {
                    try {
                        this.sendDeleteEntryCommand(id);
                    }
                    catch (ProcessingException t) {
                        // empty catch block
                    }
                    throw e8;
                }
            }
        }
    }

    public void update(String title, byte[] data) throws IllegalStateException, IllegalArgumentException, SecurityException, IOException {
        byte[] buffer;
        int id;
        if (title == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("title"));
        }
        if (title.length() == 0) {
            throw new IllegalArgumentException("The title is empty");
        }
        if (title.length() > 60) {
            throw new IllegalArgumentException("The title is too long (max value 60 chars).");
        }
        if (data == null) {
            data = new byte[]{};
        }
        try {
            id = this.sendGetIdCommand(title);
        }
        catch (ProcessingException e2) {
            switch (e2.getSwValue()) {
                case 27010: 
                case 27266: {
                    throw new SecurityException("Security status not satisfied.");
                }
                case 27272: {
                    throw new IllegalArgumentException("Referenced data not found (if no SeS entry is currently selected");
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e2.getSwValue()));
        }
        try {
            this.sendSelectCommand(id);
        }
        catch (ProcessingException e3) {
            switch (e3.getSwValue()) {
                case 27010: {
                    throw new SecurityException("Security status not satisfied.");
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e3.getSwValue()));
        }
        byte[] previousData = this.read(title);
        try {
            this.sendPutDataCommand(data.length);
        }
        catch (ProcessingException e4) {
            switch (e4.getSwValue()) {
                case 25985: {
                    throw new IllegalArgumentException("File creation failed due to memory issues.");
                }
                case 27268: {
                    throw new IllegalArgumentException("Not enough memory space");
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e4.getSwValue()));
        }
        for (int position = 0; position < data.length; position += buffer.length) {
            int remainingBytes = data.length - position;
            buffer = remainingBytes < 65535 ? new byte[remainingBytes] : new byte[remainingBytes];
            System.arraycopy((byte[])data, (int)position, (byte[])buffer, (int)0, (int)buffer.length);
            PutDataP1 p1 = position == 0 ? PutDataP1.First : PutDataP1.Next;
            try {
                this.sendPutDataCommand(p1, buffer);
                continue;
            }
            catch (ProcessingException e5) {
                try {
                    this.sendDeleteEntryCommand(id);
                    this.create(title, previousData);
                }
                catch (ProcessingException t) {
                    // empty catch block
                }
                if (e5.getSwValue() == 25985) {
                    throw new IllegalArgumentException("File creation failed due to memory issues.");
                }
                if (e5.getSwValue() == 27268) {
                    throw new IllegalArgumentException("Not enough memory space");
                }
                throw new IOException("Update process failed. Put data operation failed: " + ErrorStrings.unexpectedStatusWord(e5.getSwValue()));
            }
            catch (IOException e6) {
                try {
                    this.sendDeleteEntryCommand(id);
                    this.create(title, previousData);
                }
                catch (ProcessingException t) {
                    // empty catch block
                }
                throw e6;
            }
        }
    }

    public byte[] read(String title) throws IllegalStateException, IOException, IllegalArgumentException, SecurityException {
        byte[] buffer;
        byte[] data;
        int dataSize;
        int id;
        if (title == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("title"));
        }
        if (title.length() == 0 || title.length() > 60) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidArrayLength("title"));
        }
        try {
            id = this.sendGetIdCommand(title);
        }
        catch (ProcessingException e2) {
            switch (e2.getSwValue()) {
                case 27010: 
                case 27266: {
                    throw new SecurityException("Security status not satisfied.");
                }
                case 27272: {
                    return new byte[0];
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e2.getSwValue()));
        }
        try {
            this.sendSelectCommand(id);
        }
        catch (ProcessingException e3) {
            switch (e3.getSwValue()) {
                case 27010: {
                    throw new SecurityException("Security status not satisfied.");
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e3.getSwValue()));
        }
        try {
            dataSize = ByteArrayConverter.byteArrayToInt(this.sendGetDataCommand(GetDataP1.Size));
            data = new byte[dataSize];
        }
        catch (ProcessingException e4) {
            switch (e4.getSwValue()) {
                case 27010: {
                    throw new SecurityException("Security status not satisfied.");
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e4.getSwValue()));
        }
        for (int bytesRecieved = 0; bytesRecieved < dataSize; bytesRecieved += buffer.length) {
            GetDataP1 p1 = bytesRecieved == 0 ? GetDataP1.First : GetDataP1.Next;
            try {
                buffer = this.sendGetDataCommand(p1);
                System.arraycopy((byte[])buffer, (int)0, (byte[])data, (int)bytesRecieved, (int)buffer.length);
                continue;
            }
            catch (ProcessingException e5) {
                switch (e5.getSwValue()) {
                    case 27010: {
                        throw new SecurityException("Security status not satisfied.");
                    }
                }
                throw new IOException(ErrorStrings.unexpectedStatusWord(e5.getSwValue()));
            }
        }
        return data;
    }

    public boolean exist(String title) throws IllegalStateException, IllegalArgumentException, SecurityException, IOException {
        if (title == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("title"));
        }
        if (title.length() == 0) {
            throw new IllegalArgumentException("The title is empty");
        }
        if (title.length() > 60) {
            throw new IllegalArgumentException("The title is too long (max value 60 chars).");
        }
        try {
            this.sendGetIdCommand(title);
            return true;
        }
        catch (ProcessingException e2) {
            switch (e2.getSwValue()) {
                case 27272: {
                    return false;
                }
                case 27010: 
                case 27266: {
                    throw new SecurityException("Security status not satisfied.");
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e2.getSwValue()));
        }
    }

    public boolean delete(String title) throws IllegalStateException, IllegalArgumentException, IOException, SecurityException {
        int id;
        if (title == null) {
            throw new IllegalArgumentException(ErrorStrings.paramNull("title"));
        }
        if (title.length() == 0) {
            throw new IllegalArgumentException("The title is empty");
        }
        if (title.length() > 60) {
            throw new IllegalArgumentException("The title is too long (max value 60 chars).");
        }
        try {
            id = this.sendGetIdCommand(title);
        }
        catch (ProcessingException e2) {
            switch (e2.getSwValue()) {
                case 27010: 
                case 27266: {
                    throw new SecurityException("Security status not satisfied.");
                }
                case 27272: {
                    return false;
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e2.getSwValue()));
        }
        try {
            return this.sendDeleteEntryCommand(id);
        }
        catch (ProcessingException e3) {
            switch (e3.getSwValue()) {
                case 25985: {
                    throw new IOException("Memory failure.");
                }
                case 27010: {
                    throw new SecurityException("Security status not satisfied.");
                }
            }
            throw new IOException(ErrorStrings.unexpectedStatusWord(e3.getSwValue()));
        }
    }

    public void deleteAll() throws IllegalStateException, SecurityException, IOException {
        CommandApdu apdu = new CommandApdu(-128, -27, 0, 0);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        switch (swValue) {
            case 36864: {
                return;
            }
            case 25985: {
                throw new IOException("Memory failure.");
            }
            case 27010: 
            case 27266: {
                throw new SecurityException("Security status not satisfied.");
            }
        }
        throw new IOException(ErrorStrings.unexpectedStatusWord(swValue));
    }

    public String[] list() throws IllegalStateException, SecurityException, IOException {
        ArrayList<String> titles = new ArrayList<String>();
        boolean allEntriesHasBeenRead = false;
        try {
            titles.add(this.sendSelectCommand(SelectP1.First));
        }
        catch (ProcessingException e2) {
            switch (e2.getSwValue()) {
                case 27272: {
                    allEntriesHasBeenRead = true;
                    break;
                }
                case 27010: 
                case 27266: {
                    throw new SecurityException("Security status not satisfied.");
                }
                default: {
                    throw new IOException(ErrorStrings.unexpectedStatusWord(e2.getSwValue()));
                }
            }
        }
        block12: while (!allEntriesHasBeenRead) {
            try {
                titles.add(this.sendSelectCommand(SelectP1.Next));
            }
            catch (ProcessingException e3) {
                switch (e3.getSwValue()) {
                    case 27272: {
                        allEntriesHasBeenRead = true;
                        continue block12;
                    }
                    case 27010: {
                        throw new SecurityException("Security status not satisfied.");
                    }
                }
                throw new IOException(ErrorStrings.unexpectedStatusWord(e3.getSwValue()));
            }
        }
        return titles.toArray(new String[titles.size()]);
    }

    private boolean sendPingCommand() {
        CommandApdu apdu = new CommandApdu(-128, -86, 0, 0);
        try {
            ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
            return apduResponse.getSwValue() == 36864;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private int sendCreateEntryCommand(String title) throws IOException, ProcessingException {
        byte[] titleArray = title.getBytes();
        CommandApdu apdu = new CommandApdu(-128, -32, 0, 0, titleArray, 2);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        if (swValue == 36864) {
            return ByteArrayConverter.byteArrayToInt(apduResponse.getData());
        }
        throw new ProcessingException(swValue);
    }

    private boolean sendDeleteEntryCommand(int id) throws IOException, ProcessingException {
        byte[] idArray = ByteArrayConverter.intToByteArray(id);
        CommandApdu apdu = new CommandApdu(-128, -28, idArray[2], idArray[3]);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        if (swValue == 36864) {
            return true;
        }
        if (swValue == 27272) {
            return false;
        }
        throw new ProcessingException(swValue);
    }

    private String sendSelectCommand(SelectP1 p1, int id) throws IOException, ProcessingException {
        CommandApdu apdu = null;
        switch (p1) {
            case Id: {
                byte[] idByteArray = new byte[2];
                System.arraycopy((byte[])ByteArrayConverter.intToByteArray(id), (int)2, (byte[])idByteArray, (int)0, (int)2);
                apdu = new CommandApdu(-128, -91, 0, 0, idByteArray, 0);
                break;
            }
            case First: {
                apdu = new CommandApdu(-128, -91, 1, 0, 0);
                break;
            }
            case Next: {
                apdu = new CommandApdu(-128, -91, 2, 0, 0);
            }
        }
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        if (swValue == 36864) {
            return new String(apduResponse.getData(), "UTF-8");
        }
        throw new ProcessingException(swValue);
    }

    private String sendSelectCommand(SelectP1 p1) throws IOException, ProcessingException, IllegalArgumentException {
        if (p1 == SelectP1.Id) {
            throw new IllegalArgumentException();
        }
        return this.sendSelectCommand(p1, 0);
    }

    private String sendSelectCommand(int id) throws IOException, ProcessingException {
        return this.sendSelectCommand(SelectP1.Id, id);
    }

    private void sendPutDataCommand(PutDataP1 p1, byte[] data) throws IOException, ProcessingException {
        byte mP1 = 0;
        switch (p1) {
            case Size: {
                mP1 = 0;
                break;
            }
            case First: {
                mP1 = 1;
                break;
            }
            case Next: {
                mP1 = 2;
            }
        }
        CommandApdu apdu = new CommandApdu(-128, -38, mP1, 0, data);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        if (swValue != 36864) {
            throw new ProcessingException(swValue);
        }
    }

    private void sendPutDataCommand(int dataSize) throws IOException, ProcessingException {
        byte[] baDataSize = new byte[2];
        System.arraycopy((byte[])ByteArrayConverter.intToByteArray(dataSize), (int)2, (byte[])baDataSize, (int)0, (int)2);
        this.sendPutDataCommand(PutDataP1.Size, baDataSize);
    }

    private byte[] sendGetDataCommand(GetDataP1 p1) throws IOException, ProcessingException {
        byte mP1 = 0;
        switch (p1) {
            case Size: {
                mP1 = 0;
                break;
            }
            case First: {
                mP1 = 1;
                break;
            }
            case Next: {
                mP1 = 2;
            }
        }
        CommandApdu apdu = new CommandApdu(-128, -54, mP1, 0, 0);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        if (swValue == 36864) {
            return apduResponse.getData();
        }
        throw new ProcessingException(swValue);
    }

    private int sendGetIdCommand(String title) throws IOException, ProcessingException {
        CommandApdu apdu = new CommandApdu(-128, -78, 0, 0, title.getBytes(), 2);
        ResponseApdu apduResponse = new ResponseApdu(this.getChannel().transmit(apdu.toByteArray()));
        int swValue = apduResponse.getSwValue();
        if (swValue == 36864) {
            return ByteArrayConverter.byteArrayToInt(apduResponse.getData());
        }
        throw new ProcessingException(swValue);
    }

    private class ProcessingException
    extends Exception {
        private int mSwValue;

        private ProcessingException(int swValue) {
            this.mSwValue = swValue;
        }

        private int getSwValue() {
            return this.mSwValue;
        }
    }

    private static enum GetDataP1 {
        Size,
        First,
        Next;

    }

    private static enum PutDataP1 {
        Size,
        First,
        Next;

    }

    private static enum SelectP1 {
        Id,
        First,
        Next;

    }
}

