/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.internal;

import org.simalliance.openmobileapi.internal.ByteArrayConverter;
import org.simalliance.openmobileapi.internal.TlvParser;

public final class BerTlvParser
extends TlvParser {
    @Override
    public byte[] getTagBytes(byte[] array, int position) throws IllegalArgumentException {
        byte[] tagBytes;
        if ((array[position] & 0x1F) != 31) {
            tagBytes = new byte[1];
        } else {
            if (array[position + 1] >= 0 && array[position + 1] <= 30 || (array[position + 1] & 0xFF) == 128) {
                throw new IllegalArgumentException("Invalid \"tag\" field at position " + position + ".");
            }
            if ((array[position + 1] & 0x80) == 0) {
                tagBytes = new byte[2];
            } else if ((array[position + 1] & 0x80) == 128 && (array[position + 2] & 0x80) == 0) {
                tagBytes = new byte[3];
            } else {
                throw new IllegalArgumentException("Invalid \"tag\" field at position " + position + ".");
            }
        }
        System.arraycopy((byte[])array, (int)position, (byte[])tagBytes, (int)0, (int)tagBytes.length);
        return tagBytes;
    }

    @Override
    public byte[] getLengthBytes(byte[] array, int position) throws IllegalArgumentException {
        byte[] length;
        if ((array[position] & 0xFF) < 128) {
            length = new byte[1];
        } else if ((array[position] & 0xFF) == 129) {
            length = new byte[2];
        } else if ((array[position] & 0xFF) == 130) {
            length = new byte[3];
        } else if ((array[position] & 0xFF) == 131) {
            length = new byte[4];
        } else if ((array[position] & 0xFF) == 132) {
            length = new byte[5];
        } else {
            throw new IllegalArgumentException("Invalid length field at position " + position + ".");
        }
        System.arraycopy((byte[])array, (int)position, (byte[])length, (int)0, (int)length.length);
        return length;
    }

    @Override
    public int getLengthValue(byte[] lengthBytes) {
        byte[] lengthValue;
        int valueStartPosition;
        if (lengthBytes.length == 1) {
            valueStartPosition = 0;
            lengthValue = new byte[1];
        } else {
            valueStartPosition = 1;
            lengthValue = new byte[lengthBytes.length - 1];
        }
        System.arraycopy((byte[])lengthBytes, (int)valueStartPosition, (byte[])lengthValue, (int)0, (int)lengthValue.length);
        return ByteArrayConverter.byteArrayToInt(lengthValue);
    }
}

