/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.internal;

import org.simalliance.openmobileapi.internal.ByteArrayConverter;
import org.simalliance.openmobileapi.internal.ErrorStrings;

public final class DerTlvCoder {
    public static final byte[] TAG_INTEGER = new byte[]{2};
    public static final byte[] TAG_OCTET_STRING = new byte[]{4};
    public static final byte[] TAG_SEQUENCE = new byte[]{48};

    private DerTlvCoder() {
    }

    public static byte[] encodeLength(int lengthValue) throws IllegalArgumentException {
        if (lengthValue < 0) {
            throw new IllegalArgumentException(ErrorStrings.paramInvalidValue("lengthValue"));
        }
        byte[] rawLength = ByteArrayConverter.intToByteArray(lengthValue);
        byte[] encodedLength = lengthValue <= 127 ? new byte[]{(byte)(0x7F & rawLength[3])} : (lengthValue <= 255 ? new byte[]{-127, rawLength[3]} : (lengthValue <= 65535 ? new byte[]{-126, rawLength[2], rawLength[3]} : (lengthValue <= 0xFFFFFF ? new byte[]{-125, rawLength[1], rawLength[2], rawLength[3]} : new byte[]{-124, rawLength[0], rawLength[1], rawLength[2], rawLength[3]})));
        return encodedLength;
    }

    public static byte[] encodeInteger(int value) {
        byte[] valueByteArray = ByteArrayConverter.intToByteArray(value);
        while (valueByteArray[0] == 0) {
            byte[] tmp = new byte[valueByteArray.length - 1];
            System.arraycopy((byte[])valueByteArray, (int)1, (byte[])tmp, (int)0, (int)tmp.length);
            valueByteArray = new byte[tmp.length];
            System.arraycopy((byte[])tmp, (int)0, (byte[])valueByteArray, (int)0, (int)tmp.length);
        }
        byte[] lengthByteArray = DerTlvCoder.encodeLength(valueByteArray.length);
        byte[] encodedInteger = new byte[TAG_INTEGER.length + lengthByteArray.length + valueByteArray.length];
        System.arraycopy((byte[])TAG_INTEGER, (int)0, (byte[])encodedInteger, (int)0, (int)TAG_INTEGER.length);
        System.arraycopy((byte[])lengthByteArray, (int)0, (byte[])encodedInteger, (int)TAG_INTEGER.length, (int)lengthByteArray.length);
        System.arraycopy((byte[])valueByteArray, (int)0, (byte[])encodedInteger, (int)(TAG_INTEGER.length + lengthByteArray.length), (int)valueByteArray.length);
        return encodedInteger;
    }

    public static byte[] encodeOctetString(byte[] octetString) {
        byte[] lengthByteArray = DerTlvCoder.encodeLength(octetString.length);
        byte[] encodedOctetString = new byte[TAG_OCTET_STRING.length + lengthByteArray.length + octetString.length];
        System.arraycopy((byte[])TAG_OCTET_STRING, (int)0, (byte[])encodedOctetString, (int)0, (int)TAG_OCTET_STRING.length);
        System.arraycopy((byte[])lengthByteArray, (int)0, (byte[])encodedOctetString, (int)TAG_OCTET_STRING.length, (int)lengthByteArray.length);
        System.arraycopy((byte[])octetString, (int)0, (byte[])encodedOctetString, (int)(TAG_OCTET_STRING.length + lengthByteArray.length), (int)octetString.length);
        return encodedOctetString;
    }

    public static byte[] encodeSequence(byte[] sequence) {
        byte[] lengthByteArray = DerTlvCoder.encodeLength(sequence.length);
        byte[] encodedSequence = new byte[TAG_SEQUENCE.length + lengthByteArray.length + sequence.length];
        System.arraycopy((byte[])TAG_SEQUENCE, (int)0, (byte[])encodedSequence, (int)0, (int)TAG_SEQUENCE.length);
        System.arraycopy((byte[])lengthByteArray, (int)0, (byte[])encodedSequence, (int)TAG_SEQUENCE.length, (int)lengthByteArray.length);
        System.arraycopy((byte[])sequence, (int)0, (byte[])encodedSequence, (int)(TAG_SEQUENCE.length + lengthByteArray.length), (int)sequence.length);
        return encodedSequence;
    }
}

