/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import java.security.AccessControlException;

public class Util {
    public static final byte END = -1;

    public static byte[] mergeBytes(byte[] array1, byte[] array2) {
        byte[] data = new byte[array1.length + array2.length];
        System.arraycopy((byte[])array1, (int)0, (byte[])data, (int)0, (int)array1.length);
        System.arraycopy((byte[])array2, (int)0, (byte[])data, (int)array1.length, (int)array2.length);
        return data;
    }

    public static byte[] getMid(byte[] array, int start, int length) {
        byte[] data = new byte[length];
        System.arraycopy((byte[])array, (int)start, (byte[])data, (int)0, (int)length);
        return data;
    }

    @Deprecated
    public static String bytesToString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b2 : bytes) {
            sb.append(String.format("%02x ", b2 & 0xFF));
        }
        String str = sb.toString();
        if (str.length() > 0) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static byte[] appendResponse(byte[] r1, byte[] r2, int length) {
        byte[] rsp = new byte[r1.length + length];
        System.arraycopy((byte[])r1, (int)0, (byte[])rsp, (int)0, (int)r1.length);
        System.arraycopy((byte[])r2, (int)0, (byte[])rsp, (int)r1.length, (int)length);
        return rsp;
    }

    public static String createMessage(String commandName, int sw) {
        StringBuilder message = new StringBuilder();
        if (commandName != null) {
            message.append(commandName).append(" ");
        }
        message.append("SW1/2 error: ");
        message.append(Integer.toHexString(sw | 0x10000).substring(1));
        return message.toString();
    }

    public static String createMessage(String commandName, String message) {
        if (commandName == null) {
            return message;
        }
        return commandName + " " + message;
    }

    @Deprecated
    public static String bytesToString(byte[] array, int offset, int length, String prefix) {
        if (array == null) {
            return null;
        }
        if (length == -1) {
            length = array.length - offset;
        }
        StringBuilder buffer = new StringBuilder();
        for (int ind = offset; ind < offset + length; ++ind) {
            buffer.append(prefix).append(Integer.toHexString(256 + (array[ind] & 0xFF)).substring(1));
        }
        return buffer.toString();
    }

    public static String getPackageNameFromCallingUid(Context context, int uid) {
        String[] packageName;
        PackageManager packageManager = context.getPackageManager();
        if (packageManager != null && (packageName = packageManager.getPackagesForUid(uid)) != null && packageName.length > 0) {
            return packageName[0];
        }
        throw new AccessControlException("Caller PackageName can not be determined");
    }

    public static byte setChannelToClassByte(byte cla, int channelNumber) {
        if (channelNumber < 4) {
            cla = (byte)(cla & 0xBC | channelNumber);
        } else if (channelNumber < 20) {
            boolean isSM = (cla & 0xC) != 0;
            cla = (byte)(cla & 0xB0 | 0x40 | channelNumber - 4);
            if (isSM) {
                cla = (byte)(cla | 0x20);
            }
        } else {
            throw new IllegalArgumentException("Channel number must be within [0..19]");
        }
        return cla;
    }

    public static byte clearChannelNumber(byte cla) {
        boolean isFirstInterindustryClassByteCoding;
        boolean bl = isFirstInterindustryClassByteCoding = (cla & 0x40) == 0;
        if (isFirstInterindustryClassByteCoding) {
            return (byte)(cla & 0xFC);
        }
        return (byte)(cla & 0xF0);
    }

    public static int parseChannelNumber(byte cla) {
        boolean isFirstInterindustryClassByteCoding;
        boolean bl = isFirstInterindustryClassByteCoding = (cla & 0x40) == 0;
        if (isFirstInterindustryClassByteCoding) {
            return cla & 3;
        }
        return (cla & 0xF) + 4;
    }
}

