/*
 * Decompiled with CFR 0.152.
 */
package org.simalliance.openmobileapi.service;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.IOException;
import java.util.Arrays;
import java.util.NoSuchElementException;

public class SmartcardError
implements Parcelable {
    private static final Class[] ALLOWED_EXCEPTIONS = new Class[]{IOException.class, SecurityException.class, NoSuchElementException.class, IllegalStateException.class, IllegalArgumentException.class, UnsupportedOperationException.class, NullPointerException.class};
    public static final Parcelable.Creator<SmartcardError> CREATOR = new Parcelable.Creator<SmartcardError>(){

        public SmartcardError createFromParcel(Parcel in) {
            return new SmartcardError(in);
        }

        public SmartcardError[] newArray(int size) {
            return new SmartcardError[size];
        }
    };
    private String mClazz;
    private String mMessage;

    public SmartcardError() {
        this.mClazz = "";
        this.mMessage = "";
    }

    private SmartcardError(Parcel in) {
        this.readFromParcel(in);
    }

    public void set(Exception e2) throws IllegalArgumentException {
        if (e2 == null) {
            throw new IllegalArgumentException("Cannot set a null exception");
        }
        Class<?> clazz = e2.getClass();
        if (!Arrays.asList(ALLOWED_EXCEPTIONS).contains(clazz)) {
            throw new IllegalArgumentException("Unexpected exception class: " + clazz.getCanonicalName());
        }
        this.mClazz = clazz.getCanonicalName();
        this.mMessage = e2.getMessage() != null ? e2.getMessage() : "";
    }

    public boolean isSet() {
        return this.mClazz != null && !this.mClazz.isEmpty();
    }

    public void throwException() throws IOException, SecurityException, NoSuchElementException, IllegalStateException, IllegalArgumentException, UnsupportedOperationException, NullPointerException {
        if (this.mClazz.equals(IOException.class.getCanonicalName())) {
            throw new IOException(this.mMessage);
        }
        if (this.mClazz.equals(SecurityException.class.getCanonicalName())) {
            throw new SecurityException(this.mMessage);
        }
        if (this.mClazz.equals(NoSuchElementException.class.getCanonicalName())) {
            throw new NoSuchElementException(this.mMessage);
        }
        if (this.mClazz.equals(IllegalStateException.class.getCanonicalName())) {
            throw new IllegalStateException(this.mMessage);
        }
        if (this.mClazz.equals(IllegalArgumentException.class.getCanonicalName())) {
            throw new IllegalArgumentException(this.mMessage);
        }
        if (this.mClazz.equals(UnsupportedOperationException.class.getCanonicalName())) {
            throw new UnsupportedOperationException(this.mMessage);
        }
        if (this.mClazz.equals(NullPointerException.class.getCanonicalName())) {
            throw new NullPointerException(this.mMessage);
        }
        Log.wtf((String)this.getClass().getSimpleName(), (String)("SmartcardError.throwException() finished without throwing exception. mClazz: " + this.mClazz));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mClazz);
        out.writeString(this.mMessage);
    }

    public void readFromParcel(Parcel in) {
        this.mClazz = in.readString();
        this.mMessage = in.readString();
    }
}

