/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip;

import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.datapersistence.DataPersistence;
import com.xdja.multichip.AccessControlManager;
import com.xdja.multichip.IMultiChipUnitePin;
import com.xdja.multichip.jniapi.JarJniApiProxy;
import com.xdja.multichip.jniapi.JarMultiJniApiManager;
import com.xdja.multichip.utils.SharedPreferencesUtil;
import com.xdja.unlockcode.UnlockCode;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MultiChipUnitePinBinder
extends IMultiChipUnitePin.Stub {
    private static final String TAG = "MultiChipUnitePinBinder";
    private static final String ACTION_SAFEPIN_ADD = "com.xdja.safepin.action.SAFEPIN_ADD";
    private static final String ACTION_SAFEPIN_DEL = "com.xdja.safepin.action.SAFEPIN_DEL";
    private static final String ACTION_SAFEPIN_CHANGED = "com.xdja.safepin.action.SAFEPIN_CHANGED";
    private static final String KEY_INTERFACE_JNIAPI = "JNIAPI";
    private static final String KEY_INTERFACE_SKFAPI = "SkfApi";
    private Map<String, Integer> cardPinCountMap = null;
    private static final int MULTI_BINDER_ERROR = -60002;
    private static MultiChipUnitePinBinder instance;
    private Context context;

    private MultiChipUnitePinBinder(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MultiChipUnitePinBinder getInstance(Context context) {
        if (context == null) {
            throw new InvalidParameterException("context is null");
        }
        if (instance != null) return instance;
        Class<MultiChipUnitePinBinder> clazz = MultiChipUnitePinBinder.class;
        synchronized (MultiChipUnitePinBinder.class) {
            if (instance != null) return instance;
            instance = new MultiChipUnitePinBinder(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public int handlePinResult(String cardId, int role, byte[] pin, int verifyResult, String method, int callingUid, int callingPid, String fromInterface) {
        Log.d((String)TAG, (String)("getPin,handlePinResult ret: " + verifyResult));
        if (this.isEmpty(cardId, pin, method, fromInterface)) {
            Log.d((String)TAG, (String)"getPin,handlePinResult data null ");
            return 0;
        }
        if (verifyResult == 0) {
            this.savePinToFile(cardId, role, pin);
            this.savePinTryCount(cardId, role);
        } else if (KEY_INTERFACE_SKFAPI.equalsIgnoreCase(fromInterface)) {
            if (verifyResult == 167772196 || verifyResult == 167772197 || verifyResult == 167772198 || verifyResult == 167772199 || verifyResult == 0xA00002A) {
                this.delPinFromFile(cardId, role);
            }
        } else if (KEY_INTERFACE_JNIAPI.equalsIgnoreCase(fromInterface)) {
            if (verifyResult == -10 || verifyResult == -16 || verifyResult == -31 || verifyResult == -32) {
                this.delPinFromFile(cardId, role);
            } else if (verifyResult > 0 || verifyResult < this.getPinTryMax(cardId, role)) {
                this.delPinFromFile(cardId, role);
            }
        }
        return 0;
    }

    private void savePinTryCount(String cardId, int role) {
        JarJniApiProxy proxy = this.getJarJniApiProxy(cardId);
        if (proxy == null) {
            return;
        }
        int ret = proxy.GetPinTryCount(role);
        if (ret > 0) {
            SharedPreferencesUtil.setPinTryCount(this.context, cardId, role, ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getPin(String cardId, int role) throws RemoteException {
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        int ret = AccessControlManager.getInstance(this.context).checkByUidPid(callingUid, callingPid, "getPin");
        Bundle bundle = new Bundle();
        if (ret != 0) {
            bundle.putInt("ret", ret);
            return bundle;
        }
        Class<MultiChipUnitePinBinder> clazz = MultiChipUnitePinBinder.class;
        synchronized (MultiChipUnitePinBinder.class) {
            try {
                Pair<Integer, Boolean> pair = this.judgePinEnable(this.context, cardId, role);
                Log.d((String)TAG, (String)("getPin,judgePinEnable =" + pair.second));
                Pair<String, byte[]> pinCrash = this.getCachePin(cardId, role);
                if ((Integer)pair.first != 0 || !Objects.equals(pair.second, Boolean.TRUE)) {
                    bundle.putInt("ret", -1);
                    if (pinCrash.second != null) {
                        this.delPinFromFile((String)pinCrash.first);
                        this.safePinDelBroadcast(role);
                    }
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return bundle;
                }
                if (pinCrash.second == null) {
                    bundle.putInt("ret", -1);
                    Log.d((String)TAG, (String)"getPin,getData failed");
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return bundle;
                }
                bundle.putInt("ret", 0);
                bundle.putString("pin", new String((byte[])pinCrash.second));
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return bundle;
            }
            catch (Exception e) {
                e.printStackTrace();
                bundle.putInt("ret", -1);
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return bundle;
            }
        }
    }

    private int delPinFromFile(String cardId, int role) {
        int ret = 0;
        Pair<String, byte[]> pair = this.getCachePin(cardId, role);
        if (pair != null && TextUtils.isEmpty((CharSequence)((CharSequence)pair.first)) && pair.second != null) {
            ret = this.delPinFromFile((String)pair.first);
            this.safePinDelBroadcast(role);
        }
        Log.v((String)TAG, (String)("delPinFromFile ret = " + ret));
        return ret;
    }

    private int savePinToFile(String cardId, int role, byte[] pin) {
        int ret = 0;
        Pair<String, byte[]> pair = this.getCachePin(cardId, role);
        if (pair != null && !TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            ret = this.savePinToFile((String)pair.first, pin);
            if (pair.second == null) {
                this.safePinAddBroadcast(role);
            } else if (!Arrays.equals((byte[])pair.second, pin)) {
                this.safePinChangedBroadcast(role);
            }
        }
        return ret;
    }

    private void safePinAddBroadcast(int role) {
        this.sendBroadcast(role, ACTION_SAFEPIN_ADD);
    }

    private void safePinDelBroadcast(int role) {
        this.sendBroadcast(role, ACTION_SAFEPIN_DEL);
    }

    private void safePinChangedBroadcast(int role) {
        this.sendBroadcast(role, ACTION_SAFEPIN_CHANGED);
    }

    private void sendBroadcast(int role, String action) {
        Intent intent = new Intent();
        intent.putExtra("role", role);
        intent.setAction(action);
        Log.d((String)TAG, (String)("sendBroadcast: " + action + " role: " + role));
        this.context.sendBroadcast(intent);
    }

    private Pair<String, byte[]> getCachePin(String cardId, int role) {
        String key = this.getPinKey(role, cardId.getBytes());
        if (key == null) {
            return Pair.create(null, null);
        }
        byte[] pin = this.getPinFromFile(key);
        return Pair.create((Object)key, (Object)pin);
    }

    private byte[] getPinFromFile(String key) {
        return DataPersistence.getInstance((Context)this.context).getData(key);
    }

    private int savePinToFile(String key, byte[] pin) {
        return DataPersistence.getInstance((Context)this.context).addData(key, pin);
    }

    private int delPinFromFile(String key) {
        return DataPersistence.getInstance((Context)this.context).deleteData(key);
    }

    private String getPinKey(int role, byte[] cardId) {
        if (cardId == null || cardId.length == 0) {
            return null;
        }
        String result = new String(cardId);
        result = result + "#" + role;
        return result;
    }

    private boolean isEmpty(Object ... objects) {
        Object object = null;
        for (Object object1 : objects) {
            object = object1;
            if (object == null) {
                return true;
            }
            if (object instanceof byte[] && ((byte[])object).length == 0) {
                return true;
            }
            if (object instanceof String && ((String)object).length() == 0) {
                return true;
            }
            if (!(object instanceof List) || ((List)object).size() != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle getUsn(String cardId) {
        Bundle retBundle = new Bundle();
        retBundle.putInt("ret", -20003);
        if (TextUtils.isEmpty((CharSequence)cardId)) {
            return retBundle;
        }
        Class<MultiChipUnitePinBinder> clazz = MultiChipUnitePinBinder.class;
        synchronized (MultiChipUnitePinBinder.class) {
            try {
                byte[] usn = new byte[14];
                byte[] uid = new byte[10];
                UnlockCode unlockCode = new UnlockCode();
                Log.d((String)TAG, (String)("card id : " + cardId.toLowerCase()));
                int ret = unlockCode.CID2UID(cardId.toLowerCase().getBytes(), uid);
                if (ret != 0) {
                    Log.d((String)TAG, (String)"CID2UID failed");
                    retBundle.putInt("ret", ret);
                } else {
                    Log.d((String)TAG, (String)("uid: " + new String(uid)));
                    ret = unlockCode.UID2USN(uid, usn);
                    Log.d((String)TAG, (String)("usn: " + new String(usn)));
                    retBundle.putString("usn", new String(usn));
                    retBundle.putInt("ret", ret);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return retBundle;
        }
    }

    private int getPinTryMax(String cardId, int role) {
        int count = SharedPreferencesUtil.getPinTryCount(this.context, cardId, role);
        if (count > 0) {
            return count;
        }
        JarJniApiProxy proxy = this.getJarJniApiProxy(cardId);
        if (proxy == null) {
            return 0;
        }
        XDJA_DEVINFO devInfo = new XDJA_DEVINFO();
        int ret = proxy.GetDevInfo(devInfo);
        if (ret != 0) {
            return 0;
        }
        int cardtype = devInfo.cardtype;
        return this.getPinTryCountByIdAndRole(role, cardtype);
    }

    private JarJniApiProxy getJarJniApiProxy(String cardId) {
        Pair makrPair = JarMultiJniApiManager.getInstance().make(this.context, cardId);
        if ((Integer)makrPair.first != 0 || makrPair.second == null) {
            return null;
        }
        JarJniApiProxy proxy = (JarJniApiProxy)makrPair.second;
        return proxy;
    }

    private Pair<Integer, Boolean> judgePinEnable(Context context, String cardId, int role) {
        int maxCount;
        Pair makePair = JarMultiJniApiManager.getInstance().make(context, cardId);
        if (makePair == null || (Integer)makePair.first != 0) {
            return Pair.create((Object)-1, (Object)false);
        }
        int pinTryCount = ((JarJniApiProxy)makePair.second).GetPinTryCount(role);
        if (pinTryCount == (maxCount = this.getPinTryMax(cardId, role))) {
            return Pair.create((Object)0, (Object)true);
        }
        return Pair.create((Object)0, (Object)false);
    }

    private int getPinTryCountByIdAndRole(int role, int cardType) {
        if (this.cardPinCountMap == null) {
            this.initCardPinCountMap();
        }
        if (this.cardPinCountMap.containsKey("" + cardType + role)) {
            return this.cardPinCountMap.get("" + cardType + role);
        }
        return 0;
    }

    private void initCardPinCountMap() {
        int role_0x01 = 1;
        int role_0x11 = 17;
        if (this.cardPinCountMap == null) {
            this.cardPinCountMap = new HashMap<String, Integer>();
            this.cardPinCountMap.put("535" + role_0x01, 5);
            this.cardPinCountMap.put("535" + role_0x11, 10);
            this.cardPinCountMap.put("531" + role_0x01, 5);
            this.cardPinCountMap.put("531" + role_0x11, 10);
            this.cardPinCountMap.put("512" + role_0x01, 5);
            this.cardPinCountMap.put("512" + role_0x11, 10);
            this.cardPinCountMap.put("1536" + role_0x01, 6);
            this.cardPinCountMap.put("1792" + role_0x01, 5);
            this.cardPinCountMap.put("1792" + role_0x11, 10);
        }
    }
}

