/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.board;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.xdja.multichip.process.SupperChipBinder;
import com.xdja.multichip.process.board.OnboardXdjaChipBinder;
import com.xdja.skfapi.DevInfo;
import com.xdja.skfapi.SkfApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class XdjaBinderManager {
    private SkfApi skfApi = new SkfApi();
    private static XdjaBinderManager instance;
    private Context context;
    private HashMap<String, OnboardXdjaChipBinder> iBinderHashMap = new HashMap();

    private XdjaBinderManager(Context context) {
        this.context = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XdjaBinderManager getInstance(Context context) {
        if (instance != null) return instance;
        Class<XdjaBinderManager> clazz = XdjaBinderManager.class;
        synchronized (XdjaBinderManager.class) {
            if (instance != null) return instance;
            instance = new XdjaBinderManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public List<IBinder> getAllXdjaChipBinder() {
        String namesStr;
        ArrayList<IBinder> chipBinders = new ArrayList<IBinder>();
        byte[] szDevNameList = new byte[260];
        int[] ulSize = new int[1];
        int ret = this.skfApi.EnumDev(1, szDevNameList, ulSize);
        if (ret == 0 && (namesStr = new String(szDevNameList)).contains("\u0000")) {
            String[] devNames;
            for (String devName : devNames = namesStr.split("\u0000")) {
                OnboardXdjaChipBinder chipBinder;
                if (this.iBinderHashMap.containsKey(devName)) {
                    chipBinder = this.iBinderHashMap.get(devName);
                } else {
                    block7: {
                        chipBinder = new OnboardXdjaChipBinder(this.context, devName);
                        DevInfo devInfo = new DevInfo();
                        try {
                            chipBinder.GetDevInfo(0L, devInfo);
                            short type = this.bytesToShort(Arrays.copyOfRange(devInfo.reserved, 35, 37));
                            if (type != 531 && type != 535) {
                            }
                            break block7;
                        }
                        catch (RemoteException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    this.iBinderHashMap.put(devName, chipBinder);
                }
                IBinder iBinder = (IBinder)SupperChipBinder.asInterface((IBinder)chipBinder);
                chipBinders.add(iBinder);
            }
        }
        return chipBinders;
    }

    private short bytesToShort(byte[] b) {
        short s = 0;
        short s0 = (short)(b[0] & 0xFF);
        short s1 = (short)(b[1] & 0xFF);
        s1 = (short)(s1 << 8);
        s = (short)(s0 | s1);
        return s;
    }
}

