/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.vhsm;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.xdja.multichip.process.SuperChipForCall;
import com.xdja.multichip.process.vhsm.VhsmProcessProvider;
import com.xdja.multichip.utils.PermissionUtil;

public class VhsmChipForCall
extends SuperChipForCall {
    public static final String NAME_PROCESS_VHSM = "vhsm";

    public VhsmChipForCall(Context context) {
        super(context);
    }

    @Override
    protected Class getProviderClass() {
        return VhsmProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_VHSM;
    }

    @Override
    public boolean isCanUse() {
        boolean flag = PermissionUtil.isGranted(this.context, "android.permission.READ_PHONE_STATE");
        return flag;
    }

    @Override
    public int getChipType() {
        return 16;
    }

    public Bundle createDefaultVhsm() {
        String authority = this.getProviderAuthority(this.context, this.getProviderClass().getName());
        if (TextUtils.isEmpty((CharSequence)authority)) {
            Log.e((String)"SuperChipForCall", (String)(this.getProviderClass().getName() + " authority is null."));
            return null;
        }
        Uri uri = Uri.parse((String)("content://" + authority));
        ContentResolver resolver = this.context.getContentResolver();
        Bundle bundle = resolver.call(uri, "CreateDefaultVhsm", "", null);
        return bundle;
    }
}

