package com.xdja.multichip;

import android.content.Context;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/6/7 <br/>
 */

public class AccessControlJni {

    static {
        try {
            System.loadLibrary("accesscontrol");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 可用
     */
    public final static int OK = 0;
    /**
     * 不可用
     */
    public final static int CAN_NOT_USE = -101;


    private Context context;

    public AccessControlJni(Context context){
        this.context = context;
    }

    /**
     * 检查包名，是否有权限使用method
     *
     * @param pkgName 包名
     * @param method  方法名
     * @return 0：有权限；其他：无权限
     */
    public native int checkByPkgName(String pkgName, String method);
}
