package com.xdja.multichip.process;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.xdja.jar.forcallprovider.ForCallProvider;
import com.xdja.multichip.param.ParamKeywords;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/12/27 <br/>
 */
public abstract class SuperChipForCall implements IChipForCall {

    public static final String TAG = "SuperChipForCall";

    protected Context context;

    public SuperChipForCall(Context context) {
        this.context = context;
    }

    @Override
    public List<Bundle> GetJniApiBinder() {
        boolean canUse = isCanUse();
        if (!canUse){
            return null;
        }
        String authority = getProviderAuthority(context, getProviderClass().getName());
        if (TextUtils.isEmpty(authority)) {
            Log.e(TAG, getProviderClass().getName() + " authority is null.");
            return null;
        }
        Uri uri = Uri.parse("content://" + authority);
        ContentResolver resolver = context.getContentResolver();
        Bundle bundle =  resolver.call(uri, "GetJniApiBinder", "", null);
        if (bundle == null){
            return null;
        }

        int ret;
        ret = bundle.getInt(ParamKeywords.KEY_int_ret);
        if (ret != 0){
            return null;
        }

        ArrayList<Bundle> result = bundle.getParcelableArrayList("result");
        return result;
    }

    protected abstract Class getProviderClass();


    /**
     * 获取要调用的Provider的Authority
     *
     * @param context
     * @param providerClassName
     * @return
     */
    public String getProviderAuthority(Context context, String providerClassName) {
        if (TextUtils.isEmpty(providerClassName) || context == null) {
            return "";
        }
        String pkgName = ForCallProvider.getCallPkg(context);
        if (TextUtils.isEmpty(pkgName)) {
            return "";
        }

        PackageManager pm = context.getPackageManager();
        ComponentName cn = new ComponentName(pkgName, providerClassName);
        String authority = "";
        try {
            ProviderInfo pi = pm.getProviderInfo(cn, PackageManager.GET_META_DATA);
            authority = pi.authority;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return authority;
    }


}
