package com.xdja.multichip.process.coveredcard;

import android.Manifest;
import android.content.Context;

import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperChipForCall;
import com.xdja.multichip.utils.PermissionUtil;

import java.util.ArrayList;
import java.util.List;


/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/12/27 <br/>
 */
public class CCChipForCall extends SuperChipForCall {

    public static final String NAME_PROCESS_CC = "coveredcard";

    public CCChipForCall(Context context) {
        super(context);
    }

    @Override
    protected Class getProviderClass() {
        return CCProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_CC;
    }

    @Override
    public boolean isCanUse() {
        List<String> permissions = new ArrayList<>();
        permissions.add(Manifest.permission.READ_SMS);
        permissions.add(Manifest.permission.SEND_SMS);
        permissions.add(Manifest.permission.RECEIVE_SMS);
        permissions.add(Manifest.permission.READ_CONTACTS);
        permissions.add(Manifest.permission.WRITE_CONTACTS);

        List<String> deniedPermissions = PermissionUtil.getDeniedPermissions(context, permissions);

        if (deniedPermissions.size() == 0) {
            return true;
        }
        return false;
    }

    @Override
    public int getChipType() {
        return JniApiParam.TYPE_COVERED;
    }
}
