package com.xdja.multichip.process.vhsm;

import android.content.Context;
import android.os.Bundle;
import android.util.Pair;

import com.xdja.multichip.jniapi.JarMultiChipStatusManager;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;

import java.io.File;
import java.util.ArrayList;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/11/16 <br/>
 */
public class VhsmJniApiHandle {

    private static VhsmJniApiHandle instance;

    public static VhsmJniApiHandle getInstance() {
        if (instance == null) {
            synchronized (VhsmJniApiHandle.class) {
                if (instance == null) {
                    instance = new VhsmJniApiHandle();
                }
            }
        }
        return instance;
    }

    protected ArrayList<Bundle> getDefaultCardInfo(Context context) {
        ArrayList<Bundle> list = new ArrayList<>();
        if (context == null) {
            return list;
        }

        Bundle defaultVhsm = getDefaultVhsm(context);
        if (defaultVhsm != null) {
            list.add(defaultVhsm);
        }
        return list;
    }

    /**
     * 得到默认虚拟卡；
     * 和{@link #createDefaultVhsm(Context)}不同的地方在于，先判断虚拟卡文件是否存在，如果存在再继续，如果不存在则不再继续直接返回
     *
     * @param context
     * @return
     */
    private Bundle getDefaultVhsm(Context context) {
        DefaultVhsmBean defaultBean = DefaultVhsmBean.make(context);
        try {
            File vhsmDatFile = defaultBean.getVhsmDatFile();
            if (vhsmDatFile.exists()) {
                VhsmJniapiBinder binder = VhsmJniapiBinder.make(context, defaultBean);
                Bundle bundle = convertToBundle(context, binder);
                return bundle;
            }
        } catch (VhsmBean.VhsmBeanException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 创建默认的虚拟卡
     *
     * @param context
     */
    public Bundle createDefaultVhsm(Context context) {

        DefaultVhsmBean defaultBean = DefaultVhsmBean.make(context);
        try {
            File vhsmDatFile = defaultBean.getVhsmDatFile();
            if (vhsmDatFile.exists()) {
                Bundle bundle = new Bundle();
                bundle.putInt(ParamKeywords.KEY_int_ret, JarMultiJniApiErrorCode.RET_VHSM_CHIP_EXIST);
                return bundle;
            }
            Pair<Integer, VhsmJniapiBinder> pair = VhsmJniapiBinder.create(context, defaultBean);
            Bundle bundle = convertToBundle(context, pair.second);
            bundle.putInt(ParamKeywords.KEY_int_ret, pair.first);
            return bundle;
        } catch (VhsmBean.VhsmBeanException e) {
            e.printStackTrace();
            int ret = defaultBean.handleVhsmBeanException(e);
            Bundle bundle = new Bundle();
            bundle.putInt(ParamKeywords.KEY_int_ret, ret);
            return bundle;
        }
    }

    private Bundle convertToBundle(Context context, VhsmJniapiBinder binder) {
        Bundle bundle = new Bundle();
        if (binder == null) {
            return bundle;
        }

        JniApiParam param = binder.getJniApiParam();
        if (param != null) {
            JarMultiChipStatusManager.getInstance().sendCardStatus(context, param.cardId, param.chipType, 1);

            bundle.putInt(ParamKeywords.KEY_int_ret, 0);
            bundle.putBinder(ParamKeywords.KEY_Binder_Binder, binder);
            bundle.putParcelable(ParamKeywords.KEY_Parcelable_JniApiParam, param);
            return bundle;
        }
        return null;
    }

}
