package com.xdja.multichip.process.vhsm;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Parcel;
import android.os.Process;
import android.os.RemoteException;
import android.util.Pair;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.InsideMultiChipUnitePinManager;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SupperJniApiBinder;
import com.xdja.vhsm.VHSMJNI;

import java.io.File;
import java.util.HashMap;
import java.util.Set;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/11/15 <br/>
 */
public class VhsmJniapiBinder extends SupperJniApiBinder {
    private static VhsmJniApi jniApi = new VhsmJniApi();

    private static final String TAG = "vhsm";

    private VhsmBean vhsmBean;

    private VhsmJniapiBinder(Context context, VhsmBean vhsmBean) {
        super(context);
        if (vhsmBean == null) {
            throw new NullPointerException("VhsmBean is null!");
        }
        this.vhsmBean = vhsmBean;
    }

    private static HashMap<VhsmBean, VhsmJniapiBinder> mapBinder = new HashMap<>();

    public static VhsmJniapiBinder make(Context context, VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (context == null || vhsmBean == null) {
            return null;
        }

        VhsmJniapiBinder binder = getBinderInMap(vhsmBean);
        if (binder == null) {
            binder = new VhsmJniapiBinder(context, vhsmBean);
            putBinderToMap(vhsmBean, binder);
        }
        return binder;
    }

    /**
     * 创建虚拟卡
     *
     * @param context
     * @param vhsmBean
     * @return
     * @throws VhsmBean.VhsmBeanException
     */
    public static Pair<Integer, VhsmJniapiBinder> create(Context context, VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (context == null || vhsmBean == null) {
            return Pair.create(JarMultiJniApiErrorCode.RET_PARAM_ERROR, null);
        }

        removeBinderInMap(vhsmBean);
        VhsmJniapiBinder binder = new VhsmJniapiBinder(context, vhsmBean);
        int ret = binder.init();
        if (ret == 0) {
            binder.clearPin(context, vhsmBean);
            putBinderToMap(vhsmBean, binder);
            return Pair.create(0, binder);
        }
        return Pair.create(ret, null);
    }

    private void clearPin(Context context, VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        InsideMultiChipUnitePinManager.getInstance().handlePinResult(
                context,
                vhsmBean.getCardId(),
                0x01,
                "".getBytes(),
                JNIAPI.XKR_KEY_NOT_EXIST,
                "init",
                Process.myUid(),
                Process.myPid(),
                "JNIAPI"
        );
        InsideMultiChipUnitePinManager.getInstance().handlePinResult(
                context,
                vhsmBean.getCardId(),
                0x11,
                "".getBytes(),
                JNIAPI.XKR_KEY_NOT_EXIST,
                "init",
                Process.myUid(),
                Process.myPid(),
                "JNIAPI"
        );
    }

    private static void putBinderToMap(VhsmBean vhsmBean, VhsmJniapiBinder binder) throws VhsmBean.VhsmBeanException {
        if (vhsmBean == null || binder == null) {
            return;
        }
        String cardId = vhsmBean.getCardId();
        Set<VhsmBean> vhsmSet = mapBinder.keySet();
        for (VhsmBean bean : vhsmSet) {
            try {
                if (bean.getCardId().equals(cardId)) {
                    removeBinderInMap(vhsmBean);
                    putBinderToMap(vhsmBean, binder);
                }
            } catch (VhsmBean.VhsmBeanException e) {
                removeBinderInMap(bean);
            }
        }
    }

    private static VhsmJniapiBinder getBinderInMap(VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (vhsmBean == null) {
            return null;
        }

        String cardId = vhsmBean.getCardId();
        String id = vhsmBean.getId();
        String filePath = vhsmBean.getVhsmDatFile().getAbsolutePath();
        String pwd = vhsmBean.getVhsmPwd();
        Set<VhsmBean> vhsmSet = mapBinder.keySet();
        for (VhsmBean bean : vhsmSet) {
            try {
                if (bean.getCardId().equals(cardId) &&
                        bean.getId().equals(id) &&
                        bean.getVhsmDatFile().getAbsolutePath().equals(filePath) &&
                        bean.getVhsmPwd().equals(pwd)) {
                    return mapBinder.get(bean);
                }
            } catch (VhsmBean.VhsmBeanException e) {
                removeBinderInMap(bean);
            }
        }
        return null;
    }


    /**
     * 去除
     *
     * @param vhsmBean
     * @throws VhsmBean.VhsmBeanException
     */
    private static void removeBinderInMap(VhsmBean vhsmBean) throws VhsmBean.VhsmBeanException {
        if (vhsmBean == null) {
            return;
        }
        String cardId = vhsmBean.getCardId();
        Set<VhsmBean> vhsmSet = mapBinder.keySet();
        for (VhsmBean bean : vhsmSet) {
            if (bean.getCardId().equals(cardId)) {
                VhsmJniapiBinder removeBinder = mapBinder.remove(bean);
                removeBinder.setUnable(FLAG_UNABLE);
                removeBinder.notifyClientProxyDeath();
            }
        }
    }

    @Override
    protected JNIAPI getApi() {
        return jniApi;
    }

    @Override
    protected int selfOpenDev() throws RemoteException {
        int ret = init();
        mHandle = 0;
        if (ret != 0) {
            return JNIAPI.XKR_NO_KEY;
        }

        int[] devNum = new int[1];
        ret = getApi().EnumDev(0, devNum);
        if (ret != 0) {
            return ret;
        }
        if (devNum[0] <= 0) {
            return JNIAPI.XKR_NO_KEY;
        }

        long[] handle = new long[1];
        ret = getApi().OpenDev(0, handle);
        if (ret == 0) {
            mHandle = handle[0];
        }
        return ret;
    }

    @Override
    protected int getChipType() {
        return JniApiParam.TYPE_VHSM;
    }

    @Override
    protected boolean isDevOnline(int errCode) throws RemoteException {
        if (errCode == JNIAPI.XKR_NO_HANDLE
                || errCode == VHSMJNI.XKR_DEV_NOT_FOUND
                || errCode == VHSMJNI.XKR_INVALID_PARA) {
            selfOpenDev();
            if (mHandle == 0) {
                return false;
            }
            return true;
        } else {
            return false;
        }
    }


    @SuppressLint("MissingPermission")
    private int init() {
        //虚拟卡文件为卡号
        try {
            File vhsmFile = vhsmBean.getVhsmDatFile();
            byte[] vhsmFilePath = vhsmFile.getAbsolutePath().getBytes();
            String pwd = vhsmBean.getVhsmPwd();
            String id = vhsmBean.getId();
            if (!vhsmFile.getParentFile().exists()){
                vhsmFile.getParentFile().mkdirs();
            }
            int ret = ((VhsmJniApi) getApi()).InitModule(vhsmFilePath, vhsmFilePath.length,
                    pwd.getBytes(), pwd.getBytes().length,
                    id.getBytes(), id.getBytes().length);
            return ret;
        } catch (VhsmBean.VhsmBeanException e) {
            e.printStackTrace();
            int ret = vhsmBean.handleVhsmBeanException(e);
            return ret;
        }
    }

    /**
     * 此binder不可用的标志。
     * 主要用于当虚拟卡创建成功后，虚拟卡文件又被删除了情况
     */
    int unableFlag = 0;

    private static final int FLAG_UNABLE = -1;

    private void setUnable(int flag) {
        unableFlag = flag;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (unableFlag == FLAG_UNABLE || !getVhsmFile().exists()) {
            reply.writeNoException();
            reply.writeInt(JarMultiJniApiErrorCode.RET_GET_BINDER_FAIL);
            notifyClientProxyDeath();
            return true;
        }

        return super.onTransact(code, data, reply, flags);
    }

    File vhsmFile;

    private File getVhsmFile() {
        if (vhsmFile == null) {
            try {
                vhsmFile = vhsmBean.getVhsmDatFile();
            } catch (VhsmBean.VhsmBeanException e) {
                e.printStackTrace();
            }
        }
        return vhsmFile;
    }
}
