package com.xdja.multichip.utils;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;

import java.util.ArrayList;
import java.util.List;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/4/10 <br/>
 */

public class PermissionUtil {

    public static List<String> getDeniedPermissions(Context context, List<String> permissions) {
        List<String> deniedPermissions = new ArrayList<>();
        for (String permission : permissions) {
            if (checkPermission(context, permission)) {
                //此时在系统检查没有此权限
                deniedPermissions.add(permission);
            }
        }
        return deniedPermissions;
    }

    static boolean checkPermission(Context context, String permission) {
        return checkSelfPermission(context, permission) == PackageManager.PERMISSION_DENIED;
    }

    public static boolean isGranted(Context context, String permission) {
        return checkSelfPermission(context, permission) == PackageManager.PERMISSION_GRANTED;
    }

    private static int checkSelfPermission(Context context, String permission) {
        if (permission == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return context.checkPermission(permission, android.os.Process.myPid(), Process.myUid());
    }
}
