/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process;

import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Pair;
import com.xdja.multichip.JNIPinManager;
import com.xdja.multichip.jniapi.Arithmetic;
import com.xdja.multichip.process.SupperHandleContainer;
import com.xdja.multichip.process.SupperJniApiBinder;
import com.xdja.multichip.process.SuppertImportCert;
import java.util.ArrayList;
import java.util.Arrays;

public class SupperHandleMethod {
    private static SupperHandleMethod instance;

    private SupperHandleMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SupperHandleMethod getInstance() {
        if (instance != null) return instance;
        Class<SupperHandleMethod> clazz = SupperHandleMethod.class;
        synchronized (SupperHandleMethod.class) {
            if (instance != null) return instance;
            instance = new SupperHandleMethod();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Bundle callMethod(SupperJniApiBinder binder, Bundle bundle) {
        Bundle result = new Bundle();
        try {
            if (bundle == null) {
                return null;
            }
            if (bundle.containsKey("method")) {
                String method = bundle.getString("method");
                if ("UnlockPinUseUsn".equals(method)) {
                    return this.UnlockPinUseUsn(binder, bundle);
                }
                if ("importCert".equals(method)) {
                    return new SuppertImportCert().importCert(binder, bundle);
                }
                if ("createContainer".equals(method)) {
                    return this.createContainer(binder, bundle);
                }
                if ("genSM2KeyPair".equals(method)) {
                    return this.genSignSM2KeyPair(binder, bundle);
                }
                if ("genExchangeSM2KeyPair".equals(method)) {
                    return this.genExchangeSM2KeyPair(binder, bundle);
                }
                if ("genRSAKeyPair".equals(method)) {
                    return this.genSignRSAKeyPair(binder, bundle);
                }
                if ("genExchangeRSAKeyPair".equals(method)) {
                    return this.genExchangeRSAKeyPair(binder, bundle);
                }
                if ("clearContainer".equals(method)) {
                    return this.clearContainer(binder, bundle);
                }
                if ("SendClientProxy".equals(method)) {
                    return this.addClientProxy(binder, bundle);
                }
            }
            result.putInt("ret", -10027);
        }
        catch (Exception e) {
            e.printStackTrace();
            result.putInt("ret", -10001);
        }
        return result;
    }

    public Bundle UnlockPinUseUsn(SupperJniApiBinder binder, Bundle bundle) {
        int role = bundle.getInt("role");
        byte[] usn = bundle.getByteArray("usn");
        byte[] usnlockCode = bundle.getByteArray("usnlockCode");
        byte[] newPin = bundle.getByteArray("newPin");
        int ret = JNIPinManager.getInstance().XdjaUnlockPinUseUsn(binder.getApi(), binder.mHandle, role, usn, usnlockCode, newPin);
        Bundle result = new Bundle();
        result.putInt("ret", ret);
        return result;
    }

    public Bundle createContainer(SupperJniApiBinder binder, Bundle bundle) {
        int ret;
        Bundle result = new Bundle();
        try {
            int role = bundle.getInt("role");
            String pin = bundle.getString("pin");
            int containerId = bundle.getInt("containerId");
            if ((containerId == 4 || containerId == 6) && role != 4 && role != 17) {
                result.putInt("ret", -15);
                return result;
            }
            ret = binder.VerifyPIN(binder.mHandle, role, pin.getBytes(), pin.length());
            if (ret != 0) {
                result.putInt("ret", ret);
                return result;
            }
            String containerName = bundle.getString("containerName");
            ret = new SupperHandleContainer().createContainer(binder, containerId, containerName);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            ret = -10001;
        }
        result.putInt("ret", ret);
        return result;
    }

    public Bundle genSignSM2KeyPair(SupperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt("containerId");
        byte[] pubFid = Arithmetic.getSignPubKeyFid((int)containerId);
        byte[] priFid = Arithmetic.getSignPriKeyFid((int)containerId);
        return this.genSM2KeyPair(binder, pubFid, priFid);
    }

    public Bundle genExchangeSM2KeyPair(SupperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt("containerId");
        byte[] pubFid = Arithmetic.getExchangePubKeyFid((int)containerId);
        byte[] priFid = Arithmetic.getExchangePriKeyFid((int)containerId);
        return this.genSM2KeyPair(binder, pubFid, priFid);
    }

    private Bundle genSM2KeyPair(SupperJniApiBinder binder, byte[] pubFid, byte[] priFid) {
        int ret;
        try {
            ret = binder.GenSM2KeyPair(binder.mHandle, pubFid, priFid, null, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            ret = -10001;
        }
        Bundle result = new Bundle();
        result.putInt("ret", ret);
        return result;
    }

    public Bundle genSignRSAKeyPair(SupperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt("containerId");
        int bits = bundle.getInt("bits");
        byte[] pubFid = Arithmetic.getSignPubKeyFid((int)containerId);
        byte[] priFid = Arithmetic.getSignPriKeyFid((int)containerId);
        return this.genRsaKeyPair(binder, bits, pubFid, priFid);
    }

    public Bundle genExchangeRSAKeyPair(SupperJniApiBinder binder, Bundle bundle) {
        int containerId = bundle.getInt("containerId");
        int bits = bundle.getInt("bits");
        byte[] pubFid = Arithmetic.getExchangePubKeyFid((int)containerId);
        byte[] priFid = Arithmetic.getExchangePriKeyFid((int)containerId);
        return this.genRsaKeyPair(binder, bits, pubFid, priFid);
    }

    private Bundle genRsaKeyPair(SupperJniApiBinder binder, int bits, byte[] pubFid, byte[] priFid) {
        int ret;
        try {
            ret = binder.GenRSAKeyPair(binder.mHandle, bits, pubFid, priFid, null, null);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            ret = -10001;
        }
        Bundle result = new Bundle();
        result.putInt("ret", ret);
        return result;
    }

    public Bundle clearContainer(SupperJniApiBinder binder, Bundle bundle) {
        Bundle result = new Bundle();
        int containerId = bundle.getInt("containerId", -1);
        int role = bundle.getInt("role");
        String pin = bundle.getString("pin", "");
        if (containerId != 0 || role != 1) {
            result.putInt("ret", -10000);
            return result;
        }
        try {
            int ret;
            byte[] exchangeCertFid = Arithmetic.getExchangeCertFid((int)containerId);
            byte[] signCertFid = Arithmetic.getSignCertFid((int)containerId);
            byte[] exchangePubFid = Arithmetic.getExchangePubKeyFid((int)containerId);
            byte[] exchangePriFid = Arithmetic.getExchangePriKeyFid((int)containerId);
            byte[] signPubFid = Arithmetic.getSignPubKeyFid((int)containerId);
            byte[] signPriFid = Arithmetic.getSignPriKeyFid((int)containerId);
            ArrayList<Pair> list = new ArrayList<Pair>();
            list.add(Pair.create((Object)exchangeCertFid, (Object)1));
            list.add(Pair.create((Object)exchangePubFid, (Object)2));
            list.add(Pair.create((Object)exchangePriFid, (Object)2));
            list.add(Pair.create((Object)signCertFid, (Object)1));
            list.add(Pair.create((Object)signPubFid, (Object)2));
            list.add(Pair.create((Object)signPriFid, (Object)2));
            byte[] certBytes = new byte[1536];
            byte[] keyBytes = new byte[256];
            Arrays.fill(certBytes, (byte)-1);
            Arrays.fill(keyBytes, (byte)-1);
            for (Pair pair : list) {
                byte[] writeBytes = (Integer)pair.second == 1 ? certBytes : keyBytes;
                ret = binder.VerifyPIN(binder.mHandle, role, pin.getBytes(), pin.length());
                if (ret != 0) {
                    result.putInt("ret", ret);
                    return result;
                }
                ret = binder.WriteFile(binder.mHandle, (byte[])pair.first, 0, writeBytes.length, writeBytes);
                if (ret == 0) continue;
                result.putInt("ret", ret);
                return result;
            }
            byte[] containerInfo = new byte[5];
            Arrays.fill(containerInfo, (byte)0);
            byte[] infoFid = new byte[]{0, 3};
            int writePos = containerId * 5;
            ret = binder.WriteFile(binder.mHandle, infoFid, writePos, 5, containerInfo);
            result.putInt("ret", ret);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            result.putInt("ret", -10001);
        }
        return result;
    }

    private Bundle addClientProxy(SupperJniApiBinder binder, Bundle bundle) {
        IBinder messenger = bundle.getBinder("messenger");
        binder.addClientProxy(messenger);
        Bundle result = new Bundle();
        result.putInt("ret", 0);
        return result;
    }
}

