/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process;

import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_SM2_PRIKEY;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.multichip.jniapi.Arithmetic;
import com.xdja.multichip.process.SupperHandleContainer;
import com.xdja.multichip.process.SupperJniApiBinder;
import com.xdja.multichip.utils.ConvertUtil;
import com.xdja.skfapi.EccCipherBlob;
import com.xdja.skfapi.EccPublicKeyBlob;
import com.xdja.skfapi.EnvelopedKeyBlob;
import java.util.Arrays;

public class SuppertImportCert {
    public Bundle importCert(SupperJniApiBinder binder, Bundle bundle) {
        Bundle result = new Bundle();
        Pair<Integer, String> pair = this.importCertOther(binder, bundle);
        result.putInt("ret", ((Integer)pair.first).intValue());
        result.putString("info", (String)pair.second);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pair<Integer, String> importCertOther(SupperJniApiBinder binder, Bundle bundle) {
        try {
            int type;
            int alg;
            byte[] certFid;
            byte[] signCert;
            String containerName;
            if (!(bundle.containsKey("version") && bundle.containsKey("certType") && bundle.containsKey("certAlg") && bundle.containsKey("signCert") && bundle.containsKey("dataType") && bundle.containsKey("pin") && bundle.containsKey("role") && bundle.containsKey("containerNo"))) {
                return Pair.create((Object)-2001, (Object)"");
            }
            int version = bundle.getInt("version");
            if (version != 1) {
                return Pair.create((Object)-2002, (Object)"Service support version is 1");
            }
            int certType = bundle.getInt("certType");
            int certAlg = bundle.getInt("certAlg");
            if (certType != 1 && certType != 2 && certType != 3) {
                return Pair.create((Object)-2003, (Object)("ImportCert type error: " + certType));
            }
            if (certAlg != 1 && certAlg != 2) {
                return Pair.create((Object)-2003, (Object)("ImportCert alg error: " + certAlg));
            }
            String pin = bundle.getString("pin");
            int role = bundle.getInt("role");
            int ret = binder.VerifyPIN(binder.mHandle, role, pin.getBytes(), pin.length());
            if (ret != 0) {
                return Pair.create((Object)-2004, (Object)("" + ret));
            }
            SupperHandleContainer handleContainer = new SupperHandleContainer();
            int containerNo = bundle.getInt("containerNo");
            ret = handleContainer.createContainer(binder, containerNo, containerName = "content " + containerNo);
            if (ret != 0 && ret != -23) {
                return Pair.create((Object)-2005, (Object)("" + ret));
            }
            if (certType == 2) {
                byte[] signCert2;
                byte[] exchangeCert;
                byte[] exchangePubKey;
                byte[] exchangePriKey;
                if (certAlg != 2) return Pair.create((Object)-2006, (Object)"");
                int dataType = bundle.getInt("dataType");
                if (dataType == 1) {
                    byte[] envelopedKeyBytes = bundle.getByteArray("envelopedKey");
                    if (envelopedKeyBytes == null) {
                        return Pair.create((Object)-2001, (Object)"envelopedKey lost.");
                    }
                    EnvelopedKeyBlob envelopedKey = this.getBean(envelopedKeyBytes);
                    if (envelopedKey == null) {
                        return Pair.create((Object)-2012, (Object)"Analysis EnvelopedKeyBlob error.");
                    }
                    byte[] signPriFid = Arithmetic.getSignPriKeyFid((int)containerNo);
                    exchangePriKey = this.getDecPriKey(binder, envelopedKey, signPriFid);
                    if (exchangePriKey == null) {
                        return Pair.create((Object)-2012, (Object)"Analysis exchangePriKey error.");
                    }
                    exchangePubKey = this.getPubKey(envelopedKey);
                    if (exchangePubKey == null) {
                        return Pair.create((Object)-2012, (Object)"Analysis exchangePubKey error.");
                    }
                    exchangeCert = bundle.getByteArray("exchangeCert");
                    signCert2 = bundle.getByteArray("signCert");
                } else {
                    if (dataType != 2) return Pair.create((Object)-2003, (Object)"ImportCert is double cert,but dataType is neither SKF nor NORMAL!");
                    exchangePriKey = bundle.getByteArray("exchangePriKey");
                    exchangePubKey = bundle.getByteArray("exchangePubKey");
                    exchangeCert = bundle.getByteArray("exchangeCert");
                    signCert2 = bundle.getByteArray("signCert");
                }
                Pair<Integer, String> writeCertPair = this.writeSM2DoubleCert(binder, containerNo, exchangePubKey, exchangePriKey, exchangeCert, signCert2);
                if ((Integer)writeCertPair.first != 0) {
                    return writeCertPair;
                }
            } else if (certType == 1) {
                signCert = bundle.getByteArray("signCert");
                if (certAlg != 2 && certAlg != 1) return Pair.create((Object)-2003, (Object)"");
                certFid = new byte[]{0, (byte)(44 + containerNo * 7)};
                ret = binder.WriteCert(binder.mHandle, certFid, signCert, signCert.length);
                if (ret != 0) {
                    return Pair.create((Object)-2011, (Object)("" + ret));
                }
            } else if (certType == 3) {
                signCert = bundle.getByteArray("signCert");
                if (certAlg != 2 && certAlg != 1) return Pair.create((Object)-2003, (Object)"");
                certFid = new byte[]{0, (byte)(41 + containerNo * 7)};
                ret = binder.WriteCert(binder.mHandle, certFid, signCert, signCert.length);
                if (ret != 0) {
                    return Pair.create((Object)-2010, (Object)("" + ret));
                }
            }
            if ((ret = handleContainer.updateContainer(binder, containerNo, alg = certAlg == 1 ? 0 : 1, type = certType == 1 ? 0 : (certType == 3 ? 1 : 2))) == 0) return Pair.create((Object)0, (Object)"");
            return Pair.create((Object)-2007, (Object)("" + ret));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Pair.create((Object)-2013, (Object)"");
        }
    }

    private Pair<Integer, String> writeSM2DoubleCert(SupperJniApiBinder binder, int containerNo, byte[] exchangePubKey, byte[] exchangePriKey, byte[] exchangeCert, byte[] signCert) throws RemoteException {
        if (exchangePubKey == null) {
            return Pair.create((Object)-2003, (Object)"exchangePubKey lost.");
        }
        if (exchangePriKey == null) {
            return Pair.create((Object)-2004, (Object)"exchangePriKey lost.");
        }
        if (exchangeCert == null) {
            return Pair.create((Object)-2003, (Object)"exchangeCert lost.");
        }
        if (signCert == null) {
            return Pair.create((Object)-2003, (Object)"signCert lost.");
        }
        byte[] exchangePubFid = Arithmetic.getExchangePubKeyFid((int)containerNo);
        XDJA_SM2_PUBKEY pubKey = new XDJA_SM2_PUBKEY();
        System.arraycopy(exchangePubKey, 0, pubKey.x, 0, pubKey.x.length);
        System.arraycopy(exchangePubKey, 32, pubKey.y, 0, pubKey.y.length);
        int ret = binder.WriteSm2PubKey(binder.mHandle, exchangePubFid, pubKey);
        if (ret != 0) {
            return Pair.create((Object)-2008, (Object)("" + ret));
        }
        byte[] exchangePriFid = Arithmetic.getExchangePriKeyFid((int)containerNo);
        XDJA_SM2_PRIKEY priKey = new XDJA_SM2_PRIKEY();
        if (exchangePriKey.length == 64) {
            System.arraycopy(exchangePriKey, 32, priKey.d, 0, priKey.d.length);
        } else {
            System.arraycopy(exchangePriKey, 0, priKey.d, 0, priKey.d.length);
        }
        ret = binder.WriteSm2PriKey(binder.mHandle, exchangePriFid, priKey);
        if (ret != 0) {
            return Pair.create((Object)-2009, (Object)("" + ret));
        }
        byte[] exchangeCertFid = Arithmetic.getExchangeCertFid((int)containerNo);
        ret = binder.WriteCert(binder.mHandle, exchangeCertFid, exchangeCert, exchangeCert.length);
        if (ret != 0) {
            return Pair.create((Object)-2010, (Object)("" + ret));
        }
        byte[] signCertFid = Arithmetic.getSignCertFid((int)containerNo);
        ret = binder.WriteCert(binder.mHandle, signCertFid, signCert, signCert.length);
        if (ret != 0) {
            return Pair.create((Object)-2011, (Object)("" + ret));
        }
        return Pair.create((Object)0, (Object)"");
    }

    private EnvelopedKeyBlob getBean(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        EnvelopedKeyBlob envelopedKey = new EnvelopedKeyBlob();
        int start = 0;
        int len = 4;
        envelopedKey.version = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = 4;
        envelopedKey.ulSymmAlgID = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = 4;
        envelopedKey.ulBits = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = 64;
        envelopedKey.cbEncryptedPriKey = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 132;
        envelopedKey.pubKey = this.getEccPublicKeyBlob(Arrays.copyOfRange(bytes, start, start + len));
        int tmpStart = start + len + 64 + 64 + 32;
        int tmpLen = 4;
        int eccCipherLen = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, tmpStart, tmpStart + tmpLen));
        start += len;
        len = 164 + eccCipherLen;
        envelopedKey.eccCipherBlob = this.getEccCipherBlob(Arrays.copyOfRange(bytes, start, start + len));
        return envelopedKey;
    }

    private EccPublicKeyBlob getEccPublicKeyBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        EccPublicKeyBlob eccPublicKeyBlob = new EccPublicKeyBlob();
        int start = 0;
        int len = 4;
        eccPublicKeyBlob.bitLen = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = 64;
        eccPublicKeyBlob.xCoordinate = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 64;
        eccPublicKeyBlob.yCoordinate = Arrays.copyOfRange(bytes, start, start + len);
        return eccPublicKeyBlob;
    }

    private EccCipherBlob getEccCipherBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        EccCipherBlob eccCipher = new EccCipherBlob();
        int start = 0;
        int len = 64;
        eccCipher.xXCoordinate = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 64;
        eccCipher.yCoordinate = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 32;
        eccCipher.hash = Arrays.copyOfRange(bytes, start, start + len);
        start += len;
        len = 4;
        eccCipher.cipherLen = ConvertUtil.bytesToInt(Arrays.copyOfRange(bytes, start, start + len));
        start += len;
        len = eccCipher.cipherLen;
        byte[] tmp = Arrays.copyOfRange(bytes, start, start + len);
        eccCipher.cipher = new byte[len];
        System.arraycopy(tmp, 0, eccCipher.cipher, 0, len);
        return eccCipher;
    }

    private byte[] getEccCipherBytes(EccCipherBlob eccCipher) {
        if (eccCipher == null) {
            return null;
        }
        int len = eccCipher.xXCoordinate.length / 2 + eccCipher.yCoordinate.length / 2 + eccCipher.hash.length + 4 + eccCipher.cipherLen;
        byte[] result = new byte[len];
        int start = 0;
        len = eccCipher.xXCoordinate.length / 2;
        System.arraycopy(eccCipher.xXCoordinate, len, result, start, len);
        start += len;
        len = eccCipher.yCoordinate.length / 2;
        System.arraycopy(eccCipher.yCoordinate, len, result, start, len);
        start += len;
        len = eccCipher.hash.length;
        System.arraycopy(eccCipher.hash, 0, result, start, len);
        start += len;
        len = 4;
        System.arraycopy(ConvertUtil.intToBytes(eccCipher.cipherLen), 0, result, start, len);
        start += len;
        len = eccCipher.cipher.length;
        System.arraycopy(eccCipher.cipher, 0, result, start, len);
        return result;
    }

    private byte[] getDecPriKey(SupperJniApiBinder binder, EnvelopedKeyBlob envelopedKey, byte[] signPriFid) throws RemoteException {
        int[] outLen;
        byte[] out;
        byte[] eccCipherBytes = this.getEccCipherBytes(envelopedKey.eccCipherBlob);
        int ret = binder.SM2DecryptGM(binder.mHandle, signPriFid, eccCipherBytes, eccCipherBytes.length, out = new byte[eccCipherBytes.length], outLen = new int[1]);
        if (ret != 0) {
            return null;
        }
        byte[] decPriKey = Arrays.copyOf(out, outLen[0]);
        byte[] priKey = new byte[envelopedKey.cbEncryptedPriKey.length];
        if (envelopedKey.ulSymmAlgID == 257) {
            ret = binder.SM1KEY(binder.mHandle, decPriKey, envelopedKey.cbEncryptedPriKey, envelopedKey.cbEncryptedPriKey.length, 0, priKey, null);
            if (ret != 0) {
                Log.w((String)"ImportCertLog", (String)("SM1KEY ret = " + ret));
                return null;
            }
        } else if (envelopedKey.ulSymmAlgID == 1025) {
            ret = binder.SM4KEY(binder.mHandle, decPriKey, envelopedKey.cbEncryptedPriKey, envelopedKey.cbEncryptedPriKey.length, 0, priKey, null);
            if (ret != 0) {
                Log.w((String)"ImportCertLog", (String)("SM4KEY ret = " + ret));
                return null;
            }
        } else {
            return null;
        }
        return priKey;
    }

    private byte[] getPubKey(EnvelopedKeyBlob envelopedKey) {
        byte[] pubKey = new byte[64];
        System.arraycopy(envelopedKey.pubKey.xCoordinate, 32, pubKey, 0, 32);
        System.arraycopy(envelopedKey.pubKey.yCoordinate, 32, pubKey, 32, 32);
        return pubKey;
    }
}

