/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.multichip.process.coveredcard.CCJniApi;
import com.xdja.multichip.process.coveredcard.CCProcessService;
import java.util.HashMap;

public class CCCacheManager {
    private static final String TAG = "CCCacheManager";
    private static CCCacheManager instance = new CCCacheManager();
    private XDJA_DEVINFO devInfo;
    private HashMap<String, Pair<byte[], Integer>> certMap = new HashMap();
    private CCJniApi ccJniApi = null;
    public static final String KEY_PARAM = "param_cc_cache";
    public static final String VALUE_NEW_CCJNIAPI_INSTANCE = "new_ccjniapi_instance";

    private CCCacheManager() {
    }

    public static CCCacheManager getInstance() {
        return instance;
    }

    public void setDevInfo(XDJA_DEVINFO devInfo) {
        this.devInfo = devInfo;
    }

    public void setCert(byte[] fid, byte[] certBuf, int certLen) {
        this.certMap.put(new String(fid), (Pair<byte[], Integer>)Pair.create((Object)certBuf, (Object)certLen));
    }

    public XDJA_DEVINFO getDevInfo() {
        if (this.devInfo == null) {
            return null;
        }
        return this.devInfo;
    }

    public Pair<byte[], Integer> getCert(byte[] fid) {
        return this.certMap.get(new String(fid));
    }

    public void clear() {
        this.devInfo = null;
        this.certMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CCJniApi getCCJniApi(Context context) {
        if (this.ccJniApi != null) return this.ccJniApi;
        Class<CCCacheManager> clazz = CCCacheManager.class;
        synchronized (CCCacheManager.class) {
            if (this.ccJniApi != null) return this.ccJniApi;
            this.ccJniApi = this.getCCJniApiFromService(context);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.ccJniApi;
        }
    }

    public void setCcJniApiForCCProcessService(CCJniApi ccJniApi) {
        Log.w((String)TAG, (String)("setCcJniApiForCCProcessService " + (Object)((Object)ccJniApi)));
        this.ccJniApi = ccJniApi;
    }

    private CCJniApi getCCJniApiFromService(Context context) {
        if (context == null) {
            Log.w((String)TAG, (String)"getCCJniApiFromService context null");
            return null;
        }
        Intent intent = new Intent();
        intent.putExtra(KEY_PARAM, VALUE_NEW_CCJNIAPI_INSTANCE);
        intent.setClass(context, CCProcessService.class);
        context.startService(intent);
        if (this.judgeCCJniApiInitOk() == 0) {
            return this.ccJniApi;
        }
        return null;
    }

    private int judgeCCJniApiInitOk() {
        int ret = 0;
        int singleWaitTime = 50;
        long realWaitTime = 0L;
        long waitTime = 1500L;
        long startTime = System.currentTimeMillis();
        block2: while (true) {
            try {
                long nowTime;
                while ((realWaitTime = (nowTime = System.currentTimeMillis()) - startTime) < waitTime) {
                    SystemClock.sleep((long)singleWaitTime);
                    Log.w((String)TAG, (String)("judgeCCJniApiInitOk " + (Object)((Object)this.ccJniApi)));
                    if (this.ccJniApi == null) continue;
                    break block2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        if (realWaitTime >= waitTime) {
            Log.w((String)TAG, (String)"isConnect--check timeout ");
            ret = -1;
        }
        return ret;
    }
}

