/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.multichip.utils;

import android.content.Context;
import android.os.Process;
import java.util.ArrayList;
import java.util.List;

public class PermissionUtil {
    public static List<String> getDeniedPermissions(Context context, List<String> permissions) {
        ArrayList<String> deniedPermissions = new ArrayList<String>();
        for (String permission2 : permissions) {
            if (!PermissionUtil.checkPermission(context, permission2)) continue;
            deniedPermissions.add(permission2);
        }
        return deniedPermissions;
    }

    static boolean checkPermission(Context context, String permission2) {
        return PermissionUtil.checkSelfPermission(context, permission2) == -1;
    }

    public static boolean isGranted(Context context, String permission2) {
        return PermissionUtil.checkSelfPermission(context, permission2) == 0;
    }

    private static int checkSelfPermission(Context context, String permission2) {
        if (permission2 == null) {
            throw new IllegalArgumentException("permission is null");
        }
        return context.checkPermission(permission2, Process.myPid(), Process.myUid());
    }
}

