package com.xdja.multichip.process.coveredcard;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import android.util.Pair;

import com.xdja.SafeKey.XDJA_DEVINFO;

import java.util.HashMap;

/**
 * @author: zhangxiaolong@xdja.com <br/>
 * date:   2018/4/2 <br/>
 */

public class CCCacheManager {
    private static final String TAG = "CCCacheManager";
    private static CCCacheManager instance = new CCCacheManager();
    private XDJA_DEVINFO devInfo;
    private HashMap<String, Pair<byte[], Integer>> certMap = new HashMap<>();

    private CCJniApi ccJniApi = null;

    private CCCacheManager() {
    }

    public static CCCacheManager getInstance(){
        return instance;
    }

    /**
     * 设置DevInfo缓存
     *
     * @param devInfo
     */
    public void setDevInfo(XDJA_DEVINFO devInfo) {
        this.devInfo = devInfo;
    }

    /**
     * 设置证书缓存
     *
     * @param fid
     * @param certBuf
     * @param certLen
     */
    public void setCert(byte[] fid, byte[] certBuf, int certLen) {
        certMap.put(new String(fid), Pair.create(certBuf, certLen));
    }

    public XDJA_DEVINFO getDevInfo(){
        if (devInfo == null){
            return null;
        }
        return devInfo;
    }

    public Pair<byte[],Integer> getCert(byte[] fid){
        return certMap.get(new String(fid));
    }

    /**
     * 清楚缓存
     */
    public void clear(){
        devInfo = null;
        certMap.clear();
    }

    //add 2018年4月2日19:09:21 weizg
    //缓存CCJniApi对象
    public CCJniApi getCCJniApi(Context context) {
        if (ccJniApi == null) {
            synchronized (CCCacheManager.class) {
                if (ccJniApi == null) {
                    ccJniApi = getCCJniApiFromService(context);
                }
            }
        }
        return ccJniApi;
    }

    public void setCcJniApiForCCProcessService(CCJniApi ccJniApi){

        Log.w(TAG, "setCcJniApiForCCProcessService " + ccJniApi);

        this.ccJniApi = ccJniApi;

        /*try{
            latch.countDown();
        }catch (Exception e){
            e.printStackTrace();
        }*/
    }

//    CountDownLatch latch = new CountDownLatch(1);
    public static final String KEY_PARAM = "param_cc_cache";
    public static final String VALUE_NEW_CCJNIAPI_INSTANCE = "new_ccjniapi_instance";

    private CCJniApi getCCJniApiFromService(Context context) {
        if(context == null){
            Log.w(TAG, "getCCJniApiFromService context null");
            return null;
        }


        Intent intent = new Intent();
        intent.putExtra(KEY_PARAM, VALUE_NEW_CCJNIAPI_INSTANCE);
        intent.setClass(context, CCProcessService.class);

        context.startService(intent);

        if(judgeCCJniApiInitOk() == 0){
            return ccJniApi;
        }


        return null;
    }

    /**
     * 判断是否连接成功
     */
    private int judgeCCJniApiInitOk() {
        int ret = 0;
        int singleWaitTime = 50;
        long realWaitTime = 0;
        long waitTime = 1500;

        long startTime = System.currentTimeMillis();
        while (true) {
            try {
                long nowTime = System.currentTimeMillis();
                realWaitTime = nowTime - startTime;
                if (realWaitTime >= waitTime) {
                    break;
                }

                SystemClock.sleep(singleWaitTime);

                Log.w(TAG, "judgeCCJniApiInitOk " + ccJniApi);

                if (ccJniApi != null) {
                    break;
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        if (realWaitTime >= waitTime) {

            Log.w(TAG, "isConnect--check timeout ");
            ret = -1;
        }

        return ret;
    }
}
