package com.xdja.multichip.process.tfcard;

import android.content.Context;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * tf card utils类
 * <br>author: wzg@xdja.com <br/>
 * date:   2017/6/6 19:50 <br/>
 */

public class TFCardUtils {
    private static String tag = "TFCardUtils";

    public static List<String> getAllExternalSdCardPath() {
        // TODO: 2017/6/7 weizg  如果设备支持同时使用两张tf卡，获取tf卡的方式方法需要测试
        List<String> externalSdCardPaths = new ArrayList<>();
        externalSdCardPaths.add(getNormalSDCardPath());

        return externalSdCardPaths;
    }

    /**
     * 获取扩展SD卡存储目录
     * <p>
     * 如果有外接的SD卡，并且已挂载，则返回这个外置SD卡目录 否则：返回内置SD卡目录
     *
     * @return
     */
    public static String getExternalSdCardPath() {

        // if (SDCardUtils.isMounted()) {
        // File sdCardFile = new
        // File(Environment.getExternalStorageDirectory().getAbsolutePath());
        // return sdCardFile.getAbsolutePath();
        // }

        String path = null;

        File sdCardFile = null;

        ArrayList<String> devMountList = getDevMountList();

        for (String devMount : devMountList) {
            File file = new File(devMount);

            if (file.isDirectory() && file.canWrite()) {
                path = file.getAbsolutePath();

                String timeStamp = new SimpleDateFormat("ddMMyyyy_HHmmss")
                        .format(new Date());
                File testWritable = new File(path, "test_" + timeStamp);

                if (testWritable.mkdirs()) {
                    testWritable.delete();
                } else {
                    path = null;
                }
            }
        }

        if (path != null) {
            sdCardFile = new File(path);
            return sdCardFile.getAbsolutePath();
        }

        return null;

    }


    /**
     * 遍历 "system/etc/vold.fstab” 文件，获取全部的Android的挂载点信息
     *
     * @return
     */
    private static ArrayList<String> getDevMountList() {

        //在魅族note2上，没有vold.fstab文件
        String[] toSearch = FileUtil.readFile("/system/etc/vold.fstab").split(
                " ");
        ArrayList<String> out = new ArrayList<String>();
        for (int i = 0; i < toSearch.length; i++) {
            if (toSearch[i].contains("dev_mount")) {
                if (new File(toSearch[i + 2]).exists()) {
                    out.add(toSearch[i + 2]);
                }
            }
        }
        return out;
    }


    /**
     * 获取sd卡路径 双sd卡时，根据”设置“里面的数据存储位置选择，获得的是内置sd卡或外置sd卡
     *
     * @return
     */
    public static String getNormalSDCardPath() {
        return Environment.getExternalStorageDirectory().getPath();
    }


    /**
     * 获取sd卡路径 双sd卡时，获得的是外置sd卡
     *
     * @return
     */
    public static String getSDCardPath() {
        String cmd = "cat /proc/mounts";
        Runtime run = Runtime.getRuntime();// 返回与当前 Java 应用程序相关的运行时对象
        BufferedInputStream in = null;
        BufferedReader inBr = null;
        try {
            Process p = run.exec(cmd);// 启动另一个进程来执行命令
            in = new BufferedInputStream(p.getInputStream());
            inBr = new BufferedReader(new InputStreamReader(in));

            String lineStr;
            while ((lineStr = inBr.readLine()) != null) {
                // 获得命令执行后在控制台的输出信息
                Log.i(tag, lineStr);
                if (lineStr.contains("sdcard")
                        && lineStr.contains(".android_secure")) {
                    String[] strArray = lineStr.split(" ");
                    if (strArray != null && strArray.length >= 5) {
                        String result = strArray[1].replace("/.android_secure",
                                "");
                        return result;
                    }
                }
                // 检查命令是否执行失败。
                if (p.waitFor() != 0 && p.exitValue() == 1) {
                    // p.exitValue()==0表示正常结束，1：非正常结束
                    Log.e(tag, "命令执行失败!");
                }
            }
        } catch (Exception e) {
            Log.e(tag, e.toString());
            // return Environment.getExternalStorageDirectory().getPath();
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inBr != null) {
                    inBr.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
//        return Environment.getExternalStorageDirectory().getPath();
        return "not find sdcard path";
    }

    public static String getPath2() {
        String sdcard_path = null;
        String sd_default = Environment.getExternalStorageDirectory()
                .getAbsolutePath();
        Log.d("text", sd_default);
        if (sd_default.endsWith("/")) {
            sd_default = sd_default.substring(0, sd_default.length() - 1);
        }
        // 得到路径
        try {
            Runtime runtime = Runtime.getRuntime();
            Process proc = runtime.exec("mount");
            InputStream is = proc.getInputStream();
            InputStreamReader isr = new InputStreamReader(is);
            String line;
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                if (line.contains("secure"))
                    continue;
                if (line.contains("asec"))
                    continue;
                if (line.contains("fat") && line.contains("/mnt/")) {
                    String columns[] = line.split(" ");
                    if (columns != null && columns.length > 1) {
                        if (sd_default.trim().equals(columns[1].trim())) {
                            continue;
                        }
                        sdcard_path = columns[1];
                    }
                } else if (line.contains("fuse") && line.contains("/mnt/")) {
                    String columns[] = line.split(" ");
                    if (columns != null && columns.length > 1) {
                        if (sd_default.trim().equals(columns[1].trim())) {
                            continue;
                        }
                        sdcard_path = columns[1];
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return sdcard_path;
    }


    /**
     * 获取可能是外置安全卡的所有路径
     *
     * @return
     */
    public static List<String> getSuspicionSDCardPath(Context context) {
        List<String> suspicionPaths = new ArrayList<>();

        context.getExternalFilesDir(null);

        String cmd = "cat /proc/mounts";
        Runtime run = Runtime.getRuntime();// 返回与当前 Java 应用程序相关的运行时对象
        BufferedInputStream in = null;
        BufferedReader inBr = null;
        try {
            Process p = run.exec(cmd);// 启动另一个进程来执行命令
            in = new BufferedInputStream(p.getInputStream());
            inBr = new BufferedReader(new InputStreamReader(in));

            String lineStr;
            while ((lineStr = inBr.readLine()) != null) {
                // 获得命令执行后在控制台的输出信息
//                Log.i(tag, lineStr);
                if (!TextUtils.isEmpty(lineStr)) {
                    String[] strArray = lineStr.split(" ");
                    if (strArray != null && strArray.length >= 5) {
                        String path = strArray[1];

                        if (isBackupPathByQuery(context,path)) {
//                        if(isBackupPathByCreateFile(context,path)){
                            Log.i(tag, path);

                            suspicionPaths.add(path);
                        }

                    }
                }
                // 检查命令是否执行失败。
                if (p.waitFor() != 0 && p.exitValue() == 1) {
                    // p.exitValue()==0表示正常结束，1：非正常结束
                    Log.e(tag, "命令执行失败!");
                }
            }
        } catch (Exception e) {
            Log.e(tag, e.toString());
            // return Environment.getExternalStorageDirectory().getPath();
        } finally {
            try {
                if (in != null) {
                    in.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (inBr != null) {
                    inBr.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }

        return suspicionPaths;
    }


    /**
     * 通过判断"{sdPath}/Android/data"目录是否存在来确定当前存储路径是否作为备选外置卡路径
     * 然后下一步通过执行安全卡命令方式来确定是否为安全芯片
     *
     * @param sdPath 待确定的存储路径
     * @return true -- 可作为备选； 否则返回false
     */
    private static boolean isBackupPathByQuery(Context context,String sdPath) {
        if (TextUtils.isEmpty(sdPath)) {
            return false;
        }

        String targetDirectorFilePath = sdPath + "/Android/data/"+ context.getPackageName();
        File targetDirectorFile = new File(targetDirectorFilePath);
        targetDirectorFile.mkdirs();

        return targetDirectorFile.exists();
    }

    /**
     * 该方法尝试在"sdPath/Android/data/{应用包名}"目录下创建一个文件来确定当前存储路径为备选外置卡；
     * 然后下一步在通过执行安全卡命令方式来确定是否为安全芯片卡
     *
     * @param context 上下文环境
     * @param sdPath  待确定的存储路径
     * @return true -- 可作为备选； 否则返回false
     */
    private static boolean isBackupPathByCreateFile(Context context, String sdPath) {
        if (TextUtils.isEmpty(sdPath)) {
            return false;
        }

        String targetDirectorFilePath = sdPath + "/Android/data/" + context.getPackageName() + "/test.log";
        File targetDirectorFile = new File(targetDirectorFilePath);

        boolean res = false;

        try {
            targetDirectorFile.createNewFile();

            res = true;

        } catch (IOException e) {
            e.printStackTrace();
        }


       /* if(targetDirectorFile.exists()){
            res = true;
        }else {
            try {
                targetDirectorFile.createNewFile();
            } catch (IOException e) {
                e.printStackTrace();
            }

            res = targetDirectorFile.exists();
        }*/

        return res;
    }

}