package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.os.Environment;

import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperChipForCall;

import java.io.File;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/5/15 <br/>
 */
public class NetVhsmChipForCall extends SuperChipForCall {

    public static final String NAME_PROCESS_NETVHSM = "netVhsm";

    public NetVhsmChipForCall(Context context) {
        super(context);
    }

    @Override
    protected Class getProviderClass() {
        return NetVhsmProcessProvider.class;
    }

    @Override
    public String getChipName() {
        return NAME_PROCESS_NETVHSM;
    }

    static final String FILE_DIR = "xdja/vhsm/net/";
    static final String randFilePath = FILE_DIR + "rand.bin";
    static final String kdatFilePath = FILE_DIR + "vhsm.dat";
    static final String wboxFilePath = FILE_DIR + "wbox.lib";

    @Override
    public boolean isCanUse() {
        File storageDir = Environment.getExternalStorageDirectory();
        File randFile = new File(storageDir, randFilePath);
        if (!randFile.exists()) {
            return false;
        }
        File wboxFile = new File(storageDir, wboxFilePath);
        if (!wboxFile.exists()) {
            return false;
        }
        File kdatFile = new File(storageDir, kdatFilePath);
        if (!kdatFile.exists()) {
            return false;
        }
        return true;
    }

    @Override
    public int getChipType() {
        return JniApiParam.TYPE_VHSM_NET;
    }
}
