package com.xdja.multichip.process.vhsm.net;

import android.os.Environment;
import android.os.FileObserver;
import android.os.Process;
import android.os.SystemClock;
import android.support.annotation.Nullable;

import java.io.File;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/5/24 <br/>
 */
public class NetVhsmFileListener {

    private static NetVhsmFileListener instance;

    static final String randFilePath = new File(Environment.getExternalStorageDirectory(), NetVhsmChipForCall.randFilePath).getAbsolutePath();
    static final String wboxFilePath = new File(Environment.getExternalStorageDirectory(), NetVhsmChipForCall.wboxFilePath).getAbsolutePath();

    private PriNetVhsmFileListener randListener;
    private PriNetVhsmFileListener wboxListener;

    public static NetVhsmFileListener getInstance() {
        if (instance == null) {
            synchronized (NetVhsmFileListener.class) {
                if (instance == null) {
                    instance = new NetVhsmFileListener();
                }
            }
        }
        return instance;
    }

    private NetVhsmFileListener() {
        if (randListener == null) {
            randListener = new PriNetVhsmFileListener(randFilePath);
        }
        if (wboxListener == null) {
            wboxListener = new PriNetVhsmFileListener(wboxFilePath);
        }
    }

    private int flagStart = 0;

    public void startObserver() {
        if (flagStart == 0) {
            randListener.startWatching();
            wboxListener.startWatching();
            flagStart = 1;
        }
    }


    private static final int FLAG_NOT_CHANGE = 0;
    private static final int FLAG_CHANGE = 1;
    private static int wboxChangeFlag = FLAG_NOT_CHANGE;

    static void setWboxChange() {
        wboxChangeFlag = FLAG_CHANGE;
    }

    static int getWboxChangeFlag() {
        return wboxChangeFlag;
    }

    static void setWboxNotChange() {
        wboxChangeFlag = FLAG_NOT_CHANGE;
    }

    class PriNetVhsmFileListener extends FileObserver {

        private String path;

        public PriNetVhsmFileListener(String path) {
            super(path);
            this.path = path;
        }

        @Override
        public void onEvent(final int event, @Nullable String path) {
            if (event == FileObserver.MODIFY) {
                if (wboxFilePath.equals(PriNetVhsmFileListener.this.path)) {
                    SystemClock.sleep(500);
                    if (getWboxChangeFlag() == FLAG_NOT_CHANGE) {
                        killSelf();
                    } else {
                        setWboxNotChange();
                    }
                } else {
                    killSelf();
                }
            }

        }
    }

    private static void killSelf() {
        SystemClock.sleep(500);
        Process.killProcess(Process.myPid());
    }

}
