package com.xdja.multichip.process.vhsm.net;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.RemoteException;
import android.util.Pair;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multi.unitepin.jar.MultiChipUnitePinManager;
import com.xdja.multichip.jniapi.JarMultiJniApiErrorCode;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.param.ParamKeywords;
import com.xdja.multichip.process.SupperJniApiBinder;
import com.xdja.vhsm.VHSMJNI;

import static com.xdja.multichip.jniapi.JarMultiJniApiErrorCode.RET_EXCEPTION;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2018/11/15 <br/>
 */
public class NetVhsmJniapiBinder extends SupperJniApiBinder {
    private static NetVhsmJniApi jniApi;

    private static final String TAG = "netVhsmTag";

    private static NetVhsmJniapiBinder instance;

    private NetVhsmJniapiBinder(Context context) {
        super(context);
        if (jniApi == null) {
            jniApi = new NetVhsmJniApi(context);
        }
        NetVhsmFileListener.getInstance().startObserver();
    }

    public static NetVhsmJniapiBinder getInstance(Context context) {
        if (instance == null) {
            synchronized (NetVhsmJniapiBinder.class) {
                if (instance == null) {
                    instance = new NetVhsmJniapiBinder(context);
                }
            }
        }
        return instance;
    }

    @Override
    protected JNIAPI getApi() {
        return getNetVHSMJniApi();
    }


    protected NetVhsmJniApi getNetVHSMJniApi() {
        return jniApi;
    }

    @Override
    protected int selfOpenDev() throws RemoteException {
        int ret;
        mHandle = 0;

        int[] devNum = new int[1];
        ret = getApi().EnumDev(0, devNum);
        if (ret != 0) {
            return ret;
        }
        if (devNum[0] <= 0) {
            return JNIAPI.XKR_NO_KEY;
        }

        long[] handle = new long[1];
        ret = getApi().OpenDev(0, handle);
        if (ret == 0) {
            mHandle = handle[0];
        }
        return ret;
    }

    @Override
    protected int getChipType() {
        return JniApiParam.TYPE_VHSM_NET;
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        if (bundle == null) {
            return null;
        }
        if (bundle.containsKey(ParamKeywords.KEY_String_method)) {
            String method = bundle.getString(ParamKeywords.KEY_String_method);
            if (ParamKeywords.KEY_METHOD_UnlockPinUseUsn.equals(method)) {
                return super.callMethod(bundle);
            } else if ("SM4".equals(method)) {
                return SM4(bundle);
            } else if ("SetCardChangeListener".equals(method)) {
                // TODO: 2019/5/20
//                return setCardChangeListener(bundle);
                return null;
            } else if (ParamKeywords.KEY_METHOD_clearContainer.equals(method)) {
                // TODO: 2019/5/20
                return super.callMethod(bundle);
                /*Bundle result = super.callMethod(bundle);
                if (result.getInt(ParamKeywords.KEY_int_ret) == 0) {
                    CCCacheManager.getInstance().clear();
                }
                return result;*/
            }
        }
        return super.callMethod(bundle);
    }


    private Bundle SM4(Bundle bundle) {
        Bundle result = new Bundle();
        byte[] dataIn = bundle.getByteArray("dataIn");
        int dataLen = bundle.getInt("dataLen");
        int flag = bundle.getInt("flag");
        byte kID = bundle.getByte("kID");
        byte[] IV = bundle.getByteArray("IV");

        byte[] dataOut = new byte[dataLen];
        int[] outLen = new int[2];

        //modify 2018年4月2日19:40:45 weizg
        // getCCJniApi有可能返回null
        int ret = RET_EXCEPTION;

        try {

            ret = getNetVHSMJniApi().SM4(mHandle, dataIn, dataLen, flag, dataOut, kID, IV);

            if (isDevOnline(ret)) {
                ret = getNetVHSMJniApi().SM4(mHandle, dataIn, dataLen, flag, dataOut, kID, IV);
            }
        } catch (Exception e) {
            e.printStackTrace();
            ret = RET_EXCEPTION;
        }
        result.putInt("ret", ret);
        result.putByteArray("dataOut", dataOut);
        result.putByteArray("IV", IV);

        return result;
    }

    @Override
    protected boolean isDevOnline(int errCode) throws RemoteException {
        if (errCode == JNIAPI.XKR_NO_HANDLE ||
                errCode == VHSMJNI.XKR_DEV_NOT_FOUND ||
                errCode == VHSMJNI.XKR_INVALID_PARA) {
            selfOpenDev();
            if (mHandle == 0) {
                return false;
            }
            return true;
        } else if (errCode == JNIAPI.XKR_NO_POWER) {
            String cardId = getCardId();
            Pair<Integer, String> pair = MultiChipUnitePinManager.getInstance().getPin(mContext, cardId, 0x11);
            if (pair != null && pair.first == 0) {
                String pin = pair.second;
                int ret = VerifyPIN(mHandle, 0x11, pin.getBytes(), pin.length());
                if (ret == 0) {
                    return true;
                }
            }
        }
        return false;
    }


    /**
     * 此binder不可用的标志。
     * 主要用于当虚拟卡创建成功后，虚拟卡文件又被删除了情况
     */
    int unableFlag = 0;

    private static final int FLAG_UNABLE = -1;

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (unableFlag == FLAG_UNABLE) {
            reply.writeNoException();
            reply.writeInt(JarMultiJniApiErrorCode.RET_GET_BINDER_FAIL);
            notifyClientProxyDeath();
            return true;
        }

        return super.onTransact(code, data, reply, flags);
    }

}
