package com.xdja.multichip;


import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.unlockcode.UnlockCode;

/**
 * Created by guoyaxin on 2017/6/20.
 */

public class JNIPinManager {

    private static JNIAPI jniapi = new JNIAPI();

    private static JNIPinManager jniPinManager;

    public static JNIPinManager getInstance() {

        if (jniPinManager == null) {
            synchronized (JNIPinManager.class) {
                if (jniPinManager == null) {
                    jniPinManager = new JNIPinManager();
                }
            }
        }
        return jniPinManager;
    }

    //为了保证同时兼容 板载芯片、TF卡和 蓝牙Key，故将对应的 JNIAPI 对象传进来  gyx 2017.9.6
    public int XdjaUnlockPin(JNIAPI jniapi, long handle, int role, byte[] key, byte[] newPin) {
        return jniapi.UnlockPIN(handle, role, key, key.length, newPin, newPin.length);
    }

    public int XdjaUnlockPinUseUsn(JNIAPI jniapi, long handle, int role, byte[] usn, byte[] usnlockCode, byte[] newPin) {
        int ret;
        if (usn == null || usnlockCode == null || usnlockCode.length != 32 || newPin == null) {
            ret = JNIAPI.XKR_DATA_PARAMETER;
        } else {
            UnlockCode unlockCode = new UnlockCode();
            byte[] nowpass = new byte[17];
            int[] len = {0};
            byte[] staticCode = new byte[17];

            ret = unlockCode.GenNowpass(usn, nowpass, len);
            if (ret != 0) {
                return ret;
            } else {
                ret = unlockCode.GetSCode(nowpass, len[0], usnlockCode, staticCode);
                if (ret != 0) {
                    return ret;
                } else {
                    ret = jniapi.ReloadPIN(handle, role, staticCode, 8,
                            newPin, newPin.length);
                }
            }
        }
        return ret;
    }

    /**
     * 得到cos版本信息
     *
     * @return 如果出错，返回空
     */
    public String getCosVer(XDJA_DEVINFO devinfo) {
        int length = devinfo.cosver.length;

        int index;
        for (index = length - 1; index >= 0; index--) {
            if (devinfo.cosver[index] != 0) {
                break;
            }

        }
        return new String(devinfo.cosver, 0, index + 1);
    }

}
