package com.xdja.multichip;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

/**
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2019/1/7 <br/>
 */
public class MultiJniApiConfig {
    private static MultiJniApiConfig instance;
    private Context context;

    private static final String Preference_Name = "MultiChipPreference";
    private static final String ASSET_FILE_NAME = "MultiChip.properties";

    private MultiJniApiConfig(Context context) {
        this.context = context.getApplicationContext();
        if (this.context == null) {
            this.context = context;
        }
    }

    /**
     * 获取实例
     *
     * @param context
     * @return
     */
    public static MultiJniApiConfig getInstance(Context context) {
        if (instance == null) {
            synchronized (MultiJniApiConfig.class) {
                if (instance == null) {
                    instance = new MultiJniApiConfig(context);
                }
            }
        }
        return instance;
    }

    /**
     * 判断芯片是否可用
     *
     * @param chipName
     * @return
     */
    public boolean judgeChipCanUse(String chipName) {
        if (TextUtils.isEmpty(chipName)) {
            return false;
        }
        String flagStr = getChipCanUseFlagInPreference(chipName);
        if (CanUseFlag.enable.name().equals(flagStr)) {
            return true;
        } else if (CanUseFlag.unable.name().equals(flagStr)) {
            return false;
        } else {
            return judgeChipCanUseFromProperties(chipName);
        }
    }


    /**
     * 设置芯片是否可用
     *
     * @param chipName
     * @param flag
     */
    public void setChipCanUseFlag(String chipName, CanUseFlag flag) {
        SharedPreferences preferences = context.getSharedPreferences(Preference_Name, Context.MODE_PRIVATE);
        SharedPreferences.Editor edit = preferences.edit();
        edit.putString(chipName, flag.name());
        edit.apply();
    }

    /**
     * 从Preference中获取标志位
     *
     * @param chipName
     * @return
     */
    private String getChipCanUseFlagInPreference(String chipName) {
        SharedPreferences preferences = context.getSharedPreferences(Preference_Name, Context.MODE_PRIVATE);
        return preferences.getString(chipName, CanUseFlag.defaulted.name());
    }

    private Properties multiCardProperties;

    private Properties getMultiCardFromProperties(Context context) {
        if (multiCardProperties == null) {
            try {
                multiCardProperties = new Properties();
                InputStream is = context.getAssets().open(ASSET_FILE_NAME);
                multiCardProperties.load(is);
                is.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return multiCardProperties;
    }

    /**
     * 从Properties中判断
     *
     * @param chipName
     * @return
     */
    public boolean judgeChipCanUseFromProperties(String chipName) {
        Properties properties = getMultiCardFromProperties(context);
        if (properties == null) {
            return true;
        }
        String value = properties.getProperty(chipName, "");

        if ("false".equals(value)) {
            return false;
        }
        return true;
    }

    public enum CanUseFlag {
        /**
         * 默认
         */
        defaulted("defaulted"),
        /**
         * 允许
         */
        enable("enable"),
        /**
         * 禁止
         */
        unable("unable");

        CanUseFlag(String s) {

        }
    }
}
