package com.xdja.multichip.process.board;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;

import com.watchdata.jwtclient.WdCallback;
import com.watchdata.jwtclient.WdJwtSDK;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SupperJniApiBinder;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/13 <br/>
 */

public class OnboardJniApiBinder extends SupperJniApiBinder {
    private static final String TAG = OnboardJniApiBinder.class.getSimpleName();

    JNIAPI jniapi = new JNIAPI();

    private static OnboardJniApiBinder instance;

    public static OnboardJniApiBinder getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (instance == null) {
            synchronized (OnboardJniApiBinder.class) {
                if (instance == null) {
                    instance = new OnboardJniApiBinder(context);
                }
            }
        }
        return instance;
    }

    private OnboardJniApiBinder(Context context) {
        super(context);
    }

    @Override
    protected JNIAPI getApi() {
        return jniapi;
    }

    @Override
    public int OpenDev(int index, long[] hHandle) throws RemoteException {
        int ret = getApi().OpenDev(index, hHandle);
        if (ret == 0) {
            mHandle = hHandle[0];
        } else {
            mHandle = 0;
        }
        return ret;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) throws RemoteException {
        Log.v(TAG, "This method(OpenDevByName) doesn't work!");
        return 0;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) throws RemoteException {
        Log.v(TAG, "This method(OpenDevByNameEx) doesn't work!");
        return 0;
    }

    /**
     * 内部方法：
     * 用于打开设备
     * [
     * modify by zhangxiaolong@xdja.com 2018-11-23
     * 加上缓存，第一目的是解决libsafekey中关于海思芯片EnumDev的bug；
     * 第二目的：加速芯片的查找速度。
     * ]
     *
     * @return
     */
    @Override
    protected int selfOpenDev() {
        int cardtype = Integer.valueOf(System.getProperty("_cardtype_", "-1"));
        if (cardtype == -1) {
            return initFirst();
        } else {
            if (cardtype == JNIAPI.CT_TPARTY) {
                return openThirdChip();
            } else {
                return initEnumOpenByCardType(cardtype);
            }
        }
    }

    /**
     * 第一次初始化(内存缓存变量的第一次)
     *
     * @return
     */
    private int initFirst() {
        int ret;
        long[] devHandle = new long[1];
        int[] devNum = new int[1];
        int devNumSum = 0;
        devInfo = null;
        try {
            //modify 2017年9月12日16:41:27 weizg 此处应该只枚举芯片类型的
            ret = EnumDev(JNIAPI.CT_TF_XDJA_CHIP, devNum);
            devNumSum = devNumSum + devNum[0];

            ret = EnumDev(JNIAPI.CT_XDJA_SPI, devNum);
            devNumSum = devNumSum + devNum[0];

            ret = EnumDev(JNIAPI.CT_TEESPI, devNum);
            devNumSum = devNumSum + devNum[0];
        } catch (RemoteException e) {
            e.printStackTrace();
            ret = -1;
        }

        if (devNumSum <= 0) {
            ret = -97;
        } else {
            try {
                ret = OpenDev(0, devHandle);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        //add by zhangxiaolong 2018-11-22，适配海思芯片
        if (ret != 0) {
            ret = openThirdChip();
        }
        return ret;
    }


    private int initEnumOpenByCardType(int cardtype) {
        int ret;
        long[] devHandle = new long[1];
        int[] devNum = new int[1];
        devInfo = null;
        try {
            //modify 2017年9月12日16:41:27 weizg 此处应该只枚举芯片类型的
            ret = EnumDev(cardtype, devNum);
        } catch (RemoteException e) {
            e.printStackTrace();
            ret = -97;
            return ret;
        }

        if (devNum[0] <= 0) {
            ret = -97;
        } else {
            try {
                ret = OpenDev(0, devHandle);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /**
     * 得到芯片类型，参看：{@link JniApiParam#TYPE_ONBOARD}, {@link JniApiParam#TYPE_TF}, {@link JniApiParam#TYPE_BLUETOOTH}
     *
     * @return
     */
    @Override
    protected int getChipType() {
        return JniApiParam.TYPE_ONBOARD;
    }

    @Override
    public JniApiParam getJniApiParam() {
        return super.getJniApiParam();
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        return super.callMethod(bundle);
    }

    private static final String haisiPkgName = "com.fri.sonicom.sectoken";
    private static final String haisiServiceNmae = "com.fri.service.ZDTokenService";
    private static final String woqiPkgName = "com.watchsmart.epurse.skfmanager";

    private int openThirdChip() {
        int ret;
        ret = openHaisi();
        if (ret == 0) {
            return ret;
        }
        ret = openWoqi();
        return ret;
    }

    private int openHaisi() {
        boolean flag = judgeAppExist(haisiPkgName);
        if (!flag) {
            return -97;
        }
        flag = bindHaisiService();
        if (!flag) {
            return -97;
        }
        long[] devHandle = new long[1];
        int[] devNum = new int[1];

        try {
            getApi().SetThirdPartySoName("libZDSkfInseApi.so".getBytes());
            CloseDev(mHandle);
            int ret = EnumDev(JNIAPI.CT_TPARTY, devNum);
            if (ret != 0 || devNum[0] <= 0) {
                return -97;
            }
            ret = OpenDev(0, devHandle);
            return ret;
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return -97;
    }

    private boolean bindHaisiService() {
        final boolean[] flag = {false};
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable() {
            @Override
            public void run() {
                Intent intent = new Intent();
                ComponentName com = new ComponentName(haisiPkgName, haisiServiceNmae);
                intent.setAction("com.fri.service.IZDTokenService");
                intent.setComponent(com);
                try {
                    flag[0] = mContext.bindService(intent, new ServiceConnection() {
                        @Override
                        public void onServiceConnected(ComponentName name, IBinder service) {
                            flag[0] = true;
                            latch.countDown();
                        }

                        @Override
                        public void onServiceDisconnected(ComponentName name) {

                        }
                    }, Service.BIND_AUTO_CREATE);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        try {
            latch.await(1500, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        return flag[0];
    }

    /**
     * 打开握奇海思芯片
     */
    private int openWoqi() {
        boolean flag = judgeAppExist(woqiPkgName);
        if (!flag){
            return -97;
        }
        final String[] mPath = new String[1];
        final CountDownLatch latch = new CountDownLatch(1);
        WdJwtSDK jwtSDK = new WdJwtSDK(mContext);
        jwtSDK.initSDK(new WdCallback() {
            @Override
            public void initResult(String token) {
                mPath[0] = token;
                latch.countDown();
            }
        });
        try {
            latch.await(5, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.d("wdskfapi", "path: " + mPath);
        if (TextUtils.isEmpty(mPath[0])) {
            return -97;
        } else {
            int ret = jniapi.SetThirdPartySoName("libwdskf.so".getBytes());
            if (ret != 0) {
                return -97;
            }

            ret = jniapi.SetThirdPartyParam(mPath[0].getBytes());
            if (ret != 0) {
                return -97;
            }

            int[] devNum = new int[1];
            ret = jniapi.EnumDev(0x900, devNum);
            if (ret != 0) {
                return -97;
            }

            long[] handles = new long[1];
            ret = jniapi.OpenDev(0, handles);
            if (ret != 0) {
                return -97;
            }
            mHandle = handles[0];
            return 0;
        }
    }


    private boolean judgeAppExist(String pkgName) {
        PackageManager pm = mContext.getPackageManager();
        try {
            pm.getPackageInfo(pkgName, 0);
            return true;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

}
