package com.xdja.multichip.process.board;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.multichip.anno.AutoChipForCall;
import com.xdja.multichip.param.JniApiParam;
import com.xdja.multichip.process.SuperJniApiBinder;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/13 <br/>
 */
@AutoChipForCall
public class OnboardJniApiBinder extends SuperJniApiBinder {
    private static final String TAG = OnboardJniApiBinder.class.getSimpleName();

    JNIAPI jniapi = new JNIAPI();

    private static OnboardJniApiBinder instance;

    public static OnboardJniApiBinder getInstance(Context context) {
        if (context == null) {
            return null;
        }
        if (instance == null) {
            synchronized (OnboardJniApiBinder.class) {
                if (instance == null) {
                    instance = new OnboardJniApiBinder(context);
                }
            }
        }
        return instance;
    }

    private OnboardJniApiBinder(Context context) {
        super(context);
    }

    @Override
    protected JNIAPI getApi() {
        return jniapi;
    }

    @Override
    public int OpenDev(int index, long[] hHandle) throws RemoteException {
        int ret = getApi().OpenDev(index, hHandle);
        if (ret == 0) {
            mHandle = hHandle[0];
        } else {
            mHandle = 0;
        }
        return ret;
    }

    @Override
    public int OpenDevByName(byte[] devName, long[] hHandle) throws RemoteException {
        Log.v(TAG, "This method(OpenDevByName) doesn't work!");
        return 0;
    }

    @Override
    public int OpenDevByNameEx(byte[] packagePath, long[] hHandle) throws RemoteException {
        Log.v(TAG, "This method(OpenDevByNameEx) doesn't work!");
        return 0;
    }

    /**
     * 内部方法：
     * 用于打开设备
     * [
     * modify by zhangxiaolong@xdja.com 2018-11-23
     * 加上缓存，第一目的是解决libsafekey中关于海思芯片EnumDev的bug；
     * 第二目的：加速芯片的查找速度。
     * ]
     *
     * @return
     */
    @Override
    protected int selfOpenDev() {
        return initFirst();
    }

    /**
     * 第一次初始化(内存缓存变量的第一次)
     *
     * @return
     */
    private int initFirst() {
        int ret;
        long[] devHandle = new long[1];
        int[] devNum = new int[1];
        int devNumSum = 0;
        devInfo = null;
        try {
            //modify 2017年9月12日16:41:27 weizg 此处应该只枚举芯片类型的
            ret = EnumDev(JNIAPI.CT_TF_XDJA_CHIP, devNum);
            devNumSum = devNumSum + devNum[0];

            ret = EnumDev(JNIAPI.CT_XDJA_SPI, devNum);
            devNumSum = devNumSum + devNum[0];

            ret = EnumDev(JNIAPI.CT_TEESPI, devNum);
            devNumSum = devNumSum + devNum[0];
        } catch (RemoteException e) {
            e.printStackTrace();
            ret = -1;
        }

        if (devNumSum <= 0) {
            ret = -97;
        } else {
            try {
                ret = OpenDev(0, devHandle);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }


    /**
     * 得到芯片类型，参看：{@link JniApiParam#TYPE_ONBOARD}, {@link JniApiParam#TYPE_TF}, {@link JniApiParam#TYPE_BLUETOOTH}
     *
     * @return
     */
    @Override
    protected int getChipType() {
        return JniApiParam.TYPE_ONBOARD;
    }

    @Override
    public JniApiParam getJniApiParam() {
        return super.getJniApiParam();
    }

    @Override
    public Bundle callMethod(Bundle bundle) throws RemoteException {
        return super.callMethod(bundle);
    }
}
