package com.xdja.multichip;

import android.content.ContentProviderClient;
import android.content.Context;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;

import com.xdja.multichip.utils.GetCallUri;

/**
 * author: zhangxiaolong@xdja.com <br/>
 * date:   2017/7/12 <br/>
 */

public class InsideMultiChipUnitePinManager {

    private static InsideMultiChipUnitePinManager instance;

    private InsideMultiChipUnitePinManager() {

    }

    public static InsideMultiChipUnitePinManager getInstance() {
        if (instance == null) {
            synchronized (InsideMultiChipUnitePinManager.class) {
                if (instance == null) {
                    instance = new InsideMultiChipUnitePinManager();
                }
            }
        }
        return instance;
    }

    /**
     * 调用统一PIN码服务
     *
     * @param cardId        卡号
     * @param role          角色
     * @param pin           正确的PIN码
     * @param verifyResult  验证的结果。比如：信大捷安的卡，验证正确了，结果为0，验证失败为1到9，-10或-16表示锁死
     * @param method        方法，比如：VerifyPIN,ChangePIN,ReloadPIN等
     * @param callingUid    调用method者的uid
     * @param callingPid    调用method者的pid
     * @param fromInterface 哪种类型的接口调用，比如：JNIAPI，SkfApi(国密接口)
     * @return
     */
    public int handlePinResult(Context context,
                               String cardId,
                               int role,
                               byte[] pin,
                               int verifyResult,
                               String method,
                               String fromInterface) {
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();

        IMultiChipUnitePin binder = getBinder(context);
        if (binder != null) {
            try {
                return binder.handlePinResult(cardId, role, pin, verifyResult, method, callingUid, callingPid, fromInterface);
            } catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    IMultiChipUnitePin unitePinBinder = null;

    /**
     * 获取binder
     *
     * @param context
     * @return
     */
    private IMultiChipUnitePin getBinder(Context context) {
        if (unitePinBinder != null) {
            return unitePinBinder;
        }
        Uri uri = GetCallUri.getUri(context);
        if (uri == null){
            return null;
        }
        ContentProviderClient client = context.getContentResolver().acquireContentProviderClient(uri);
        if (client == null) {
            return unitePinBinder;
        }
        try {
            Bundle bundle = client.call("GetBinder", "MultiChipUnitePinBinder", null);
            if (bundle != null) {
                int ret = bundle.getInt("ret");
                if (ret == 0) {
                    IBinder binder = bundle.getBinder("Binder");
                    if (binder != null) {
                        unitePinBinder = IMultiChipUnitePin.Stub.asInterface(binder);
                    }
                }
            }
        } catch (RemoteException e) {
            e.printStackTrace();
        }
        return unitePinBinder;
    }
}
