package com.xdja.multichip.process.board;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Log;

import com.watchdata.jwtclient.WdCallback;
import com.watchdata.jwtclient.WdJwtSDK;
import com.xdja.SafeKey.JNIAPI;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/**
 * 将原来放在 onboardJniApiBinder 中的关于其他公司的库，提取到了这里。
 * 但本类不再进行调用；
 * 本类的功能是让第三方应用（安全接入）重新实现的。
 * 需要在AndroidManifest.xml中的<application>的标签中声明一下：
 *  <meta-data android:name="具体的类名" android:value="OnboardThird"/>
 *
 * @author zhangxiaolong@xdja.com <br/>
 * @date 2021/8/16 <br/>
 */
public class ForThird {

    private static ForThird forThird = new ForThird();

    public static int open(Context context, JNIAPI jniapi, long[] devHandle) {
        int ret = forThird.openHaisi(context, jniapi, devHandle);
        if (ret == 0) {
            return ret;
        }
        return forThird.openWoqi(context, jniapi, devHandle);
    }


    private static final String HAISIPKGNAME = "com.fri.sonicom.sectoken";
    private static final String HAISISERVICENMAE = "com.fri.service.ZDTokenService";
    private static final String WOQIPKGNAME = "com.watchsmart.epurse.skfmanager";

    private int openHaisi(Context context, JNIAPI jniapi, long[] devHandle) {
        boolean flag = judgeAppExist(context, HAISIPKGNAME);
        if (!flag) {
            return -97;
        }
        flag = bindHaisiService(context);
        if (!flag) {
            return -97;
        }
        int[] devNum = new int[1];

        jniapi.SetThirdPartySoName("libZDSkfInseApi.so".getBytes());
        jniapi.CloseDev(devHandle[0]);
        int ret = jniapi.EnumDev(JNIAPI.CT_TPARTY, devNum);
        if (ret != 0 || devNum[0] <= 0) {
            return -97;
        }
        ret = jniapi.OpenDev(0, devHandle);
        return ret;
    }

    private boolean bindHaisiService(final Context context) {
        final boolean[] flag = {false};
        final CountDownLatch latch = new CountDownLatch(1);
        new Thread(new Runnable() {
            @Override
            public void run() {
                Intent intent = new Intent();
                ComponentName com = new ComponentName(HAISIPKGNAME, HAISISERVICENMAE);
                intent.setAction("com.fri.service.IZDTokenService");
                intent.setComponent(com);
                try {
                    flag[0] = context.bindService(intent, new ServiceConnection() {
                        @Override
                        public void onServiceConnected(ComponentName name, IBinder service) {
                            flag[0] = true;
                            latch.countDown();
                        }

                        @Override
                        public void onServiceDisconnected(ComponentName name) {

                        }
                    }, Service.BIND_AUTO_CREATE);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        try {
            latch.await(1500, TimeUnit.MILLISECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        return flag[0];
    }

    /**
     * 打开握奇海思芯片
     */
    private int openWoqi(Context context, JNIAPI jniapi, long[] devHandle) {
        boolean flag = judgeAppExist(context, WOQIPKGNAME);
        if (!flag) {
            return -97;
        }
        final String[] mPath = new String[1];
        final CountDownLatch latch = new CountDownLatch(1);
        WdJwtSDK jwtSDK = new WdJwtSDK(context);
        jwtSDK.initSDK(new WdCallback() {
            @Override
            public void initResult(String token) {
                mPath[0] = token;
                latch.countDown();
            }
        });
        try {
            latch.await(5, TimeUnit.SECONDS);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.d("wdskfapi", "path: " + mPath);
        if (TextUtils.isEmpty(mPath[0])) {
            return -97;
        } else {
            int ret = jniapi.SetThirdPartySoName("libwdskf.so".getBytes());
            if (ret != 0) {
                return -97;
            }

            ret = jniapi.SetThirdPartyParam(mPath[0].getBytes());
            if (ret != 0) {
                return -97;
            }

            int[] devNum = new int[1];
            ret = jniapi.EnumDev(0x900, devNum);
            if (ret != 0) {
                return -97;
            }

            ret = jniapi.OpenDev(0, devHandle);
            if (ret != 0) {
                return -97;
            }
            return 0;
        }
    }

    private boolean judgeAppExist(Context context, String pkgName) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(pkgName, 0);
            return true;
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }
}
